---
name: v.lrs.label
description: Creates stationing from input lines, and linear reference system.
keywords: [ vector, linear reference system, network ]
---

# v.lrs.label

Creates stationing from input lines, and linear reference system.

=== "Command line"

    **v.lrs.label**
    **input**=*name*
    **output**=*name*
    [**llayer**=*string*]
    [**rsdriver**=*string*]
    [**rsdatabase**=*string*]
    **rstable**=*string*
    [**labels**=*string*]
    [**offset**=*string* [,*string*,...]]
    [**xoffset**=*float*]
    [**yoffset**=*float*]
    [**reference**=*string*]
    [**font**=*string*]
    [**size**=*integer*]
    [**color**=*name*]
    [**width**=*integer*]
    [**highlight_color**=*name*]
    [**highlight_width**=*integer*]
    [**bgcolor**=*name*]
    [**border**=*name*]
    [**opaque**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.lrs.label input=name output=name rstable=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.lrs.label***",
        **input**,
        **output**,
        **llayer**=*"1"*,
        **rsdriver**=*"sqlite"*,
        **rsdatabase**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **rstable**,
        **labels**=*None*,
        **offset**=*"50,100,25,25"*,
        **xoffset**=*25*,
        **yoffset**=*5*,
        **reference**=*"center"*,
        **font**=*"standard"*,
        **size**=*100*,
        **color**=*"black"*,
        **width**=*1*,
        **highlight_color**=*"none"*,
        **highlight_width**=*0*,
        **bgcolor**=*"none"*,
        **border**=*"none"*,
        **opaque**=*"yes"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.lrs.label", input="name", output="name", rstable="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_lrs_label*(**input**,
        **output**,
        **llayer**=*"1"*,
        **rsdriver**=*"sqlite"*,
        **rsdatabase**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **rstable**,
        **labels**=*None*,
        **offset**=*"50,100,25,25"*,
        **xoffset**=*25*,
        **yoffset**=*5*,
        **reference**=*"center"*,
        **font**=*"standard"*,
        **size**=*100*,
        **color**=*"black"*,
        **width**=*1*,
        **highlight_color**=*"none"*,
        **highlight_width**=*0*,
        **bgcolor**=*"none"*,
        **border**=*"none"*,
        **opaque**=*"yes"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_lrs_label(input="name", output="name", rstable="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map where stationing will be written  
    **llayer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **labels**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label file  
    **offset**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;PM left, MP right, stationing left, stationing right offset  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50,100,25,25*  
    **xoffset**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in label x-direction in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25*  
    **yoffset**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in label y-direction in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **reference**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, left, right, upper, lower*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of text  
    &nbsp;&nbsp;&nbsp;&nbsp;Only for d.label output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **highlight_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **highlight_width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of highlight color  
    &nbsp;&nbsp;&nbsp;&nbsp;Only for d.label output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **border**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector  
    &nbsp;&nbsp;&nbsp;&nbsp;Only relevant if background color is selected  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map where stationing will be written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **llayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, Labels  
    **offset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;PM left, MP right, stationing left, stationing right offset  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50,100,25,25*  
    **xoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in label x-direction in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25*  
    **yoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in label y-direction in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **reference** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, left, right, upper, lower*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of text  
    &nbsp;&nbsp;&nbsp;&nbsp;Only for d.label output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **highlight_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **highlight_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of highlight color  
    &nbsp;&nbsp;&nbsp;&nbsp;Only for d.label output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **border** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector  
    &nbsp;&nbsp;&nbsp;&nbsp;Only relevant if background color is selected  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map where stationing will be written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **llayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, Labels  
    **offset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;PM left, MP right, stationing left, stationing right offset  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50,100,25,25*  
    **xoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in label x-direction in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25*  
    **yoffset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset label in label y-direction in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **reference** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference position  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *center, left, right, upper, lower*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (in map-units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of text  
    &nbsp;&nbsp;&nbsp;&nbsp;Only for d.label output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **highlight_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Highlight color for text  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **highlight_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width of highlight color  
    &nbsp;&nbsp;&nbsp;&nbsp;Only for d.label output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **border** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **opaque** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Opaque to vector  
    &nbsp;&nbsp;&nbsp;&nbsp;Only relevant if background color is selected  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *yes, no*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *yes*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.lrs.label* generates LRS labels for pretty-printing of a LRS. This
example is written for the Spearfish dataset (it continues the example
from *v.lrs.create*).

```sh
v.lrs.label route_lrs rstable=route_lrs output=route_lrs_labels \
            labels=labels col=red size=50 xoffset=100

g.region vector=route_lrs n=n+100 s=s-100 -p
d.erase
d.vect route_lrs
d.vect route_lrs_labels col=grey type=line
d.vect busstops disp=attr attr=cat size=10 bg=white lcol=green yref=bottom
d.vect busstops icon=basic/circle fcol=green
d.labels labels
```

## SEE ALSO

*[v.lrs.create](v.lrs.create.md), [v.lrs.segment](v.lrs.segment.md),
[v.lrs.where](v.lrs.where.md), [d.labels](d.labels.md),
[v.label](v.label.md)*

*[LRS tutorial](lrs.md),  
[Introducing the Linear Reference System in
GRASS](https://foss4g.asia/2004/Full-Paper_PDF/Introducing-the-Linear-Reference-System-in-GRASS.pdf)*

## AUTHORS

Radim Blazek, ITC-irst/MPA Solutions  
Documentation update (based on above journal article and available
fragments): Markus Neteler

## SOURCE CODE

Available at: [v.lrs.label source code](https://github.com/OSGeo/grass/tree/main/vector/v.lrs/v.lrs.label)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.lrs/v.lrs.label))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
