---
name: v.out.gps.py
description: Exports a vector map to a GPS receiver or file format supported by GPSBabel.
keywords: [ vector, export, GPS ]
---

# v.out.gps.py

Exports a vector map to a GPS receiver or file format supported by GPSBabel.

=== "Command line"

    **v.out.gps.py**
    [**-wrt**]
    **input**=*name*
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**format**=*string*]
    [**layer**=*string*]
    [**where**=*sql_query*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.gps.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.gps.py***",
        **input**,
        **type**=*"point,centroid,line,boundary"*,
        **output**,
        **format**=*"gpx"*,
        **layer**=*"1"*,
        **where**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.gps.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_gps_py*(**input**,
        **type**=*"point,centroid,line,boundary"*,
        **output**,
        **format**=*"gpx"*,
        **layer**=*"1"*,
        **where**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_gps_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid, line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,centroid,line,boundary*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file or GPS device  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;GPSBabel supported output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gpx*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export as waypoints  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export as routes  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export as tracks  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid, line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,centroid,line,boundary*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file or GPS device  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GPSBabel supported output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gpx*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*, *r*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export as waypoints  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export as routes  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export as tracks  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid, line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,centroid,line,boundary*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file or GPS device  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GPSBabel supported output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gpx*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*, *r*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export as waypoints  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export as routes  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export as tracks  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.gps* allows the user to export waypoint, route, and track data
from a vector map into a locally connected GPS receiver or as a file in
many common GPS data formats. Translation is done via the
*[GPSBabel](https://www.gpsbabel.org)* program.

Do not use as a primary means of navigation. This program is distributed
in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE. See the GNU General Public License (GPL) for more details.

## NOTES

*v.out.gps* automatically reprojects data from the projection settings
of the current location to Lat/Lon WGS84.

GPX format is used for data interchange between GRASS and GpsBabel. If
the requested output is GPX, then `gpsbabel` is never run.

OGR's GPX driver knows a number of standard field names. If an attribute
column matches the name it will be used in that field. Otherwise the
attribute will be placed within the `<extensions>` metadata section of
the record. Not all fields names are used with all feature types (e.g.
DOP fix error is not meaningful for route lines). You can use the
*v.db.renamecolumn* module to rename columns.

These are the standard GPX data fields known to OGR:

```text
ageofdgpsdata
cmt:     Comment
course
desc
dgpsid:  DGPS station type
ele:     Elevation
fix
geoidheight
hdop:    Horizontal dillution of precision (estimated fix error)
magvar:  Magnetic variation
name
number
pdop:    Positional dillution of precision (estimated fix error)
route_fid
route_point_id
sat
speed
src
sym
time
track_fid
track_seg_id
track_seg_point_id
type
url
urlname
vdop:    Vertical dillution of precision (estimated fix error)
```

## EXAMPLES

### GPX Export

Export a vector lines map to a GPX track file:

```sh
v.out.gps -t input=trail output=trail.gpx
```

### GPS device connected via USB adapter

Export vector maps named *waypoints, tracks, routes* to a Garmin GPS
connected to /dev/ttyUSB0:

```sh
v.out.gps -w input=waypoints format=garmin output=/dev/ttyUSB0
v.out.gps -t input=tracks format=garmin output=/dev/ttyUSB0
v.out.gps -r input=routes format=garmin output=/dev/ttyUSB0
```

## SEE ALSO

*[m.proj](https://grass.osgeo.org/grass-stable/manuals/m.proj.html),
[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html),
[v.out.ascii](https://grass.osgeo.org/grass-stable/manuals/v.out.ascii.html),
[v.db.renamecolumn](https://grass.osgeo.org/grass-stable/manuals/v.db.renamecolumn.html),
[v.extract](https://grass.osgeo.org/grass-stable/manuals/v.extract.html)*

[GpsBabel.org](https://www.gpsbabel.org)  
The [GDAL/OGR GPX format
page](https://gdal.org/drivers/vector/gpx.html)  
cs2cs from [PROJ.4](https://proj.org)  

## AUTHOR

Hamish Bowman, Dunedin, New Zealand

## SOURCE CODE

Available at: [v.out.gps source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.out.gps)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.out.gps))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
