---
name: v.out.png.py
description: Export vector map as PNG
keywords: [ vector, export, PNG ]
---

# v.out.png.py

Export vector map as PNG

=== "Command line"

    **v.out.png.py**
    [**-w**]
    **input**=*name*
    **output**=*name*
    [**rgb_column**=*string*]
    [**compression**=*integer*]
    [**width**=*integer*]
    [**height**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.png.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.png.py***",
        **input**,
        **output**,
        **rgb_column**=*None*,
        **compression**=*6*,
        **width**=*640*,
        **height**=*480*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.png.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_png_py*(**input**,
        **output**,
        **rgb_column**=*None*,
        **compression**=*6*,
        **width**=*640*,
        **height**=*480*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_png_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **rgb_column**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    **compression**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression level of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;(0 = none, 1 = fastest, 9 = best)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *640*  
    **height**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *480*  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output world file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    **compression** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression level of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;(0 = none, 1 = fastest, 9 = best)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *640*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *480*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output world file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    **compression** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression level of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;(0 = none, 1 = fastest, 9 = best)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *640*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *480*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output world file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.png* exports a GRASS vector map in non-georeferenced Portable
Network Graphics (PNG) image format, respecting the current region
resolution and bounds. By default it look for a color table, set using
[v.colors](https://grass.osgeo.org/grass-stable/manuals/v.colors.html)
you can also set the attribute table where read the feature color.

Optionally the user can choose to export a World File (.wld) to provide
basic georeferencing support using the **-w** flag.

## SEE ALSO

*[r.out.png](https://grass.osgeo.org/grass-stable/manuals/r.out.png.html),
[r.out.gdal](https://grass.osgeo.org/grass-stable/manuals/r.out.gdal.html),
[r.in.png](https://grass.osgeo.org/grass-stable/manuals/r.in.png.html),
[v.colors.png](https://grass.osgeo.org/grass-stable/manuals/v.colors.html)*

## AUTHORS

Luca Delucchi  
World file support by Anika Bettge and Markus Neteler

## SOURCE CODE

Available at: [v.out.png source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.out.png)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.out.png))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
