---
name: v.rast.bufferstats.py
description: Calculates statistics of raster map(s) for buffers around vector geometries.
keywords: [ vector, raster, buffer, statistics ]
---

# v.rast.bufferstats.py

Calculates statistics of raster map(s) for buffers around vector geometries.

=== "Command line"

    **v.rast.bufferstats.py**
    [**-tpurl**]
    **input**=*name*
    **raster**=*name* [,*name*,...]
    **buffers**=*integer* [,*integer*,...]
    **type**=*string* [,*string*,...]
    [**layer**=*string*]
    **column_prefix**=*string* [,*string*,...]
    [**methods**=*string* [,*string*,...]]
    [**percentile**=*integer*]
    [**output**=*name*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.rast.bufferstats.py input=name raster=name buffers=0 type=points,lines,areas column_prefix=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.rast.bufferstats.py***",
        **input**,
        **raster**,
        **buffers**,
        **type**=*"points,lines,areas"*,
        **layer**=*"1"*,
        **column_prefix**,
        **methods**=*"number,number_null,minimum,maximum,range,sum,average,average_abs,stddev,variance,coeff_var,first_quartile,median,third_quartile"*,
        **percentile**=*None*,
        **output**=*None*,
        **separator**=*"|"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.rast.bufferstats.py", input="name", raster="name", buffers=0, type="points,lines,areas", column_prefix="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_rast_bufferstats_py*(**input**,
        **raster**,
        **buffers**,
        **type**=*"points,lines,areas"*,
        **layer**=*"1"*,
        **column_prefix**,
        **methods**=*"number,number_null,minimum,maximum,range,sum,average,average_abs,stddev,variance,coeff_var,first_quartile,median,third_quartile"*,
        **percentile**=*None*,
        **output**=*None*,
        **separator**=*"|"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_rast_bufferstats_py(input="name", raster="name", buffers=0, type="points,lines,areas", column_prefix="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map containing geometries to compute buffer statistics for  
    **raster**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to calculate statistics from  
    **buffers**=*integer* [,*integer*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance(s) in map units  
    **type**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector type to work on  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *points, lines, areas*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *points,lines,areas*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column_prefix**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Column prefix for new attribute columns  
    **methods**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;The methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *number, number_null, minimum, maximum, range, sum, average, average_abs, stddev, variance, coeff_var, first_quartile, median, third_quartile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *number,number_null,minimum,maximum,range,sum,average,average_abs,stddev,variance,coeff_var,first_quartile,median,third_quartile*  
    **percentile**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if "-" output to stdout)  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator in output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *|*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Tabulate area within buffers for categories in raster map(s)  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Used with -t flag will return percentage of area for categories  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update columns if they already exist  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove columns without data  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use labels for column names if possible  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map containing geometries to compute buffer statistics for  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to calculate statistics from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **buffers** : int | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance(s) in map units  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector type to work on  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *points, lines, areas*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *points,lines,areas*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column_prefix** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column prefix for new attribute columns  
    **methods** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *number, number_null, minimum, maximum, range, sum, average, average_abs, stddev, variance, coeff_var, first_quartile, median, third_quartile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *number,number_null,minimum,maximum,range,sum,average,average_abs,stddev,variance,coeff_var,first_quartile,median,third_quartile*  
    **percentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator in output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *|*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *p*, *u*, *r*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tabulate area within buffers for categories in raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Used with -t flag will return percentage of area for categories  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update columns if they already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove columns without data  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use labels for column names if possible  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map containing geometries to compute buffer statistics for  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to calculate statistics from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **buffers** : int | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance(s) in map units  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector type to work on  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *points, lines, areas*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *points,lines,areas*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column_prefix** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column prefix for new attribute columns  
    **methods** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *number, number_null, minimum, maximum, range, sum, average, average_abs, stddev, variance, coeff_var, first_quartile, median, third_quartile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *number,number_null,minimum,maximum,range,sum,average,average_abs,stddev,variance,coeff_var,first_quartile,median,third_quartile*  
    **percentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator in output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *|*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *p*, *u*, *r*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tabulate area within buffers for categories in raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Used with -t flag will return percentage of area for categories  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update columns if they already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove columns without data  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use labels for column names if possible  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The purpose of the *v.rast.bufferstats* module is to provide local
environmental context to a series of input geometries. It computes
statistics from multiple input raster maps within multiple buffers
around selected geometries in the input vector map.

Available statistics are either

1. statistics provided by *r.univar* or
2. if the *t-flag* is checked - area of, number of and/or the most
    frequent (mode) raster categories within the buffers using
    *r.stats*.

If the *output* option is specified, results are written to a text file
or stdout instead of the attribute table of the input map. The output
file is produced with the following column order:  
cat | prefix | buffer| statistic/measure | value  
separated by the user defined separator (default is |).

## NOTE

The module temporarily modifies the computational region. The region is
set to the extent of the respective buffers, while the alignment of the
current region is kept.

## EXAMPLES

```sh
# Preparations
g.region -p raster=elevation,geology_30m
v.clip -r input=bridges output=bridges_wake

# Tabulate area of land cover map
g.region -p raster=elevation,geology_30m align=geology_30m
v.rast.bufferstats -t input=bridges_wake raster=geology_30m buffers=100,250,500 column_prefix=geology

# Compute terrain statistics and update vector attribute table
g.region -p raster=elevation,geology_30m align=elevation
r.slope.aspect elevation=elevation slope=slope aspect=aspect
v.rast.bufferstats input=bridges_wake raster=altitude,slope,aspect buffers=100,250,500 column_prefix=altitude,slope,aspect methods=minimum,maximum,average,stddev percentile=5,95

```

## KNOWN ISSUES

In order to avoid topological issues with overlapping buffers, the
module loops over the input geometries. However, this comes at costs
with regards to performance. For a larger number of geometries in the
vector map, it can be therefore more appropriate to compute neighborhood
statistics with *r.neighbors* and to extract (*v.what.rast*, *r.what*)
or aggregate (*v.rast.stats*) from those maps with neighborhood
statistics.

The module is affected by the following underlying library issue:
Currently, the module uses GRASS native buffering through pygrass which
should be replaced by buffering using GEOS:
<https://trac.osgeo.org/grass/ticket/3628>

## SEE ALSO

*[r.univar](https://grass.osgeo.org/grass-stable/manuals/r.univar.html)
[r.stats](https://grass.osgeo.org/grass-stable/manuals/r.stats.html)
[v.rast.stats](https://grass.osgeo.org/grass-stable/manuals/v.rast.stats.html)*

## AUTHOR

Stefan Blumentrath, Norwegian Institute for Nature Research, Oslo,
Norway

## SOURCE CODE

Available at: [v.rast.bufferstats source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.rast.bufferstats)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.rast.bufferstats))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
