---
name: v.rast.stats.py
description: Calculates univariate statistics from a raster map based on a vector map and uploads statistics to new attribute columns.
keywords: [ vector, statistics, raster, univariate statistics, zonal statistics, sampling, querying ]
---

# v.rast.stats.py

Calculates univariate statistics from a raster map based on a vector map and uploads statistics to new attribute columns.

=== "Command line"

    **v.rast.stats.py**
    [**-cd**]
    **map**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    [**where**=*sql_query*]
    **raster**=*name* [,*name*,...]
    **column_prefix**=*string* [,*string*,...]
    [**method**=*string* [,*string*,...]]
    [**percentile**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.rast.stats.py map=name raster=name column_prefix=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.rast.stats.py***",
        **map**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area"*,
        **where**=*None*,
        **raster**,
        **column_prefix**,
        **method**=*"number,null_cells,minimum,maximum,range,average,stddev,variance,coeff_var,sum,first_quartile,median,third_quartile,percentile"*,
        **percentile**=*90*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.rast.stats.py", map="name", raster="name", column_prefix="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_rast_stats_py*(**map**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area"*,
        **where**=*None*,
        **raster**,
        **column_prefix**,
        **method**=*"number,null_cells,minimum,maximum,range,average,stddev,variance,coeff_var,sum,first_quartile,median,third_quartile,percentile"*,
        **percentile**=*90*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_rast_stats_py(map="name", raster="name", column_prefix="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **raster**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map to calculate statistics from  
    **column_prefix**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Column prefix for new attribute columns  
    **method**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;The methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *number, null_cells, minimum, maximum, range, average, stddev, variance, coeff_var, sum, first_quartile, median, third_quartile, percentile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *number,null_cells,minimum,maximum,range,average,stddev,variance,coeff_var,sum,first_quartile,median,third_quartile,percentile*  
    **percentile**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Continue if upload column(s) already exist  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create densified lines (default: thin lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;All cells touched by the line will be set, not only those on the render path  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map to calculate statistics from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **column_prefix** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column prefix for new attribute columns  
    **method** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *number, null_cells, minimum, maximum, range, average, stddev, variance, coeff_var, sum, first_quartile, median, third_quartile, percentile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *number,null_cells,minimum,maximum,range,average,stddev,variance,coeff_var,sum,first_quartile,median,third_quartile,percentile*  
    **percentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Continue if upload column(s) already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create densified lines (default: thin lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;All cells touched by the line will be set, not only those on the render path  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map to calculate statistics from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **column_prefix** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column prefix for new attribute columns  
    **method** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *number, null_cells, minimum, maximum, range, average, stddev, variance, coeff_var, sum, first_quartile, median, third_quartile, percentile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *number,null_cells,minimum,maximum,range,average,stddev,variance,coeff_var,sum,first_quartile,median,third_quartile,percentile*  
    **percentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Continue if upload column(s) already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create densified lines (default: thin lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;All cells touched by the line will be set, not only those on the render path  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.rast.stats* calculates basic univariate statistics from a raster map
only for the parts covered by the specified vector map. The vector map
will be rasterized according to the raster map resolution. Then
univariate statistics are calculated per vector category (cat) from the
raster map and the results uploaded to the vector map attribute table. A
new column is generated in the attribute table for each statistic
requested in **method** (if not already present).

The univariate statistics include the number of raster cells counted,
the number of raster NULL cells counted, minimum and maximum cell
values, range, average, standard deviation, variance, coefficient of
variation, sum, first quartile, median, third quartile, and percentile.

## NOTES

*v.rast.stats* is only meaningful for lines or polygons.

The module may take a long time to run if the raster region contains a
large number of cells. In this case the **--verbose** flag may be used
to track progress.

The script stops if a (prefixed) upload column is already present in the
vector map attribute table, unless otherwise instructed with the **-c**
continue flag. The column prefix will be separated from the statistic
name with an underscore. For example with a prefix of "`elev`" the sum
column will be named `elev_sum`.

If a DBF database is being used, note that column names are restricted
by the DBF specification to 10 characters. Therefore it is advised to be
economical in the use of the column prefix when using DBF as any
additional characters will be chopped off.

The script internally aligns the raster grid cells to the grid of the
first input raster map.

If an area has several categories in the selected layer (equivalent to
overlapping polygons in Simple Features), only one category will be kept
during the rasterization process. Statistics for the skipped categories
will thus be partial.

For example, if there are three areas: area 1 with cat 1, area 2 with
cat 2, area 3 with cats 1, 2. Only one category value of area 3 will be
used for rasterization, the other category value will be skipped. Thus
statistics for the used category value will be complete, while
statistics for the skipped category value will be incomplete.

Large amounts of system memory can be used when extended statistics
(*first_quartile,median,third_quartile,percentile* ) are being requested
with a very large region setting. If the region is too large the module
should display memory allocation errors. Basic statistics can be
calculated using any size input region.

## EXAMPLES

Example to upload DEM statistics to ZIP codes vector map (North Carolina
sample dataset):

```sh
g.copy vect=zipcodes_wake,myzipcodes_wake
# set computational region to DEM:
g.region raster=elevation -p
# calculate selected DEM statistics, upload to vector map table:
v.rast.stats myzipcodes_wake raster=elevation \
  column_prefix=elev method=minimum,maximum,average,range,stddev,percentile \
  percentile=95
# verify results:
v.info -c myzipcodes_wake
v.db.select myzipcodes_wake
v.univar myzipcodes_wake column=elev_range type=centroid
```

## SEE ALSO

*[r.univar](r.univar.md), [v.univar](v.univar.md),
[v.vect.stats](v.vect.stats.md), [v.what.rast](v.what.rast.md),
[v.what.rast3](v.what.rast3.md), [v.what.vect](v.what.vect.md)*

## AUTHOR

Markus Neteler, CEA (for the [EDEN EU/FP6
Project](https://cordis.europa.eu/project/id/10284))

## SOURCE CODE

Available at: [v.rast.stats source code](https://github.com/OSGeo/grass/tree/main/scripts/v.rast.stats)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.rast.stats))  
Latest change: Thursday Aug 21 13:31:24 2025 in commit [5626d00](https://github.com/OSGeo/grass/commit/5626d00f2e1911bc29cd35b3ee853a72e5ab523c)
