---
name: v.surf.rst.cv.py
description: Performs cross-validation proceedure to optimize the parameterization of v.surf.rst tension and smoothing paramters.
keywords: [ raster, surface, interpolation, cross-validation, rst, json ]
---

# v.surf.rst.cv.py

Performs cross-validation proceedure to optimize the parameterization of v.surf.rst tension and smoothing paramters.

=== "Command line"

    **v.surf.rst.cv.py**
    **point_cloud**=*name*
    [**mask**=*name*]
    [**tension**=*integer* [,*integer*,...]]
    [**smooth**=*float* [,*float*,...]]
    [**layer**=*string*]
    [**zcolumn**=*name*]
    [**where**=*sql_query*]
    [**segmax**=*integer*]
    [**dmin**=*float*]
    [**dmax**=*float*]
    [**zscale**=*float*]
    [**theta**=*float*]
    [**scalex**=*float*]
    [**cv_prefix**=*string*]
    [**output_file**=*name*]
    [**format**=*string*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.surf.rst.cv.py point_cloud=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.surf.rst.cv.py***",
        **point_cloud**,
        **mask**=*None*,
        **tension**=*10,20,40,60,80,100*,
        **smooth**=*0.01,0.1,0.5,1.0,5.0,10.0*,
        **layer**=*"1"*,
        **zcolumn**=*None*,
        **where**=*None*,
        **segmax**=*40*,
        **dmin**=*None*,
        **dmax**=*None*,
        **zscale**=*1.0*,
        **theta**=*None*,
        **scalex**=*None*,
        **cv_prefix**=*None*,
        **output_file**=*None*,
        **format**=*None*,
        **nprocs**=*0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.surf.rst.cv.py", point_cloud="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_surf_rst_cv_py*(**point_cloud**,
        **mask**=*None*,
        **tension**=*10,20,40,60,80,100*,
        **smooth**=*0.01,0.1,0.5,1.0,5.0,10.0*,
        **layer**=*"1"*,
        **zcolumn**=*None*,
        **where**=*None*,
        **segmax**=*40*,
        **dmin**=*None*,
        **dmax**=*None*,
        **zscale**=*1.0*,
        **theta**=*None*,
        **scalex**=*None*,
        **cv_prefix**=*None*,
        **output_file**=*None*,
        **format**=*None*,
        **nprocs**=*0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_surf_rst_cv_py(point_cloud="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **point_cloud**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input point cloud vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input point cloud vector map  
    **mask**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mask raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the mask raster map  
    **tension**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Tension parameter for cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10,20,40,60,80,100*  
    **smooth**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing parameter for cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01,0.1,0.5,1.0,5.0,10.0*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **zcolumn**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the attribute column with values to be used for approximation  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given and input is 2D vector map then category values are used. If input is 3D vector map then z-coordinates are used.  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: elevation &lt; 500 and elevation &gt;= 1  
    **segmax**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points in segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **dmin**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum distance between points (to remove almost identical points). Default value is half of the smaller resolution of the current region.  
    **dmax**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between points on isoline (to insert additional points)  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor for values used for approximation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **theta**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Anisotropy angle (in degrees counterclockwise from East)  
    **scalex**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Anisotropy scaling factor  
    **cv_prefix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix to use for cross-validation output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix to use for cross-validation output cross-validation errors vector point map. Value must be set to save the cross-validation errors to a vector maps.  
    **output_file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file for the results (default: None) json or csv  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format for the results  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, text*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **point_cloud** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input point cloud vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input point cloud vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mask raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the mask raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tension** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tension parameter for cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10,20,40,60,80,100*  
    **smooth** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing parameter for cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01,0.1,0.5,1.0,5.0,10.0*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **zcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the attribute column with values to be used for approximation  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given and input is 2D vector map then category values are used. If input is 3D vector map then z-coordinates are used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: elevation &lt; 500 and elevation &gt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **segmax** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points in segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **dmin** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum distance between points (to remove almost identical points). Default value is half of the smaller resolution of the current region.  
    **dmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between points on isoline (to insert additional points)  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor for values used for approximation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **theta** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Anisotropy angle (in degrees counterclockwise from East)  
    **scalex** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Anisotropy scaling factor  
    **cv_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix to use for cross-validation output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix to use for cross-validation output cross-validation errors vector point map. Value must be set to save the cross-validation errors to a vector maps.  
    **output_file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file for the results (default: None) json or csv  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format for the results  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, text*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **point_cloud** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input point cloud vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input point cloud vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **mask** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mask raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the mask raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tension** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tension parameter for cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10,20,40,60,80,100*  
    **smooth** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing parameter for cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01,0.1,0.5,1.0,5.0,10.0*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **zcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the attribute column with values to be used for approximation  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given and input is 2D vector map then category values are used. If input is 3D vector map then z-coordinates are used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: elevation &lt; 500 and elevation &gt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **segmax** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points in segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **dmin** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum distance between points (to remove almost identical points). Default value is half of the smaller resolution of the current region.  
    **dmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between points on isoline (to insert additional points)  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Conversion factor for values used for approximation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **theta** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Anisotropy angle (in degrees counterclockwise from East)  
    **scalex** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Anisotropy scaling factor  
    **cv_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix to use for cross-validation output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix to use for cross-validation output cross-validation errors vector point map. Value must be set to save the cross-validation errors to a vector maps.  
    **output_file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file for the results (default: None) json or csv  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format for the results  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, text*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**v.surf.rst.cv** - Cross-validation of regularized spline with tension (RST)
surface model.

Predictive error of surface approximation for given parameters are
computed and a cross-validation procedure is then performed using the
data given in the vector map input. The estimated predictive errors are
stored in the optionally saved vector point map cvdev.

For larger data sets, CV should be applied to a representative subset of the
data. The cross-validation procedure works well only for well-sampled phenomena
and when minimizing the predictive error is the goal. The parameters found by
minimizing the predictive (CV) error may not not be the best for for poorly
sampled phenomena (result could be strongly smoothed with lost details and
fluctuations) or when significant noise is present that needs to be smoothed out.

## EXAMPLES

```python
import grass.script as gs

gs.run_command(
    "g.region",
    raster="elevation",
    res=30,
    n=220790,
    s=218390,
    w=632680,
    e=635910,
    flags="a",
)

# Extract random elevation points from the DEM
gs.run_command(
    "r.random",
    input="elevation",
    npoints=500,
    seed=0,
    vector="points",
    flags="z",
    overwrite=True,
)

# Run the cross validation proceedure
# using the random points
gs.run_command('v.surf.rst.cv',
    point_cloud="points",
    tension=[10, 100],
    smooth=[0.5, 5.0],
    segmax=600,
    format="json",
    output_file="test_cv.json",
    cv_prefix='cvdev',
    overwrite=True
)
```

By setting the **output_file** and **format** options the output of the above
command will be a JSON file with the
cross-validation results. The file will contain the following information:

```json
[
    {
        "tension": "10",
        "smooth": "0.5",
        "rmse": 3.938792429360747,
        "mae": 3.2086477739999997
    },
    {
        "tension": "10",
        "smooth": "5.0",
        "rmse": 4.921535874096144,
        "mae": 4.075445157999998
    },
    {
        "tension": "100",
        "smooth": "0.5",
        "rmse": 2.715355217413409,
        "mae": 2.0061099599999994
    },
    {
        "tension": "100",
        "smooth": "5.0",
        "rmse": 3.438609351379808,
        "mae": 2.73388017
    }
]
```

A report of the best parameter combination and the RMSE and MAE
values will be printed to the stderr.

```text
Best parameter combination
--------------------------------------------------
Tension: 100
Smoothing: 0.5
RMSE: 2.715355217413409
MAE: 2.0061099599999994
--------------------------------------------------
```

When the **cv_prefix** option is set, the vector point maps with the
cross-validation results will be saved and interpolated into a new surface that
displays the residuals of the cross-validation. The surface will be saved in the
current mapset with the name `<cv_prefix>_<tension>_<smooth>`.

![cdev-surface](v_surf_rst_cv_100_05.png)  
*Tension: 100 Smooth: 0.5*
![cdev-surface](v_surf_rst_cv_100_50.png)  
*Tension: 100 Smooth: 5*
![cdev-surface](v_surf_rst_cv_10_05.png)  
*Tension: 10 Smooth: 0.5*
![cdev-surface](v_surf_rst_cv_10_50.png)  
*Tension: 10 Smooth: 5*

## REFERENCES

- Mitasova, H., Mitas, L. and Harmon, R.S., 2005, Simultaneous spline
approximation and topographic analysis for lidar elevation data in open source
GIS, IEEE GRSL 2 (4), 375- 379.
- Hofierka, J., 2005, Interpolation of Radioactivity Data Using Regularized
Spline with Tension. Applied GIS, Vol. 1, No. 2, pp. 16-01 to 16-13. DOI: 10.2104/ag050016
- Hofierka J., Parajka J., Mitasova H., Mitas L., 2002, Multivariate
Interpolation of Precipitation Using Regularized Spline with Tension.
Transactions in GIS 6(2), pp. 135-150.
- H. Mitasova, L. Mitas, B.M. Brown, D.P. Gerdes, I. Kosinovsky, 1995, Modeling
spatially and temporally distributed phenomena: New methods and tools for
GRASS GIS. International Journal of GIS, 9 (4), special issue on Integrating
GIS and Environmental modeling, 433-446.
- Mitasova, H. and Mitas, L., 1993: Interpolation by Regularized Spline with
Tension: I. Theory and Implementation, Mathematical Geology ,25, 641-655.
- Mitasova, H. and Hofierka, J., 1993: Interpolation by Regularized Spline
with Tension: II. Application to Terrain Modeling and Surface Geometry
Analysis, Mathematical Geology 25, 657-667.
- Mitas, L., and Mitasova H., 1988, General variational approach to the
approximation problem, Computers and Mathematics with Applications, v.16, p. 983-992.
- Neteler, M. and Mitasova, H., 2008, Open Source GIS: A GRASS GIS Approach,
3rd Edition, Springer, New York, 406 pages.
- Talmi, A. and Gilat, G., 1977 : Method for Smooth Approximation of Data,
Journal of Computational Physics, 23, p.93-123.
- Wahba, G., 1990, : Spline Models for Observational Data, CNMS-NSF
Regional Conference series in applied mathematics, 59, SIAM,
Philadelphia, Pennsylvania.

## SEE ALSO

*[v.surf.rst](v.surf.rst.md)*

## AUTHORS

Corey T. White [NCSU GeoForAll Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [v.surf.rst.cv source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.surf.rst.cv)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.surf.rst.cv))  
Latest change: Thursday May 22 15:50:30 2025 in commit [5330e9b](https://github.com/OSGeo/grass-addons/commit/5330e9b33e22b242710239d391e31484da52f3c3)
