---
name: v.what.rast.label.py
description: Uploads raster values and labels to vector point layer
keywords: [ vector, sampling, raster, position, querying, attribute table, surface information ]
---

# v.what.rast.label.py

Uploads raster values and labels to vector point layer

=== "Command line"

    **v.what.rast.label.py**
    [**-oc**]
    **vector**=*name*
    **raster**=*name* [,*name*,...]
    [**raster2**=*name* [,*name*,...]]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.what.rast.label.py vector=name raster=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.what.rast.label.py***",
        **vector**,
        **raster**,
        **raster2**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.what.rast.label.py", vector="name", raster="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_what_rast_label_py*(**vector**,
        **raster**,
        **raster2**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_what_rast_label_py(vector="name", raster="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **vector**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name vector points map for which to add raster values & labels  
    **raster**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) with labels to be queried  
    **raster2**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) without labels to be queried  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output point layer  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include columns of input vector map  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include point coordinates  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name vector points map for which to add raster values & labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) with labels to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster2** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) without labels to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include columns of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include point coordinates  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name vector points map for which to add raster values & labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) with labels to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster2** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) without labels to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include columns of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include point coordinates  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.what.rast.label* retrieves raster values and labels from one or more
given raster maps for each point stored in the input vector map. The
name of the columns with the raster values start with *ID\_*, followed
by the name of the raster layer from which the values are taken. For the
name of the column with the raster labels, the name of the raster from
which the label is taken is used.

Optionally, the user can define raster layers without labels. In that
case only the raster values are uploaded to a column with the name of
that raster.

Another option is to add columns with point coordinates to the attribute
table of the output vector layer.

The user can opt to include the attribute columns of the input vector
layer in the output. In that case, the columns with the raster values
and labels will appear after the columns from the input vector layer.

## NOTES

Points and centroids with shared category number cannot be processed. To
solve this, unique categories may be added with v.category in a separate
layer. See *v.what.rast* for details.

If you only want to upload raster values at positions of vector points
to the attribute table of that vector layer, use *v.what.rast* instead.

## EXAMPLES

Get the POI within the bounds of the land use map.

```sh
g.region raster=landuse
v.in.region output=regionbounds
v.select ainput=points_of_interest binput=regionbounds output=POI_select operator=within
```

Extract raster values and labels from landuse map. Columns from the
input map (POI\_select) are not included.

```sh
v.what.rast.label vector=POI_select raster=landuse raster2=elevation output=POI_landuse1
```

Extract raster values and labels from landuse map. Use the -0 flag to
include the columns from the input map (POI\_select)

```sh
v.what.rast.label -o vector=POI_select raster=landuse raster2=elevation output=POI_landuse2
```

Extract raster values and labels from landuse map and values from
elevation map. Use the -0 flag to include the columns from the input map
(POI\_select)

```sh
v.what.rast.label -o vector=POI_select@user1 raster=landuse raster2=elevation output=POI_landuse3
```

Extract raster values and labels from landuse map and values from
elevation map. Use the -0 flag to include the columns from the input map
(POI\_select). Use the -c flag to include the point coordinates

```sh
v.what.rast.label -o -c vector=POI_select@user1 raster=landuse@PERMANENT raster2=elevation@PERMANENT output=POI_landuse4
```

## SEE ALSO

*[v.what.rast](https://grass.osgeo.org/grass-stable/manuals/v.what.rast.html),
[v.what.rast.multi](v.what.rast.multi.md) (addon)*

## AUTHORS

Paulo van Breugel | [HAS green academy](https://has.nl), University of
Applied Sciences | [Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)
| [Innovative Bio-Monitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/)
| Contact: [Ecodiv.earth](https://ecodiv.earth)

## SOURCE CODE

Available at: [v.what.rast.label source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.what.rast.label)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.what.rast.label))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
