---
title: Vector tools
author: GRASS Development Team
---

# Vector tools

To learn more about these tool in general, go to [Vector introduction](vectorintro.md).

| Name | Description |
|--------|-------------|
| [v.buffer](v.buffer.md) | Creates a buffer around vector features of given type. |
| [v.build.all](v.build.all.md) | Rebuilds topology on all vector maps in the current mapset. |
| [v.build](v.build.md) | Creates topology for vector map. Optionally also checks for topological errors. |
| [v.build.polylines](v.build.polylines.md) | Builds polylines from lines or boundaries. |
| [v.category](v.category.md) | Attaches, deletes or reports vector categories to/from/of map geometry. |
| [v.centroids](v.centroids.md) | Adds missing centroids to closed boundaries. |
| [v.class](v.class.md) | Classifies attribute data, e.g. for thematic mapping |
| [v.clean](v.clean.md) | Toolset for cleaning topology of vector map. |
| [v.clip](v.clip.md) | Extracts features of input map which overlay features of clip map. |
| [v.cluster](v.cluster.md) | Performs cluster identification. |
| [v.colors](v.colors.md) | Creates/modifies the color table associated with a vector map. |
| [v.colors.out](v.colors.out.md) | Exports the color table associated with a vector map. |
| [v.db.addcolumn](v.db.addcolumn.md) | Adds one or more columns to the attribute table connected to a given vector map. |
| [v.db.addtable](v.db.addtable.md) | Creates and connects a new attribute table to a given layer of an existing vector map. |
| [v.db.connect](v.db.connect.md) | Prints/sets DB connection for a vector map to attribute table. |
| [v.db.dropcolumn](v.db.dropcolumn.md) | Drops a column from the attribute table connected to a given vector map. |
| [v.db.droprow](v.db.droprow.md) | Removes a vector feature from a vector map through attribute selection. |
| [v.db.droptable](v.db.droptable.md) | Removes existing attribute table of a vector map. |
| [v.db.join](v.db.join.md) | Joins a database table to a vector map table. |
| [v.db.reconnect.all](v.db.reconnect.all.md) | Reconnects attribute tables for all vector maps from the current mapset to a new database. |
| [v.db.renamecolumn](v.db.renamecolumn.md) | Renames a column in the attribute table connected to a given vector map. |
| [v.db.select](v.db.select.md) | Prints vector map attributes. |
| [v.db.univar](v.db.univar.md) | Calculates univariate statistics on selected table column for a GRASS vector map. |
| [v.db.update](v.db.update.md) | Updates a column in the attribute table connected to a vector map. |
| [v.decimate](v.decimate.md) | Decimates a point cloud Copies points from one vector to another while applying different decimations |
| [v.delaunay](v.delaunay.md) | Creates a Delaunay triangulation from an input vector map containing points or centroids. |
| [v.dissolve](v.dissolve.md) | Dissolves adjacent or overlapping features sharing a common category number or attribute. |
| [v.distance](v.distance.md) | Finds the nearest element in vector map 'to' for elements in vector map 'from'. |
| [v.drape](v.drape.md) | Converts 2D vector features to 3D by sampling of elevation raster map. |
| [v.edit](v.edit.md) | Edits a vector map, allows adding, deleting and modifying selected vector features. |
| [v.external](v.external.md) | Creates a new pseudo-vector map as a link to an OGR-supported layer or a PostGIS feature table. |
| [v.external.out](v.external.out.md) | Defines vector output format. |
| [v.extract](v.extract.md) | Selects vector features from an existing vector map and creates a new vector map containing only the selected features. |
| [v.extrude](v.extrude.md) | Extrudes flat vector features to 3D vector features with defined height. Optionally the height can be derived from sampling of elevation raster map. |
| [v.fill.holes](v.fill.holes.md) | Fill holes in areas by keeping only outer boundaries |
| [v.generalize](v.generalize.md) | Performs vector based generalization. |
| [v.hull](v.hull.md) | Produces a 2D/3D convex hull for a given vector map. |
| [v.import](v.import.md) | Imports vector data into a GRASS vector map using OGR library and reprojects on the fly. |
| [v.in.ascii](v.in.ascii.md) | Creates a vector map from an ASCII points file or ASCII vector file. |
| [v.in.db](v.in.db.md) | Creates new vector (points) map from database table containing coordinates. |
| [v.in.dxf](v.in.dxf.md) | Converts file in DXF format to GRASS vector map. |
| [v.in.e00](v.in.e00.md) | Imports E00 file into a vector map. |
| [v.in.geonames](v.in.geonames.md) | Imports geonames.org country files into a vector points map. |
| [v.in.lidar](v.in.lidar.md) | Converts LAS LiDAR point clouds to a GRASS vector map with libLAS. |
| [v.in.lines](v.in.lines.md) | Imports ASCII x,y[,z] coordinates as a series of lines. |
| [v.in.mapgen](v.in.mapgen.md) | Imports Mapgen or Matlab-ASCII vector maps into GRASS. |
| [v.in.ogr](v.in.ogr.md) | Imports vector data into a GRASS vector map using OGR library. |
| [v.in.region](v.in.region.md) | Creates a vector polygon from the current region extent. |
| [v.in.wfs](v.in.wfs.md) | Imports GetFeature from a WFS server. |
| [v.info](v.info.md) | Outputs basic information about a vector map. |
| [v.kcv](v.kcv.md) | Randomly partition points into test/train sets. |
| [v.kernel](v.kernel.md) | Generates a raster density map from vector points map. Density is computed using a moving kernel. Optionally generates a vector density map on a vector network. |
| [v.label](v.label.md) | Creates paint labels for a vector map from attached attributes. |
| [v.label.sa](v.label.sa.md) | Create optimally placed labels for vector map(s) |
| [v.lidar.correction](v.lidar.correction.md) | Corrects the v.lidar.growing output. It is the last of the three algorithms for LIDAR filtering. |
| [v.lidar.edgedetection](v.lidar.edgedetection.md) | Detects the object's edges from a LIDAR data set. |
| [v.lidar.growing](v.lidar.growing.md) | Building contour determination and Region Growing algorithm for determining the building inside |
| [v.lrs.create](v.lrs.create.md) | Creates a linear reference system. |
| [v.lrs.label](v.lrs.label.md) | Creates stationing from input lines, and linear reference system. |
| [v.lrs.segment](v.lrs.segment.md) | Creates points/segments from input lines, linear reference system and positions read from stdin or a file. |
| [v.lrs.where](v.lrs.where.md) | Finds line id and real km+offset for given points in vector map using linear reference system. |
| [v.mkgrid](v.mkgrid.md) | Creates a vector map of a user-defined grid. |
| [v.neighbors](v.neighbors.md) | Neighborhood analysis tool for vector point maps. Makes each cell value a function of the attribute values assigned to the vector points or centroids in a radius around it, and stores new cell values in an output raster map. |
| [v.net.alloc](v.net.alloc.md) | Allocates subnets for nearest centers. Center node must be opened (costs >= 0). Costs of center node are used in calculation. |
| [v.net.allpairs](v.net.allpairs.md) | Computes the shortest path between all pairs of nodes in the network. |
| [v.net.bridge](v.net.bridge.md) | Computes bridges and articulation points in the network. |
| [v.net.centrality](v.net.centrality.md) | Computes degree, centrality, betweeness, closeness and eigenvector centrality measures in the network. |
| [v.net.components](v.net.components.md) | Computes strongly and weakly connected components in the network. |
| [v.net.connectivity](v.net.connectivity.md) | Computes vertex connectivity between two sets of nodes in the network. |
| [v.net.distance](v.net.distance.md) | Computes shortest distance via the network between the given sets of features. Finds the shortest paths from each 'from' point to the nearest 'to' feature and various information about this relation are uploaded to the attribute table. |
| [v.net.flow](v.net.flow.md) | Computes the maximum flow between two sets of nodes in the network. |
| [v.net.iso](v.net.iso.md) | Splits subnets for nearest centers by cost isolines. Splits net to bands between cost isolines (direction from center). Center node must be opened (costs >= 0). Costs of center node are used in calculation. |
| [v.net](v.net.md) | Performs network maintenance. |
| [v.net.path](v.net.path.md) | Finds shortest path on vector network. |
| [v.net.salesman](v.net.salesman.md) | Creates a cycle connecting given nodes (Traveling salesman problem). Note that TSP is NP-hard, heuristic algorithm is used by this module and created cycle may be sub optimal |
| [v.net.spanningtree](v.net.spanningtree.md) | Computes minimum spanning tree for the network. |
| [v.net.steiner](v.net.steiner.md) | Creates Steiner tree for the network and given terminals. Note that 'Minimum Steiner Tree' problem is NP-hard and heuristic algorithm is used in this module so the result may be sub optimal. |
| [v.net.timetable](v.net.timetable.md) | Finds shortest path using timetables. |
| [v.net.visibility](v.net.visibility.md) | Performs visibility graph construction. |
| [v.normal](v.normal.md) | Tests for normality for vector points. |
| [v.out.ascii](v.out.ascii.md) | Exports a vector map to a GRASS ASCII vector representation. By default only features with category are exported. To export all features use 'layer=-1'. |
| [v.out.dxf](v.out.dxf.md) | Exports vector map to DXF file format. |
| [v.out.lidar](v.out.lidar.md) | Exports vector points as LAS point cloud Converts LAS LiDAR point clouds to a GRASS vector map with libLAS |
| [v.out.ogr](v.out.ogr.md) | Exports a vector map layer to any of the supported OGR vector formats. By default a vector map layer is exported to OGC GeoPackage format. |
| [v.out.pov](v.out.pov.md) | Converts GRASS x,y,z points to POV-Ray x,z,y format. |
| [v.out.svg](v.out.svg.md) | Exports a vector map to SVG file. |
| [v.out.vtk](v.out.vtk.md) | Converts a vector map to VTK ASCII output. |
| [v.outlier](v.outlier.md) | Removes outliers from vector point data. |
| [v.overlay](v.overlay.md) | Overlays two vector maps offering clip, intersection, difference, symmetrical difference, union operators. |
| [v.pack](v.pack.md) | Exports a vector map as GRASS specific archive file |
| [v.parallel](v.parallel.md) | Creates parallel line to input vector lines. |
| [v.patch](v.patch.md) | Creates a new vector map by combining other vector maps. |
| [v.perturb](v.perturb.md) | Random location perturbations of vector points. |
| [v.profile](v.profile.md) | Vector map profiling tool |
| [v.proj](v.proj.md) | Re-projects a vector map from one project to the current project. |
| [v.qcount](v.qcount.md) | Indices for quadrat counts of vector point lists. |
| [v.random](v.random.md) | Generates random 2D/3D vector points. |
| [v.rast.stats](v.rast.stats.md) | Calculates univariate statistics from a raster map based on a vector map and uploads statistics to new attribute columns. |
| [v.reclass](v.reclass.md) | Changes vector category values for an existing vector map according to results of SQL queries or a value in attribute table column. |
| [v.rectify](v.rectify.md) | Rectifies a vector by computing a coordinate transformation for each object in the vector based on the control points. |
| [v.report](v.report.md) | Reports geometry statistics for vector maps. |
| [v.sample](v.sample.md) | Samples a raster map at vector point locations. |
| [v.segment](v.segment.md) | Creates points/segments from input vector lines and positions. |
| [v.select](v.select.md) | Selects features from vector map (A) by features from other vector map (B). |
| [v.split](v.split.md) | Splits vector lines to shorter segments. |
| [v.support](v.support.md) | Updates vector map metadata. |
| [v.surf.bspline](v.surf.bspline.md) | Performs bicubic or bilinear spline interpolation with Tykhonov regularization. |
| [v.surf.idw](v.surf.idw.md) | Provides surface interpolation from vector point data by Inverse Distance Squared Weighting. |
| [v.surf.rst](v.surf.rst.md) | Performs surface interpolation from vector points map by splines. Spatial approximation and topographic analysis from given point or isoline data in vector format to floating point raster format using regularized spline with tension. |
| [v.timestamp](v.timestamp.md) | Modifies a timestamp for a vector map. Print/add/remove a timestamp for a vector map. |
| [v.to.3d](v.to.3d.md) | Performs transformation of 2D vector features to 3D. |
| [v.to.db](v.to.db.md) | Populates attribute values from vector features. |
| [v.to.lines](v.to.lines.md) | Converts vector polygons or points to lines. |
| [v.to.points](v.to.points.md) | Creates points along input lines in new vector map with 2 layers. |
| [v.to.rast](v.to.rast.md) | Converts (rasterize) a vector map into a raster map. |
| [v.to.rast3](v.to.rast3.md) | Converts a vector map (only points) into a 3D raster map. |
| [v.transform](v.transform.md) | Performs an affine transformation (shift, scale and rotate) on vector map. |
| [v.type](v.type.md) | Changes type of vector features. |
| [v.univar](v.univar.md) | Calculates univariate statistics of vector map features. Variance and standard deviation is calculated only for points if specified. |
| [v.unpack](v.unpack.md) | Imports a GRASS specific vector archive file (packed with v.pack) as a vector map |
| [v.vect.stats](v.vect.stats.md) | Count points in areas, calculate statistics from point attributes. |
| [v.vol.rst](v.vol.rst.md) | Interpolates point data to a 3D raster map using regularized spline with tension (RST) algorithm. |
| [v.voronoi](v.voronoi.md) | Creates a Voronoi diagram constrained to the extents of the current region from an input vector map containing points or centroids. |
| [v.what](v.what.md) | Queries a vector map at given locations. |
| [v.what.rast](v.what.rast.md) | Uploads raster values at positions of vector points to the table. |
| [v.what.rast3](v.what.rast3.md) | Uploads 3D raster values at positions of vector points to the table. |
| [v.what.strds](v.what.strds.md) | Uploads space time raster dataset values at positions of vector points to the table. |
| [v.what.vect](v.what.vect.md) | Uploads vector values at positions of vector points to the table. |
