---
name: d.explanation.plot.py
description: Draw a plot of multiple rasters to explain a raster operation for example a + b = c
keywords: [ display, manual, raster ]
---

# d.explanation.plot.py

Draw a plot of multiple rasters to explain a raster operation for example a + b = c

=== "Command line"

    **d.explanation.plot.py**
    **a**=*name*
    [**b**=*name*]
    [**c**=*name*]
    [**d**=*name*]
    [**raster_font**=*string*]
    [**operator_ab**=*string*]
    [**operator_bc**=*string*]
    [**operator_cd**=*string*]
    [**operator_font**=*string*]
    [**label_a**=*string*]
    [**label_b**=*string*]
    [**label_c**=*string*]
    [**label_d**=*string*]
    [**label_font**=*string*]
    [**label_size**=*float*]
    [**bottom**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.explanation.plot.py a=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.explanation.plot.py***",
        **a**,
        **b**=*None*,
        **c**=*None*,
        **d**=*None*,
        **raster_font**=*None*,
        **operator_ab**=*None*,
        **operator_bc**=*None*,
        **operator_cd**=*None*,
        **operator_font**=*None*,
        **label_a**=*None*,
        **label_b**=*None*,
        **label_c**=*None*,
        **label_d**=*None*,
        **label_font**=*None*,
        **label_size**=*None*,
        **bottom**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.explanation.plot.py", a="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_explanation_plot_py*(**a**,
        **b**=*None*,
        **c**=*None*,
        **d**=*None*,
        **raster_font**=*None*,
        **operator_ab**=*None*,
        **operator_bc**=*None*,
        **operator_cd**=*None*,
        **operator_font**=*None*,
        **label_a**=*None*,
        **label_b**=*None*,
        **label_c**=*None*,
        **label_d**=*None*,
        **label_font**=*None*,
        **label_size**=*None*,
        **bottom**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_explanation_plot_py(a="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **a**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **b**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **c**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **d**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **raster_font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for raster numbers  
    **operator_ab**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between a and b  
    **operator_bc**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between b and c  
    **operator_cd**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between c and d  
    **operator_font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for operators  
    **label_a**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_b**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_c**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_d**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for labels  
    **label_size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text size for labels  
    **bottom**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset from the bottom (percentage)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **a** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **b** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **c** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for raster numbers  
    **operator_ab** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between a and b  
    **operator_bc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between b and c  
    **operator_cd** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between c and d  
    **operator_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for operators  
    **label_a** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_b** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_c** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for labels  
    **label_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text size for labels  
    **bottom** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset from the bottom (percentage)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **a** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **b** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **c** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **d** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for raster numbers  
    **operator_ab** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between a and b  
    **operator_bc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between b and c  
    **operator_cd** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operator between c and d  
    **operator_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for operators  
    **label_a** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_b** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_c** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label above the raster  
    **label_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font for labels  
    **label_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text size for labels  
    **bottom** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset from the bottom (percentage)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.explantion.plot* creates a plot of rasters and their relations which
can serve as an explanation of a raster operation performed by a module
or function.

Up to four rasters are supported. The default operators assume rasters
to have the following relation:

*a + b -\> c*

## EXAMPLES

### Example using generated data

In Bash:

```sh
g.region n=99 s=0 e=99 w=0 rows=3 cols=3
r.mapcalc expression="a = rand(0., 5)" seed=1
r.mapcalc expression="b = rand(0., 5)" seed=2
r.mapcalc expression="c = rand(0., 5)" seed=3
r.series input=a,b,c output=d method=average
```

In Python:

```python
import grass.jupyter as gj
plot = gj.Map(use_region=True, width=700, height=700)
plot.d_background(color="white")
plot.run("d.explanation.plot", a="a", b="b", c="c", d="d", operator_font="FreeMono:Regular")
plot.show()
```

![Resulting image for r.series](d_explanation_plot_with_r_series.png)  
*Figure: Resulting image for r.series*

### Example using artificial data

```sh
r.in.ascii input=- output=input_1 <<EOF
north: 103
south: 100
east: 103
west: 100
rows: 3
cols: 3
5 * 9
* 5 *
* 5 5
EOF
r.in.ascii input=- output=input_2 <<EOF
north: 103
south: 100
east: 103
west: 100
rows: 3
cols: 3
3 4 4
2 2 2
2 1 1
EOF
r.colors map=input_1,input_2 color=viridis
g.region raster=input_1
r.patch input=input_1,input_2 output=result
d.mon wx0 width=400 height=400 output=r_patch.png
d.explanation.plot a=input_1 b=input_2 c=result
```

![Resulting image for r.patch](d_explanation_plot.png)  
*Figure: Resulting image for r.patch*

## KNOWN ISSUES

- Issue [\#3381](https://trac.osgeo.org/grass/ticket/3381) prevents
    d.rast.num to be used with `d.mon cairo`, so `d.mon wx0` needs to be
    used with this module. Using environmental variables for rendering
    directly or using tools such as *Map* from *grass.jupyter* avoids
    the issues.
- Issue [\#3382](https://trac.osgeo.org/grass/ticket/3382) prevents
    usage of centered text with `d.mon wx0`, so the hardcoded values for
    text does not work perfectly.
- Issue [\#3383](https://trac.osgeo.org/grass/ticket/3383) prevents
    d.rast.num to be saved to the image with `d.mon wx0`, taking
    screenshot is necessary (with a powerful screenshot tool, this also
    addresses the copping issue below).
- The size of the display must be square to have rasters and their
    cells as squares, e.g., `d.mon wx0 width=400 height=400` must be
    used. The image needs to be cropped afterwards, e.g. using
    ImageMagic's `mogrify -trim image.png`.

## SEE ALSO

*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[d.frame](https://grass.osgeo.org/grass-stable/manuals/d.frame.html),
[d.rast.num](https://grass.osgeo.org/grass-stable/manuals/d.rast.num.html),
[d.grid](https://grass.osgeo.org/grass-stable/manuals/d.grid.html),
[d.mon](https://grass.osgeo.org/grass-stable/manuals/d.mon.html),
[v.mkgrid](https://grass.osgeo.org/grass-stable/manuals/v.mkgrid.html)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [d.explanation.plot source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/display/d.explanation.plot)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/display/d.explanation.plot))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
