---
name: d.info
description: Displays information about the active display monitor. Display monitors are maintained by d.mon.
keywords: [ display, graphics, monitors ]
---

# d.info

Displays information about the active display monitor.

Display monitors are maintained by d.mon.

=== "Command line"

    **d.info**
    [**-rdfebg**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.info
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***d.info***",
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("d.info")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_info*(        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_info()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display screen rectangle (left, right, top, bottom)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display screen dimensions (width, height)  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display active frame rectangle  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display frame dimensions (width, height)  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display screen rectangle of current region  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display geographic coordinates and resolution of entire frame  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *f*, *e*, *b*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display screen rectangle (left, right, top, bottom)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display screen dimensions (width, height)  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display active frame rectangle  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display frame dimensions (width, height)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display screen rectangle of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display geographic coordinates and resolution of entire frame  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *f*, *e*, *b*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display screen rectangle (left, right, top, bottom)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display screen dimensions (width, height)  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display active frame rectangle  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display frame dimensions (width, height)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display screen rectangle of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display geographic coordinates and resolution of entire frame  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.info* displays information about the active display monitor. Display
monitors are maintained by *[d.mon](d.mon.md)*.

## EXAMPLES

```sh
d.mon start=cairo

d.info -r
rectangle: 0.000000 640.000000 0.000000 480.000000
```

## NOTES

Units are screen pixels (except for **-g** flag where map units are
used).  
Where two numbers are given the format is: width, height.  
Where four numbers are given the format is: left, right, top, bottom.

Note: GRASS display pixel coordinates are measured from the top left.

## SEE ALSO

*[d.mon](d.mon.md), [d.vect](d.vect.md), [d.rast](d.rast.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [d.info source code](https://github.com/OSGeo/grass/tree/main/display/d.info)
([history](https://github.com/OSGeo/grass/commits/main/display/d.info))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
