---
name: d.legend.vect
description: Displays a vector legend in the active graphics frame.
keywords: [ display, cartography, vector, legend ]
---

# d.legend.vect

Displays a vector legend in the active graphics frame.

=== "Command line"

    **d.legend.vect**
    [**-b**]
    [**at**=*left,top*]
    [**columns**=*integer*]
    [**title**=*string*]
    [**symbol_size**=*integer*]
    [**border_color**=*name*]
    [**bgcolor**=*name*]
    [**border_width**=*integer*]
    [**font**=*string*]
    [**fontsize**=*float*]
    [**title_font**=*string*]
    [**title_fontsize**=*float*]
    [**sub_font**=*string*]
    [**sub_fontsize**=*float*]
    [**fontcolor**=*name*]
    [**separator**=*character*]
    [**input**=*name*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.legend.vect
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.legend.vect***",
        **at**=*"10,40"*,
        **columns**=*1*,
        **title**=*None*,
        **symbol_size**=*20*,
        **border_color**=*"black"*,
        **bgcolor**=*"white"*,
        **border_width**=*2*,
        **font**=*None*,
        **fontsize**=*None*,
        **title_font**=*None*,
        **title_fontsize**=*None*,
        **sub_font**=*None*,
        **sub_fontsize**=*None*,
        **fontcolor**=*"black"*,
        **separator**=*"pipe"*,
        **input**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.legend.vect")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_legend_vect*(**at**=*"10,40"*,
        **columns**=*1*,
        **title**=*None*,
        **symbol_size**=*20*,
        **border_color**=*"black"*,
        **bgcolor**=*"white"*,
        **border_width**=*2*,
        **font**=*None*,
        **fontsize**=*None*,
        **title_font**=*None*,
        **title_fontsize**=*None*,
        **sub_font**=*None*,
        **sub_fontsize**=*None*,
        **fontcolor**=*"black"*,
        **separator**=*"pipe"*,
        **input**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_legend_vect()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **at**=*left,top*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position of legend to be drawn (percentage, [0,0] is lower left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10,40*  
    **columns**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of legend columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend title  
    **symbol_size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **border_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **border_width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background border width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 12  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **title_font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title font name  
    **title_fontsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 18  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **sub_font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtitle font name  
    **sub_fontsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtitle font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 14  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **fontcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input legend file  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to legend file   
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output csv file  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output file or '-' for standard output  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display legend background  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position of legend to be drawn (percentage, [0,0] is lower left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *left,top*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10,40*  
    **columns** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of legend columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend title  
    **symbol_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **border_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **border_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background border width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 12  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **title_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title font name  
    **title_fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 18  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **sub_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtitle font name  
    **sub_fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtitle font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 14  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **fontcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input legend file  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to legend file   
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output csv file  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output file or '-' for standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display legend background  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position of legend to be drawn (percentage, [0,0] is lower left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *left,top*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10,40*  
    **columns** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of legend columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend title  
    **symbol_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **border_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **border_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background border width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 12  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **title_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title font name  
    **title_fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 18  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **sub_font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtitle font name  
    **sub_fontsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtitle font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 14  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-360*  
    **fontcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input legend file  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to legend file   
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output csv file  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output file or '-' for standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display legend background  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.legend.vect* draws vector legend of currently displayed vector maps.

Parameter **at** defines the screen position of upper-left legend
corner. Parameter **columns** defines the number of legend columns. User
can specify a title of the legend using parameter **title**. The font of
the title can be changed with **title_font**, **title_fontsize**. Flag
**-b** is used to draw background of specified color (**bgcolor**),
border color and border width (**border_color** and **border_width**).
Parameter **symbol_size** defines the size of line and area symbols. The
size of point symbols is based on currently set symbology of vector maps
using *[d.vect](d.vect.md)* or *[d.vect.thematic](d.vect.thematic.md)*.

Module *d.vect.legend* supports subtitles (see section Notes). Their
font and font size can be set using parameters **sub_font** and
**sub_fontsize**.

### Changing legend symbols and labels

Symbols for vector areas and lines, and labels for individual vector
labels can be changed in the symbology setting of each vector map in
*[d.vect](d.vect.md)* or *[d.vect.thematic](d.vect.thematic.md)* module
(in Legend tab). Use its parameters **icon_area** and **icon_line** to
pick from available symbols. By using parameter **legend_label** of
*d.vect* module, users can change the default label, which is the map
name.

### Modifying the order of legend entries and omitting certain vector maps from legend

Modules *[d.vect](d.vect.md)* and
*[d.vect.thematic](d.vect.thematic.md)* have a flag **-s** which removes
the particular vector or thematic vector from vector legend.

The order of entries is defined by the order in Layer Manager (if used
in GRASS GUI). If that's not desired, one can export the legend file
into a text file using parameter **output**, change the order of entries
(see section Notes for format description) and then upload the modified
file with parameter **input**. Parameter **output** defines path to the
file where the internal legend file will be saved to, **input** defines
the input file which the vector legend will be based on (input file must
have correct format).

## NOTES

Module *d.legend.vect* draws vector legend based on legend file defined
in shell environment variable GRASS_LEGEND_FILE. This file is
automatically created and updated whenever *[d.vect](d.vect.md)* command
is used. User can create custom legend file and then use *export
GRASS_LEGEND_FILE=path/to/file* in shell. GRASS GUI and MONITORS create
the legend file automatically. By default the legend file is stored in
grassdata/project/mapset/.tmp/user directory (in case of d.mon deeper in
/monitor_name directory).  

Legend file has this format:

```sh
label|symbol_name|size|color_type|feature_color|fill_color|line_width|geometry_type|feature_count
```

Color type can be 'lf' or 'ps'. Based on color type color columns are
interpreted as line color and fill colors (lf), or primary and secondary
colors (ps). Module d.vect always uses 'lf' and d.vect.thematic 'ps'.
Here is an example of legend file with subtitles:

```sh
Infrastructure||||||||
major roads|legend/line|5|lf|black|200:200:200|2|line|355
bridges|extra/bridge|15|lf|black|black|1|point|10938
Hydrology||||||||
streams|legend/line_crooked|5|lf|30:144:255|200:200:200|3|line|8554
water bodies|legend/area_curved|5|lf|none|30:144:255|1|area|27764
```

![Example of subheadings used in vector
legend](d_legend_vect_subheadings.png)

## EXAMPLES

Open cairo monitor to render to file:

```sh
g.region vector=nc_state
d.mon cairo
d.vect map=nc_state color=26:26:26 fill_color=229:229:229 width=2 legend_label="state boundaries"
d.vect map=urbanarea color=none fill_color=127:127:127 width=1 legend_label="urban areas"
d.vect map=railroads color=red width=1
d.vect map=hospitals color=77:77:77 fill_color=0:187:0 width=1 icon=basic/cross3 size=10
d.legend.vect -b at=2,40 title="Hospitals in North Carolina" symbol_size=26 fontsize=16 title_fontsize=20
```

![d.legend.vect example](d_legend_vect.png)  

## SEE ALSO

*[d.vect](d.vect.md), [d.vect.thematic](d.vect.thematic.md),
[d.legend](d.legend.md)*

Check also Python module from AddOns:
*[d.vect.thematic2](https://grass.osgeo.org/grass8/manuals/addons/d.vect.thematic2.html)*

## AUTHORS

Adam Laza, during GSoC 2016 Mentors: Anna Petrasova, Vaclav Petras,
Martin Landa

## SOURCE CODE

Available at: [d.legend.vect source code](https://github.com/OSGeo/grass/tree/main/display/d.legend.vect)
([history](https://github.com/OSGeo/grass/commits/main/display/d.legend.vect))  
Latest change: Monday Aug 11 17:04:35 2025 in commit [1031cc9](https://github.com/OSGeo/grass/commit/1031cc9f7fda9e0baef3e38ba2931a3afb17ef40)
