---
name: d.rhumbline
description: Displays the rhumbline joining two longitude/latitude coordinates.
keywords: [ display, distance, rhumbline ]
---

# d.rhumbline

Displays the rhumbline joining two longitude/latitude coordinates.

=== "Command line"

    **d.rhumbline**
    **coordinates**=*lon1,lat1,lon2,lat2*
    [**line_color**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.rhumbline coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.rhumbline***",
        **coordinates**,
        **line_color**=*"black"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.rhumbline", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_rhumbline*(**coordinates**,
        **line_color**=*"black"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_rhumbline(coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **coordinates**=*lon1,lat1,lon2,lat2* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting and ending coordinates  
    **line_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **coordinates** : tuple[float, float, float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting and ending coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *lon1,lat1,lon2,lat2*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **coordinates** : tuple[float, float, float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting and ending coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *lon1,lat1,lon2,lat2*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

A rhumbline (loxodrome) is a line following a constant angle of the
compass (i.e., a line of constant direction). It crosses all meridians
at the same angle, i.e. a path of constant bearing. *d.rhumbline*
displays the rhumbline joining any two user-specified points in the
active frame on the user's graphics monitor. The named coordinate
locations must fall within the boundaries of the user's current
geographic region.

The user has to specify the starting and ending longitude/latitude
coordinates of the rhumbline and (optionally) the color in which the
rhumbline will be displayed; in this case, the program will run
non-interactively.

## EXAMPLE

A geodesic line if shown over the political map of the world
(demolocation dataset):

```sh
g.region vector=country_boundaries -p
d.mon wx0
d.vect country_boundaries type=area
d.rhumbline coordinates=55:58W,33:18S,26:43E,60:37N \
  line_color=yellow
# show additionally 10 degree grid
d.grid 10
```

![Rhumbline (loxodrome)](d_rhumbline.png)  
*Rhumbline (loxodrome)*

## NOTES

This program works only with longitude/latitude coordinate system.

## SEE ALSO

*[d.geodesic](d.geodesic.md), [d.grid](d.grid.md),
[m.measure](m.measure.md)*

## AUTHOR

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.rhumbline source code](https://github.com/OSGeo/grass/tree/main/display/d.rhumbline)
([history](https://github.com/OSGeo/grass/commits/main/display/d.rhumbline))  
Latest change: Tuesday Feb 18 17:20:26 2025 in commit [688e625](https://github.com/OSGeo/grass/commit/688e625e7db3be9a465ce99ba25f36d2ebdd5aeb)
