---
name: d.title
description: Create a TITLE for a raster map in a form suitable for display with d.text.
keywords: [ display, cartography ]
---

# d.title

Create a TITLE for a raster map in a form suitable for display with d.text.

=== "Command line"

    **d.title**
    [**-dfs**]
    **map**=*name*
    [**color**=*string*]
    [**size**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.title map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.title***",
        **map**,
        **color**=*"black"*,
        **size**=*4.0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.title", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_title*(**map**,
        **color**=*"black"*,
        **size**=*4.0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_title(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sets the text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sets the text size as percentage of the frame's height  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4.0*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw title on current display  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do a fancier title  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do a simple title  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sets the text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sets the text size as percentage of the frame's height  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *f*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw title on current display  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do a fancier title  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do a simple title  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sets the text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sets the text size as percentage of the frame's height  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *f*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw title on current display  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do a fancier title  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do a simple title  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.title* generates to standard output a string which can be used by
*[d.text](d.text.md)* to draw a TITLE for the raster map layer *name* in
the active display frame on the graphics monitor. Output created by
*d.title* can be redirected into a file, or piped directly into
*[d.text](d.text.md)* to display the map TITLE created by *d.title*. The
map TITLE created will include the map layer's name, TITLE, MAPSET,
LOCATION_NAME, geographic region boundary coordinates, and cell
resolution. If the **-d** draw flag is used, then *d.title* will call
*d.text* for you and the title will be automatically rendered to the
display.

## NOTES

The text created with *[d.text](d.text.md)* will not necessarily fit
within the active display frame on the graphics monitor; the user should
choose a text size appropriate to this frame.

## EXAMPLES

For example, a user wishing to create a suitable TITLE for the
Spearfish, SD *soils* map layer and to display this TITLE in the active
display frame on the graphics monitor might type the following:

```sh
d.title map=soils color=red size=5 > TITLE.file
d.text < TITLE.file
```

Alternately, the user might pipe *d.title* output directly into
*[d.text](d.text.md):*

```sh
d.title map=soils color=red size=5 | d.text
```

A file created by *d.title* can be displayed with *[d.text](d.text.md)*.
Information contained in this file takes precedence over the *color* and
*size* parameters for *[d.text](d.text.md)*.

## SEE ALSO

*[d.font](d.font.md), [d.text](d.text.md)*

## AUTHOR

James Westervelt, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.title source code](https://github.com/OSGeo/grass/tree/main/display/d.title)
([history](https://github.com/OSGeo/grass/commits/main/display/d.title))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
