---
name: d.to.rast.py
description: Saves the contents of the active display monitor to a raster map.
keywords: [ display, export, raster ]
---

# d.to.rast.py

Saves the contents of the active display monitor to a raster map.

=== "Command line"

    **d.to.rast.py**
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.to.rast.py output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.to.rast.py***",
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.to.rast.py", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_to_rast_py*(**output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_to_rast_py(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.to.rast* saves the content of the currently selected monitor into a
raster map. The active monitor can be selected with *d.mon*. *d.to.rast*
can be run from GUI Console tab, too. This module is not sensitive to
computational region settings.

## EXAMPLE

We combine different raster and vector map layers to create a composite
layer which can be draped over elevation in 3D view. First, we add a
couple of maps to layer manager:

```sh
g.region raster=elevation
d.rast map=elevation
d.rast map=lakes
d.vect map=roadsmajor width=4
d.vect map=roadsmajor width=2 color=yellow

# create a raster map from the display
d.to.rast output=composite
```

Then uncheck all layers except for elevation and switch to 3D view. In
Data tab, set color map to the newly created composite map.

![Raster map created by d.to.rast draped over digital elevation model](d_to_rast_3D_example.jpg)
*Figure: Raster map created by *d.to.rast* draped over digital elevation model.*

## SEE ALSO

*[d.out.file](d.out.file.md), [d.erase](d.erase.md),
[d.rast](d.rast.md), [d.vect](d.vect.md), [d.mon](d.mon.md)*

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [d.to.rast source code](https://github.com/OSGeo/grass/tree/main/scripts/d.to.rast)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.to.rast))  
Latest change: Thursday Feb 20 12:48:50 2025 in commit [1633be4](https://github.com/OSGeo/grass/commit/1633be4dc57dd1819a0f6ccd8ea4bc2b8bbec864)
