---
name: d.vect.thematic2.py
description: Displays thematic map created from vector features and numeric attributes.
keywords: [ display, cartography, vector, thematic, legend ]
---

# d.vect.thematic2.py

Displays thematic map created from vector features and numeric attributes.

=== "Command line"

    **d.vect.thematic2.py**
    [**-glfsm**]
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    [**type**=*string* [,*string*,...]]
    [**where**=*sql_query*]
    **themetype**=*string*
    **themecalc**=*string*
    [**breakpoints**=*string*]
    [**icon**=*string*]
    [**size**=*float*]
    [**maxsize**=*float*]
    [**nint**=*integer*]
    **colorscheme**=*string*
    [**point_color**=*string*]
    [**line_color**=*string*]
    [**start_color**=*string*]
    [**end_color**=*string*]
    [**monitor**=*string*]
    [**psmap**=*string*]
    [**group**=*name*]
    [**rgb_column**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.vect.thematic2.py map=name column=name themetype=graduated_colors themecalc=interval colorscheme=blue-red
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***d.vect.thematic2.py***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **type**=*"point,line,area"*,
        **where**=*None*,
        **themetype**=*"graduated_colors"*,
        **themecalc**=*"interval"*,
        **breakpoints**=*None*,
        **icon**=*"basic/circle"*,
        **size**=*5*,
        **maxsize**=*20*,
        **nint**=*4*,
        **colorscheme**=*"blue-red"*,
        **point_color**=*"255:0:0"*,
        **line_color**=*"0:0:0"*,
        **start_color**=*"255:0:0"*,
        **end_color**=*"0:0:255"*,
        **monitor**=*"wx1"*,
        **psmap**=*None*,
        **group**=*None*,
        **rgb_column**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("d.vect.thematic2.py", map="name", column="name", themetype="graduated_colors", themecalc="interval", colorscheme="blue-red")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_vect_thematic2_py*(**map**,
        **layer**=*"1"*,
        **column**,
        **type**=*"point,line,area"*,
        **where**=*None*,
        **themetype**=*"graduated_colors"*,
        **themecalc**=*"interval"*,
        **breakpoints**=*None*,
        **icon**=*"basic/circle"*,
        **size**=*5*,
        **maxsize**=*20*,
        **nint**=*4*,
        **colorscheme**=*"blue-red"*,
        **point_color**=*"255:0:0"*,
        **line_color**=*"0:0:0"*,
        **start_color**=*"255:0:0"*,
        **end_color**=*"0:0:255"*,
        **monitor**=*"wx1"*,
        **psmap**=*None*,
        **group**=*None*,
        **rgb_column**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_vect_thematic2_py(map="name", column="name", themetype="graduated_colors", themecalc="interval", colorscheme="blue-red")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to use for thematic display (must be numeric)  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **themetype**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of thematic display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *graduated_colors, graduated_points, graduated_lines*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *graduated_colors*  
    **themecalc**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Thematic divisions of data for display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *interval, std_deviation, quartiles, custom_breaks*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *interval*  
    **breakpoints**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Break points for custom breaks option  
    &nbsp;&nbsp;&nbsp;&nbsp;Separate values by spaces (0 10 20 30 ...)  
    **icon**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector point icon for point data  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/box, basic/circle, basic/cross2, basic/diamond, basic/star, basic/cross1, basic/x*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/circle*  
    **size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size for point data  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum icon size/line width for graduated points/lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **maxsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum icon size/line width for graduated points and lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **nint**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes for interval theme (integer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **colorscheme**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Color scheme for graduated color mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Select 'single_color' for graduated point/line display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *blue-red, red-blue, green-red, red-green, blue-green, green-blue, cyan-yellow, yellow-cyan, custom_gradient, single_color*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue-red*  
    **point_color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for graduated points map  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS named color or R:G:B triplet. Set color scheme to single color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:0:0*  
    **line_color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for graduated lines or point/area outlines  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS named color or R:G:B triplet. Set color scheme to single color.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:0:0*  
    **start_color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Beginning color for custom color gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be expressed as R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:0:0*  
    **end_color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ending color for custom color gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be expressed as R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:0:255*  
    **monitor**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select WXGUI display monitor for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wx1*  
    **psmap**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root for the name of psmap instruction files to be in current directory  
    &nbsp;&nbsp;&nbsp;&nbsp;If not set, no psmap instruction files will be created)  
    **group**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of group file where thematic map commands will be saved  
    **rgb_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color column to populate RGB values  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Save thematic map commands to group file for GIS Manager  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create graphic legend in x11 display monitor  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only draw fills (no outlines) for areas and points  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output legend for GIS Manager (for scripting use only)  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use math notation brackets in legend  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to use for thematic display (must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **themetype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of thematic display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *graduated_colors, graduated_points, graduated_lines*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *graduated_colors*  
    **themecalc** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thematic divisions of data for display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *interval, std_deviation, quartiles, custom_breaks*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *interval*  
    **breakpoints** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Break points for custom breaks option  
    &nbsp;&nbsp;&nbsp;&nbsp;Separate values by spaces (0 10 20 30 ...)  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector point icon for point data  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/box, basic/circle, basic/cross2, basic/diamond, basic/star, basic/cross1, basic/x*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/circle*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size for point data  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum icon size/line width for graduated points/lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **maxsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum icon size/line width for graduated points and lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **nint** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes for interval theme (integer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **colorscheme** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color scheme for graduated color mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Select 'single_color' for graduated point/line display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *blue-red, red-blue, green-red, red-green, blue-green, green-blue, cyan-yellow, yellow-cyan, custom_gradient, single_color*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue-red*  
    **point_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for graduated points map  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS named color or R:G:B triplet. Set color scheme to single color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:0:0*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for graduated lines or point/area outlines  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS named color or R:G:B triplet. Set color scheme to single color.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:0:0*  
    **start_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Beginning color for custom color gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be expressed as R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:0:0*  
    **end_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ending color for custom color gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be expressed as R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:0:255*  
    **monitor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select WXGUI display monitor for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wx1*  
    **psmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root for the name of psmap instruction files to be in current directory  
    &nbsp;&nbsp;&nbsp;&nbsp;If not set, no psmap instruction files will be created)  
    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of group file where thematic map commands will be saved  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color column to populate RGB values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *l*, *f*, *s*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Save thematic map commands to group file for GIS Manager  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create graphic legend in x11 display monitor  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only draw fills (no outlines) for areas and points  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output legend for GIS Manager (for scripting use only)  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use math notation brackets in legend  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to use for thematic display (must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **themetype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of thematic display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *graduated_colors, graduated_points, graduated_lines*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *graduated_colors*  
    **themecalc** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thematic divisions of data for display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *interval, std_deviation, quartiles, custom_breaks*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *interval*  
    **breakpoints** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Break points for custom breaks option  
    &nbsp;&nbsp;&nbsp;&nbsp;Separate values by spaces (0 10 20 30 ...)  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector point icon for point data  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/box, basic/circle, basic/cross2, basic/diamond, basic/star, basic/cross1, basic/x*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/circle*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size for point data  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum icon size/line width for graduated points/lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **maxsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum icon size/line width for graduated points and lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **nint** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes for interval theme (integer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **colorscheme** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color scheme for graduated color mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Select 'single_color' for graduated point/line display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *blue-red, red-blue, green-red, red-green, blue-green, green-blue, cyan-yellow, yellow-cyan, custom_gradient, single_color*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue-red*  
    **point_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for graduated points map  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS named color or R:G:B triplet. Set color scheme to single color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:0:0*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for graduated lines or point/area outlines  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS named color or R:G:B triplet. Set color scheme to single color.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:0:0*  
    **start_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Beginning color for custom color gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be expressed as R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255:0:0*  
    **end_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ending color for custom color gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be expressed as R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:0:255*  
    **monitor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select WXGUI display monitor for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wx1*  
    **psmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root for the name of psmap instruction files to be in current directory  
    &nbsp;&nbsp;&nbsp;&nbsp;If not set, no psmap instruction files will be created)  
    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of group file where thematic map commands will be saved  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color column to populate RGB values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *l*, *f*, *s*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Save thematic map commands to group file for GIS Manager  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create graphic legend in x11 display monitor  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only draw fills (no outlines) for areas and points  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output legend for GIS Manager (for scripting use only)  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use math notation brackets in legend  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.vect.thematic2* creates thematic maps from vector features of all
types and numeric attributes stored in the attribute table connected to
a vector map.

Thematic maps can be displayed by either a *graduated color scheme* (for
all vector types), as *graduated icon sizes* (for point and centroid
types), or *graduated line widths* (for lines and boundaries with
associated attributes), see **themetype** option for details. The user
selects the vector **map** to be mapped and attribute **column** from
which to derive mapping intervals, and (optionally) the **layer** for
attribute data.

In thematic maps, the color or point size changes for each range of
attribute values. Value ranges for thematic mapping can be set at
*regular intervals*, *standard deviation* units on either side of the
*mean*, *quartiles*, or delimited by *user-defined breakpoints*, see
**themecalc** option. User-defined breakpoints
(**themecalc=custom\_breaks**) can be entered via **breakpoints**
option.

## NOTES

There is option **colorscheme** to define the color scheme (graduated
colors) and range of point sizes (graduated points) for thematic maps.

Optionally, a simple text legend is printed when **-l** flag is given. A
graphic legend can be drawn in the selected display monitor.

Thematic colors can be uploaded by **rgb\_column** option to a specified
attribute column (which is created automatically if doesn't exist in the
table) for later display via
*[d.vect](https://grass.osgeo.org/grass-stable/manuals/d.vect.html)* and
**rgb\_column** option.

When the **psmap** option is set to 'name', two psmap instruction files
are created (in the current directory if no path is given), one for the
map ('name.psmap') and one for the legend ('name\_legend.psmap'). The
map file also contains 'label' commands which allow to create a legend
directly in the map by adding a 'vlegend' command. See the
*[ps.map](ps.map)* manual page for more details.

The algorithm currently uses the
*[v.univar](https://grass.osgeo.org/grass-stable/manuals/v.univar.html)*
to calculate basic descriptive statistics needed for thematic mapping
(minimum, maximum, mean, standard deviation, and quartiles).

## EXAMPLES

Earthquake points with color gradient:

```sh
d.vect.thematic2 -l recent_earthquakes column=magnitude type=point
```

Earthquake points with different sizes:

```sh
d.vect.thematic2 -l recent_earthquakes column=magnitude type=point \
                themetype=graduated_points maxsize=15
```

![image-alt](d_vect_thematic_equake.png)  
Example for earthquake map rendering ([script
code](https://github.com/OSGeo/grass-promo/tree/master/tutorials/batch_processing/earthquakes))

North Carolina: differences between 'elevation' (10m) and
'elev\_state\_500m':

```sh
# random sampling of elevation points:
g.region raster=elevation -p
v.random random npoints=200
v.db.addtable random column="el10 double precision"
# transfer elevations to attribute table of random points map:
v.what.rast random rast=elevation column=el10
v.db.select random

# comparative sampling of second map, incl. differences:
v.sample input=random column=el10 raster=elev_state_500m output=elev_sample
v.db.select elev_sample

# univariate statistics:
v.univar -e elev_sample column=diff type=point

# thematic map:
d.mon wx0
d.vect.thematic2 -l elev_sample column=diff type=point
```

North Carolina sample dataset example:

```sh
g.region vector=nc_state
d.vect.thematic2 -l precip_30ynormals column=annual type=point
```

## SEE ALSO

*[d.vect](https://grass.osgeo.org/grass-stable/manuals/d.vect.html),
[d.vect.chart](https://grass.osgeo.org/grass-stable/manuals/d.vect.chart.html),
[v.univar](https://grass.osgeo.org/grass-stable/manuals/v.univar.html)*

## AUTHORS

Michael Barton, Arizona State University

Various updates by:  
Daniel Cavelo Aros,  
Martin Landa,  
Jachym Cepicky

## SOURCE CODE

Available at: [d.vect.thematic2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/display/d.vect.thematic2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/display/d.vect.thematic2))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
