---
name: db.csw.run.py
description: CSW wsgi handler
keywords: [ csw, metadata ]
---

# db.csw.run.py

CSW wsgi handler

=== "Command line"

    **db.csw.run.py**
    **path**=*string*
    **port**=*integer*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.csw.run.py path=/var/www/html/pycsw port=8000
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.csw.run.py***",
        **path**=*"/var/www/html/pycsw"*,
        **port**=*8000*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.csw.run.py", path="/var/www/html/pycsw", port=8000)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_csw_run_py*(**path**=*"/var/www/html/pycsw"*,
        **port**=*8000*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_csw_run_py(path="/var/www/html/pycsw", port=8000)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **path**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;path to pycsw instal folder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */var/www/html/pycsw*  
    **port**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;server port  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8000*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **path** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;path to pycsw instal folder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */var/www/html/pycsw*  
    **port** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;server port  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8000*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **path** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;path to pycsw instal folder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */var/www/html/pycsw*  
    **port** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;server port  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8000*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**db.csw.run** is designed to interact with Catalog Service for the Web
(CSW) servers for metadata management purposes. It is implemented as a
WSGI wrapper for pycsw and the module for starting the server on
localhost.

## NOTES

...

## SEE ALSO

*[r.info](https://grass.osgeo.org/grass-stable/manuals/r.info.html),
[v.info.iso](v.info.iso.md), [g.gui.metadata](g.gui.metadata.md)
[db.csw.harvest](db.csw.harvest) [db.csw.admin](db.csw.admin)
[db.csw.run](db.csw.run)*

See also related [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

## AUTHORS

Matej Krejci, [OSGeoREL](https://geo.fsv.cvut.cz/gwiki/osgeorel) at the
Czech Technical University in Prague, developed during [Google Summer of
Code 2014](https://trac.osgeo.org/grass/wiki/GSoC/2014/MetadataForGRASS)
(mentors: Margherita Di Leo, Martin Landa)

## SOURCE CODE

Available at: [db.csw.run source code](https://github.com/OSGeo/grass-addons/tree/grass8/wxpython/wx.metadata/db.csw.run)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/wxpython/wx.metadata/db.csw.run))  
Latest change: Tuesday Jan 06 21:39:11 2026 in commit [22f101f](https://github.com/OSGeo/grass-addons/commit/22f101f1686a37f902e9631c79a905d905c66bf2)
