---
name: db.out.ogr.py
description: Exports attribute tables into various formats.
keywords: [ database, export, output, attribute table ]
---

# db.out.ogr.py

Exports attribute tables into various formats.

=== "Command line"

    **db.out.ogr.py**
    **input**=*name*
    **output**=*name*
    [**layer**=*string*]
    **format**=*string*
    [**table**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.out.ogr.py input=name output=name format=CSV
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.out.ogr.py***",
        **input**,
        **output**,
        **layer**=*"1"*,
        **format**=*"CSV"*,
        **table**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.out.ogr.py", input="name", output="name", format="CSV")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_out_ogr_py*(**input**,
        **output**,
        **layer**=*"1"*,
        **format**=*"CSV"*,
        **table**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_out_ogr_py(input="name", output="name", format="CSV")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output table file name or DB connection string  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Table format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CSV, DBF, GML, MySQL, PostgreSQL, SQLite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CSV*  
    **table**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output table (default: input name)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output table file name or DB connection string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Table format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CSV, DBF, GML, MySQL, PostgreSQL, SQLite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CSV*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output table (default: input name)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output table file name or DB connection string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Table format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CSV, DBF, GML, MySQL, PostgreSQL, SQLite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *CSV*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output table (default: input name)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.out.ogr* exports GRASS attribute tables into various formats as
supported by the OGR driver on the local system (CSV, DBF, PostgreSQL,
SQLite, MySQL, ODBC, etc.).

The *output* parameter is used to define the output file name (if the
path is not defined, the module will attempt to write to the current
directory). In case of a database connection as output, the connection
string has to be specified.

The *layer* parameter is needed if the attribute table to be exported is
linked as non-default layer to a vector map.

## EXAMPLES

### Export of GRASS attribute table to a CSV table file (default format)

```sh
db.out.ogr input=precip_30ynormals output=precip_30ynormals.csv
```

### Export of a GRASS attribute table to a DBF table

```sh
db.out.ogr input=precip_30ynormals output=precip_30ynormals.dbf format=DBF
```

### Export of GRASS attribute table into a PostgreSQL table

```sh
db.out.ogr input=precip_30ynormals \
           output="PG:host=localhost dbname=meteo user=neteler" \
           format=PostgreSQL
# verify
echo "SELECT * FROM precip_30ynormals" | psql meteo
```

## SEE ALSO

*[db.tables](db.tables.md)*

*[GRASS SQL interface](sql.md)*

## AUTHORS

Markus Neteler  
Converted to Python by Glynn Clements

## SOURCE CODE

Available at: [db.out.ogr source code](https://github.com/OSGeo/grass/tree/main/scripts/db.out.ogr)
([history](https://github.com/OSGeo/grass/commits/main/scripts/db.out.ogr))  
Latest change: Tuesday Oct 21 09:57:14 2025 in commit [fb0165c](https://github.com/OSGeo/grass/commit/fb0165c2d021b7700528aca09c224847be871729)
