---
name: g.gui.photo2image
description: Corrects scanning distortions of a paper photo.
keywords: [ imagery, GUI, aerial, photo, georectification, geometry, GCP ]
description: wxGUI GCP Manager for photo to image registration
index: topic_GUI|GUI
---

# g.gui.photo2image

Corrects scanning distortions of a paper photo.

=== "Command line"

    **g.gui.photo2image**
    **group**=*name*
    **raster**=*name*
    **camera**=*string*
    **order**=*string*
    **extension**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.photo2image group=name raster=name camera=string order=1 extension=_ip2i_out
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.photo2image***",
        **group**,
        **raster**,
        **camera**,
        **order**=*"1"*,
        **extension**=*"_ip2i_out"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.photo2image", group="name", raster="name", camera="string", order="1", extension="_ip2i_out")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_photo2image*(**group**,
        **raster**,
        **camera**,
        **order**=*"1"*,
        **extension**=*"_ip2i_out"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_photo2image(group="name", raster="name", camera="string", order="1", extension="_ip2i_out")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **raster**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **camera**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the camera (generated in i.ortho.camera)  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the camera (generated in i.ortho.camera)  
    **order**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The rectification order (no of Fiducial=4 -&gt; order=1, no of Fiducial=8 -&gt; order=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;The rectification order (no of Fiducial=4 -&gt; order=1, no of Fiducial=8 -&gt; order=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **extension**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output files extension (used in i.rectify)  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output files extension (used in i.rectify)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *_ip2i_out*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **raster** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **camera** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the camera (generated in i.ortho.camera)  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the camera (generated in i.ortho.camera)  
    **order** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The rectification order (no of Fiducial=4 -&gt; order=1, no of Fiducial=8 -&gt; order=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;The rectification order (no of Fiducial=4 -&gt; order=1, no of Fiducial=8 -&gt; order=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **extension** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output files extension (used in i.rectify)  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output files extension (used in i.rectify)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *_ip2i_out*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **raster** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **camera** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the camera (generated in i.ortho.camera)  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the camera (generated in i.ortho.camera)  
    **order** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The rectification order (no of Fiducial=4 -&gt; order=1, no of Fiducial=8 -&gt; order=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;The rectification order (no of Fiducial=4 -&gt; order=1, no of Fiducial=8 -&gt; order=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **extension** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output files extension (used in i.rectify)  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output files extension (used in i.rectify)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *_ip2i_out*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

# wxGUI GCP Manager for photo to image registration

## DESCRIPTION

This module is based on **g.gui.gcp**, the GCP manager of GRASS. It
is part of i.ortho.photo suite.

The aim of this module is to give absolute location values to the
fiducial points present (in number of 4 or 8) in a *scanned* aerial
photo.

This is necessary as (manual) scanning introduces distortions, rotations
and also may not be limited to scan the boundary of the photo itself. It
is thus necessary to give to each fiducial the exact coordinates in mm
as given by the aerial photographic instrument design, which is unique
per camera.

This module requires you to have made a group with your aerial photo
**(i.group)**, a camera description file **(i.ortho.target)** and use
them to launch the module. Additional requirements are the order of
rectification (1 if no of Fiducials is 4, 2 if no of Fiducials is 8) and
an extension file (if not given, defaults to \\filename_ip2i_out)

An example for project **imagery60**:

```sh
g.gui.photo2image group=aerial@PERMANENT raster=gs13.1@PERMANENT camera=gscamera order=2 extension=try --o
```

![Screenshot of g.gui.photo2image](wxGUI_iphoto2image_frame.jpg)  
*Figure: Screenshot of g.gui.photo2image*

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md)*

*[i.ortho.photo](i.ortho.photo.md), [i.group](i.group.md),
[i.ortho.camera](i.ortho.camera.md),
[i.ortho.target](i.ortho.target.md), [i.rectify](i.rectify.md),
[m.transform](m.transform.md), [v.rectify](v.rectify.md)*

See also [video
tutorials](https://grasswiki.osgeo.org/wiki/WxGUI/Video_tutorials#Georectifier)
on GRASS Wiki.

## AUTHORS

Markus Metz  
  
*Based on the Georectifier (GRASS 6.4.0)* by Michael Barton  
Martin Landa, Czech Technical University in Prague, Czech Republic

## SOURCE CODE

Available at: [g.gui.photo2image source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/photo2image)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/photo2image))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
