---
name: g.isis3mt.py
description: Generates an ISIS3 map template file according to the current GRASS GIS coordinate reference system.
keywords: [ coordinates, projection ]
---

# g.isis3mt.py

Generates an ISIS3 map template file according to the current GRASS GIS coordinate reference system.

=== "Command line"

    **g.isis3mt.py**
    [**-a**]
    **body**=*string*
    **out**=*string*
    [**outres**=*float*]
    [**restype**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.isis3mt.py body=MOON out=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.isis3mt.py***",
        **body**,
        **out**,
        **outres**=*None*,
        **restype**=*"mpp"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.isis3mt.py", body="MOON", out="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_isis3mt_py*(**body**,
        **out**,
        **outres**=*None*,
        **restype**=*"mpp"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_isis3mt_py(body="MOON", out="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **body**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Target planetary body  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *MOON, MERCURY, VENUS, MARS, Phobos, Deimos, JUPITER, Amalthea, Io, Europa, Ganymede, Callisto, SATURN, Janus, Epimetheus, Mimas, Enceladus, Tethys, Dione, Rhea, Titan, Hyperion, Iapetus, URANUS, Miranda, Ariel, Umbriel, Titania, Oberon, NEPTUNE*  
    **out**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Filename for the ISIS3 maptemplate to be generated  
    **outres**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of the ISIS3 projected data (default is: camera resolution)  
    **restype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution type: meters per pixel (mpp) or pixels per degree (ppd)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mpp, ppd*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mpp*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Align ISIS3 data to the extents of the current GRASS region  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **body** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Target planetary body  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *MOON, MERCURY, VENUS, MARS, Phobos, Deimos, JUPITER, Amalthea, Io, Europa, Ganymede, Callisto, SATURN, Janus, Epimetheus, Mimas, Enceladus, Tethys, Dione, Rhea, Titan, Hyperion, Iapetus, URANUS, Miranda, Ariel, Umbriel, Titania, Oberon, NEPTUNE*  
    **out** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filename for the ISIS3 maptemplate to be generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **outres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of the ISIS3 projected data (default is: camera resolution)  
    **restype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution type: meters per pixel (mpp) or pixels per degree (ppd)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mpp, ppd*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mpp*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align ISIS3 data to the extents of the current GRASS region  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **body** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Target planetary body  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *MOON, MERCURY, VENUS, MARS, Phobos, Deimos, JUPITER, Amalthea, Io, Europa, Ganymede, Callisto, SATURN, Janus, Epimetheus, Mimas, Enceladus, Tethys, Dione, Rhea, Titan, Hyperion, Iapetus, URANUS, Miranda, Ariel, Umbriel, Titania, Oberon, NEPTUNE*  
    **out** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filename for the ISIS3 maptemplate to be generated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **outres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of the ISIS3 projected data (default is: camera resolution)  
    **restype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution type: meters per pixel (mpp) or pixels per degree (ppd)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mpp, ppd*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mpp*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align ISIS3 data to the extents of the current GRASS region  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.isis3mt* Generates an ISIS3 map template file according to the
current GRASS projection parameters

## NOTE

The ISIS3 user should use `matchmap=yes` in `cam2mapi`.

## AUTHORS

Alessandro Frigeri, INA, Ispra, Italy  
Added to GRASS 7 by Yann Chemin

## SOURCE CODE

Available at: [g.isis3mt source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.isis3mt)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.isis3mt))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
