---
name: g.proj.identify.py
description: Autoidentifies EPSG code from WKT CRS definition.
keywords: [ general, projection, EPSG, WKT, .prj ]
---

# g.proj.identify.py

Autoidentifies EPSG code from WKT CRS definition.

=== "Command line"

    **g.proj.identify.py**
    [**-pws**]
    [**wkt**=*name*]
    [**epsg**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.proj.identify.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.proj.identify.py***",
        **wkt**=*None*,
        **epsg**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.proj.identify.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_proj_identify_py*(**wkt**=*None*,
        **epsg**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_proj_identify_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **wkt**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file with WKT definition  
    **epsg**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input EPSG code  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print projection info in Proj4 format  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print projection info in WKT format  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Save as default EPSG in the current location  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **wkt** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file with WKT definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **epsg** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input EPSG code  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *w*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print projection info in Proj4 format  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print projection info in WKT format  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Save as default EPSG in the current location  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **wkt** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file with WKT definition  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **epsg** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input EPSG code  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *w*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print projection info in Proj4 format  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print projection info in WKT format  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Save as default EPSG in the current location  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.proj.identify* allows to automaticaly identify the EPSG code from a
given Well-Know Text (WKT) projection string stored in a file. The user
can also print the EPSG code of the current location. The conversion
from a given EPSG code to WKT and proj4 is supported.

## EXAMPLE

```sh
# print EPSG code of current Location - use without parameters
g.proj.identify

# identify EPSG code from WKT definition stored in file 'myproj.wkt'
g.proj.identify wkt=myproj.wkt

# print WKT and proj4 for given EPSG code, independent from current location
g.proj.identify -p -w epsg=4326
```

## SEE ALSO

*[g.proj](https://grass.osgeo.org/grass-stable/manuals/g.proj.html),
[m.proj](https://grass.osgeo.org/grass-stable/manuals/m.proj.html),
[r.proj](https://grass.osgeo.org/grass-stable/manuals/r.proj.html),
[v.proj](https://grass.osgeo.org/grass-stable/manuals/v.proj.html)*

## AUTHORS

Matej Krejci, [OSGeoREL](https://geo.fsv.cvut.cz/gwiki/osgeorel) at the
Czech Technical University in Prague, developed during [Google Summer of
Code 2015](https://trac.osgeo.org/grass/wiki/GSoC/2014/MetadataForGRASS)
(mentor: Martin Landa)

## SOURCE CODE

Available at: [g.proj.identify source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.proj.identify)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.proj.identify))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
