---
name: g.rename.many.py
description: Renames multiple maps in the current mapset.
keywords: [ general, map management, rename ]
---

# g.rename.many.py

Renames multiple maps in the current mapset.

=== "Command line"

    **g.rename.many.py**
    [**-sd**]
    [**raster**=*name*]
    [**raster_3d**=*name*]
    [**vector**=*name*]
    [**separator**=*character*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.rename.many.py raster=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.rename.many.py***",
        **raster**=*None*,
        **raster_3d**=*None*,
        **vector**=*None*,
        **separator**=*"comma"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.rename.many.py", raster="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_rename_many_py*(**raster**=*None*,
        **raster_3d**=*None*,
        **vector**=*None*,
        **separator**=*"comma"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_rename_many_py(raster="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with rasters to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one raster map per line. Old name first, new name second (separated by comma by default)  
    **raster_3d**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with 3D rasters to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one raster map per line. Old name first, new name second (separated by comma by default)  
    **vector**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with vectors to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one vector map per line. Old name first, new name second (separated by comma by default)  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip file format and map existence checks  
    &nbsp;&nbsp;&nbsp;&nbsp;By default a file format check is performed and existence of map is checked before the actual renaming. This requires going through each file two times. It might be advantageous to disable the checks for renames of large number of maps. However, when this flag is used an error occurs, some maps might be renamed while some others not.  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do the checks only (dry run)  
    &nbsp;&nbsp;&nbsp;&nbsp;This will only perform the file format and map existence checks but it will not do the actual rename. This is useful when writing the file with renames.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with rasters to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one raster map per line. Old name first, new name second (separated by comma by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **raster_3d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with 3D rasters to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one raster map per line. Old name first, new name second (separated by comma by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **vector** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with vectors to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one vector map per line. Old name first, new name second (separated by comma by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip file format and map existence checks  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default a file format check is performed and existence of map is checked before the actual renaming. This requires going through each file two times. It might be advantageous to disable the checks for renames of large number of maps. However, when this flag is used an error occurs, some maps might be renamed while some others not.  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do the checks only (dry run)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This will only perform the file format and map existence checks but it will not do the actual rename. This is useful when writing the file with renames.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **raster** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with rasters to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one raster map per line. Old name first, new name second (separated by comma by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **raster_3d** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with 3D rasters to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one raster map per line. Old name first, new name second (separated by comma by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **vector** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File with vectors to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Format of the file is one vector map per line. Old name first, new name second (separated by comma by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip file format and map existence checks  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default a file format check is performed and existence of map is checked before the actual renaming. This requires going through each file two times. It might be advantageous to disable the checks for renames of large number of maps. However, when this flag is used an error occurs, some maps might be renamed while some others not.  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do the checks only (dry run)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This will only perform the file format and map existence checks but it will not do the actual rename. This is useful when writing the file with renames.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.rename.many* renames multiple maps at once using
*[g.rename](https://grass.osgeo.org/grass-stable/manuals/g.rename.html)*
module. Old and new names are read from a text file. The file format is
a simple CSV (comma separated values) format with no text delimiter
(e.g. no quotes around cell content). Comma is a default cell delimiter
but it can be changed to anything.

Possible use cases include:

- renaming maps named in a certain language to English when data were
    obtained at national level but the futher collaboration is
    international
- renaming provided sample maps with English names to a national
    language for educational purposes in case English is not appropriate
- preparation of a [GRASS GIS Standardized Sample
    Dataset](https://grasswiki.osgeo.org/wiki/GRASS_GIS_Standardized_Sample_Datasets)
    which requires a certain set of standardized names

## EXAMPLE

### Renaming rasters

First prepare a file with names of raster maps to be renamed. The file
can be prepared in spreadsheet application (and saved as CSV with cell
delimiter comma and no text delimiter) or as a text file in any (plain)
text editor. In any case, the result should be a plain text file with
format and content similar to the following sample:

```csv
landuse96_28m,landuse
geology_30m,geology
soilsID,soils
```

Once the file is prepared, the module can be called:

```sh
g.rename.many raster=raster_names.csv
```

This example worked only with raster maps. However multiple files, one
for each map type, can be used at once.

### Creating a file with current names

A template for renaming can be prepared using
*[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html)*
module, for example in command line (bash syntax):

```sh
g.list type=raster mapset=. sep=",
" > raster_names.csv
```

Note that we are using only maps in a current Mapset because these are
the only ones we can rename.

With some further processing file template can be made more complete by
including map names twice (bash syntax):

```sh
g.list type=raster mapset=. | sed -e "s/\(.*\)/\1,\1/g" > raster_names.csv
```

The *sed* expression used here takes whatever is on a line on input and
puts it twice on one line on the output separated by comma.

## SEE ALSO

*[g.rename](https://grass.osgeo.org/grass-stable/manuals/g.rename.html),
[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html)*

## AUTHOR

Vaclav Petras, [NCSU OSGeoREL](https://geospatial.ncsu.edu/osgeorel/)

## SOURCE CODE

Available at: [g.rename.many source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.rename.many)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.rename.many))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
