---
name: i.cutlines.py
description: Creates semantically meaningful tile borders
keywords: [ imagery, tiling ]
---

# i.cutlines.py

Creates semantically meaningful tile borders

=== "Command line"

    **i.cutlines.py**
    **input**=*name*
    **output**=*name*
    **number_lines**=*integer*
    **edge_detection**=*string*
    [**existing_cutlines**=*name* [,*name*,...]]
    **no_edge_friction**=*integer*
    **lane_border_multiplier**=*integer*
    [**min_tile_size**=*integer*]
    [**zc_threshold**=*float*]
    [**zc_width**=*integer*]
    [**canny_low_threshold**=*float*]
    [**canny_high_threshold**=*float*]
    [**canny_sigma**=*float*]
    [**tile_width**=*integer*]
    [**tile_height**=*integer*]
    [**overlap**=*integer*]
    **processes**=*integer*
    **memory**=*integer*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.cutlines.py input=name output=name number_lines=0 edge_detection=zc no_edge_friction=5 lane_border_multiplier=10 processes=1 memory=300
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.cutlines.py***",
        **input**,
        **output**,
        **number_lines**,
        **edge_detection**=*"zc"*,
        **existing_cutlines**=*None*,
        **no_edge_friction**=*5*,
        **lane_border_multiplier**=*10*,
        **min_tile_size**=*None*,
        **zc_threshold**=*1*,
        **zc_width**=*9*,
        **canny_low_threshold**=*3*,
        **canny_high_threshold**=*10*,
        **canny_sigma**=*2*,
        **tile_width**=*None*,
        **tile_height**=*None*,
        **overlap**=*1*,
        **processes**=*1*,
        **memory**=*300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.cutlines.py", input="name", output="name", number_lines=0, edge_detection="zc", no_edge_friction=5, lane_border_multiplier=10, processes=1, memory=300)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_cutlines_py*(**input**,
        **output**,
        **number_lines**,
        **edge_detection**=*"zc"*,
        **existing_cutlines**=*None*,
        **no_edge_friction**=*5*,
        **lane_border_multiplier**=*10*,
        **min_tile_size**=*None*,
        **zc_threshold**=*1*,
        **zc_width**=*9*,
        **canny_low_threshold**=*3*,
        **canny_high_threshold**=*10*,
        **canny_sigma**=*2*,
        **tile_width**=*None*,
        **tile_height**=*None*,
        **overlap**=*1*,
        **processes**=*1*,
        **memory**=*300*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_cutlines_py(input="name", output="name", number_lines=0, edge_detection="zc", no_edge_friction=5, lane_border_multiplier=10, processes=1, memory=300)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use as input for tiling  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with cutline polygons  
    **number_lines**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tile border lines in each direction  
    **edge_detection**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Edge detection algorithm to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *zc, canny*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *zc*  
    **existing_cutlines**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector maps with existing cutlines  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    **no_edge_friction**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional friction for non-edge pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **lane_border_multiplier**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier for borders of lanes compared to non-edge pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **min_tile_size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of tiles in map units  
    **zc_threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sensitivity of Gaussian filter (i.zc)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **zc_width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;x-y extent of the Gaussian filter (i.zc)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **canny_low_threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low treshold for edges (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **canny_high_threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;High treshold for edges (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **canny_sigma**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel radius (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **tile_width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles for tiled edge detection (pixels)  
    **tile_height**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles for tiled edge detection (pixels)  
    **overlap**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap between tiles for tiled edge detection (pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **processes**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;RAM memory available (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use as input for tiling  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with cutline polygons  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **number_lines** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tile border lines in each direction  
    **edge_detection** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Edge detection algorithm to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *zc, canny*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *zc*  
    **existing_cutlines** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector maps with existing cutlines  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **no_edge_friction** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional friction for non-edge pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **lane_border_multiplier** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier for borders of lanes compared to non-edge pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **min_tile_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of tiles in map units  
    **zc_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sensitivity of Gaussian filter (i.zc)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **zc_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;x-y extent of the Gaussian filter (i.zc)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **canny_low_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low treshold for edges (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **canny_high_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;High treshold for edges (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **canny_sigma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel radius (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **tile_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles for tiled edge detection (pixels)  
    **tile_height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles for tiled edge detection (pixels)  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap between tiles for tiled edge detection (pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **processes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;RAM memory available (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use as input for tiling  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with cutline polygons  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **number_lines** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tile border lines in each direction  
    **edge_detection** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Edge detection algorithm to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *zc, canny*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *zc*  
    **existing_cutlines** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector maps with existing cutlines  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **no_edge_friction** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional friction for non-edge pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **lane_border_multiplier** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier for borders of lanes compared to non-edge pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **min_tile_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of tiles in map units  
    **zc_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sensitivity of Gaussian filter (i.zc)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **zc_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;x-y extent of the Gaussian filter (i.zc)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **canny_low_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Low treshold for edges (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **canny_high_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;High treshold for edges (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **canny_sigma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel radius (i.edge)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **tile_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles for tiled edge detection (pixels)  
    **tile_height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles for tiled edge detection (pixels)  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap between tiles for tiled edge detection (pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **processes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;RAM memory available (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.cutlines* tiles the images into tiles with irregular borders that
avoid cutting through meaningful objects. This allows tiling an image
for parallel processing while avoiding border effects.

The approach used in *i.cutlines* is inspired by Soares et al (2016).
The module first uses an edge detection algorithm (which the user can
chose with the **edge\_detection** parameter) to identify edges in the
image. It then uses
[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html) and
[r.drain](https://grass.osgeo.org/grass-stable/manuals/r.drain) to draw
lines through the image, following edges when possible and going
straight when there are none.

The user can determine the number of lines desired (**number\_lines**)
in each direction and the friction associated with pixels which are not
on an edge detected in the image (**no\_edge\_friction**). The higher
this value, the more the module will follow the detected edges.

In order to avoid that all lines gather into one single lowest cost
path, the module defines a lane for each desired line. The parameter
**lane\_border\_multiplier** defines the a multiplier of the
**no\_edge\_friction** value, in order to define the cost to cross that
line, i.e. the lower the value, the more likely cutlines will join each
other across lanes. Output is in the form of vector polygon tiles. The
user can decide a minimum size defined in map units
(**min\_tile\_size**). Tiles smaller than that size will be merged with
the neighboring tile they share the longest border with.

The user can provide a series of auxiliary vector maps which contain
existing cutlines (roads, boundaries, etc) that the module should take
into account (**existing\_cutlines**). These can be either lines or
polygons. The module will transform all to potential cutlines.

For edge detection the user can chose between the
[i.zc](https://grass.osgeo.org/grass-stable/manuals/i.zc.html) module or
the [i.edge](i.edge.md) addon. For the former, the user can determine
the **zc\_threshold** and the **zc\_width** parameters. For the latter,
the **canny\_low\_threshold**, **canny\_high\_threshold** and
**canny\_sigma** parameters. See the manual page of the respective
modules for details about these parameters which might need tuning to
fit to the specific image. As these modules read the entire image into
RAM, *i.cutlines* allows the user to run split the image into
rectangular tiles and to process each tile separately. Tiles can be
defined with the **tile\_width**, **tile\_height** and **overlap**
parameters. If **processes** is higher than one, these tiles will be
processed in parallel as will the
[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html) calls
for the two directions.

The **memory** parameter determines the memory used both for the
[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html) runs.

## NOTES

Until GRASS GIS version 7.4 included, there was a parameter name
conflict between
[i.zc](https://grass.osgeo.org/grass-stable/manuals/i.zc.html) and the
GridModule class in pygrass. For older GRASS GIS versions tiled edge
detection is thus only possible with [i.edge](i.edge.md).

## EXAMPLES

### Zero-crossing edge detection

Using the default
[i.zc](https://grass.osgeo.org/grass-stable/manuals/i.zc.html) edge
detection without tiling, default parameters and 10 horizontal and 10
vertical cutlines, creating vector polygon output:

```sh
# ortho photo subarea
g.region raster=ortho_2001_t792_1m n=221070 s=219730 -p
i.cutlines input=ortho_2001_t792_1m number_lines=10 output=ortho_tiles_zc
```

[![image-alt](i_cutlines_default.png)](i_cutlines_default.png)  
Irregular vector tiles created for the NC demo data set orthophoto
(default setting)

### Canny edge detection

Using the
[i.edge](https://grass.osgeo.org/grass-stable/manuals/i.edge.html) Canny
edge detection with tiling and (needed) tile overlap, increased memory,
two parallel processes and 10 horizontal and 10 vertical cutlines,
creating vector polygon output:

```sh
# ortho photo subarea
g.region raster=ortho_2001_t792_1m n=221070 s=219730 -p
i.cutlines input=ortho_2001_t792_1m number_lines=10 edge_detection=canny \
  tile_width=500 tile_height=500 overlap=10 memory=2000 processes=2 output=ortho_tiles_canny
```

[![image-alt](i_cutlines_canny.png)](i_cutlines_canny.png)  
Irregular vector tiles created for the NC demo data set orthophoto
(Canny edge detection)

## REFERENCES

Soares, Anderson Reis, Thales Sehn Körting, and Leila Maria Garcia
Fonseca. 2016. "Improvements of the Divide and Segment Method for
Parallel Image Segmentation." Revista Brasileira de Cartografia 68 (6),
<http://www.lsie.unb.br/rbc/index.php/rbc/article/view/1602>

## SEE ALSO

[i.zc](https://grass.osgeo.org/grass-stable/manuals/i.zc.html),
[i.edge](i.edge.md),
[r.tile](https://grass.osgeo.org/grass-stable/manuals/r.tile.html),
[v.mkgrid](https://grass.osgeo.org/grass-stable/manuals/v.mkgrid.html),
[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html)

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [i.cutlines source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.cutlines)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.cutlines))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
