---
name: i.eb.z0m
description: Computes momentum roughness length (z0m) and surface roughness for heat transport (z0h) after Bastiaanssen (2004).
keywords: [ imagery, roughness length, energy balance, SEBAL ]
---

# i.eb.z0m

Computes momentum roughness length (z0m) and surface roughness for heat transport (z0h) after Bastiaanssen (2004).

=== "Command line"

    **i.eb.z0m**
    [**-p**]
    **input**=*name*
    [**coef**=*float*]
    [**hv_max**=*float*]
    [**hmr**=*float*]
    **output**=*name*
    [**z0h**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.z0m input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.z0m***",
        **input**,
        **coef**=*0.1*,
        **hv_max**=*1.5*,
        **hmr**=*0.02*,
        **output**,
        **z0h**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.z0m", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_z0m*(**input**,
        **coef**=*0.1*,
        **hv_max**=*1.5*,
        **hmr**=*0.02*,
        **output**,
        **z0h**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_z0m(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI map [-1.0;1.0], SAVI if -p flag  
    **coef**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the conversion factor from z0m and z0h (Bastiaanssen (2005) used 0.1), for -f flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **hv_max**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the vegetation height at max(NDVI) i.e. standard C3 crop could be 1.5m, not needed for -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **hmr**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the micro-relief height (h.m-r.) on flat bare ground, most references point to 2cm, not need for -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.02*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output z0m layer  
    **z0h**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output z0h layer  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use SAVI input only with equation of Pawan (2004)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI map [-1.0;1.0], SAVI if -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coef** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the conversion factor from z0m and z0h (Bastiaanssen (2005) used 0.1), for -f flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **hv_max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the vegetation height at max(NDVI) i.e. standard C3 crop could be 1.5m, not needed for -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **hmr** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the micro-relief height (h.m-r.) on flat bare ground, most references point to 2cm, not need for -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.02*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output z0m layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **z0h** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output z0h layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use SAVI input only with equation of Pawan (2004)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI map [-1.0;1.0], SAVI if -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coef** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the conversion factor from z0m and z0h (Bastiaanssen (2005) used 0.1), for -f flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **hv_max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the vegetation height at max(NDVI) i.e. standard C3 crop could be 1.5m, not needed for -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **hmr** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the micro-relief height (h.m-r.) on flat bare ground, most references point to 2cm, not need for -p flag  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.02*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output z0m layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **z0h** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output z0h layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use SAVI input only with equation of Pawan (2004)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.z0m* calculates the momentum roughness length (z0m) and optionally
the surface roughness for heat transport (z0h) as per SEBAL requirements
from Bastiaanssen (1995). Default: calculating from a NDVI with an
deterministic equation, as seen in Bastiaanssen (1995). Flag -p :
calculating from a SAVI with an empirical equation, as seen in Pawan
(2004). This is a typical input to sensible heat flux computations of
any energy balance modeling.

## NOTES

The NDVI map input and the ndvi\_max operation set, is only to get a
linear relationship from NDVI to vegetation height. The latter being
related to z0m by a factor 7. If you happen to have a vegetation height
(hv) map, then z0m=hv/7 and z0h=0.1\*z0m.

## TODO

## SEE ALSO

*[i.eb.h0](i.eb.h0.md)*

## REFERENCES

- Bastiaanssen, W.G.M., 1995. Regionalization of surface flux
    densities and moisture indicators in composite terrain; a remote
    sensing approach under clear skies in mediterranean climates. PhD
    thesis, Wageningen Agricultural Univ., The Netherland, 271 pp.
    ([PDF](https://edepot.wur.nl/206553))
- Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual ET
    Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
    Modeling. InTech.
    ([PDF](https://www.intechopen.com/books/evapotranspiration-remote-sensing-and-modeling/a-distributed-benchmarking-framework-for-actual-et-models),
    [DOI: 10.5772/23571](https://doi.org/10.5772/23571))

## AUTHOR

Yann Chemin

## SOURCE CODE

Available at: [i.eb.z0m source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.eb.z0m)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.eb.z0m))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
