---
name: i.histo.match.py
description: Calculate histogram matching of several images.
keywords: [ imagery, histogram matching ]
---

# i.histo.match.py

Calculate histogram matching of several images.

=== "Command line"

    **i.histo.match.py**
    **input**=*name* [,*name*,...]
    [**suffix**=*string*]
    [**output**=*name*]
    [**database**=*name*]
    [**max**=*integer*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.histo.match.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.histo.match.py***",
        **input**,
        **suffix**=*"match"*,
        **output**=*None*,
        **database**=*None*,
        **max**=*255*,
        **nprocs**=*0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.histo.match.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_histo_match_py*(**input**,
        **suffix**=*"match"*,
        **output**=*None*,
        **database**=*None*,
        **max**=*255*,
        **nprocs**=*0*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_histo_match_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to be analyzed  
    **suffix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *match*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for mosaic output map  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;DEPRECATED, do not use  
    **max**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the maximum value for raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to be analyzed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: |  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *match*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for mosaic output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DEPRECATED, do not use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **max** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the maximum value for raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster maps to be analyzed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: |  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *match*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for mosaic output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DEPRECATED, do not use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **max** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of the maximum value for raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.histo.match* performs histogram matching on the given input images.

## NOTES

The histogram matching method is based on the method Cumulative
Distribution Function (CDF) of two or more histograms. Each value of
original CDF is compared with the target histogram in order to obtain
the target CDF value closest to the original value.

## EXAMPLE

This example is based the [North Carolina GRASS sample data
set](https://grass.osgeo.org/download/sample-data) (complete GRASS
dataset).

```sh
# create the output with histogram matching
i.histo.match input=lsat5_1987_10,lsat7_2000_10

# set grey color to the new maps
r.colors map=lsat5_1987_10.match color=grey
r.colors map=lsat7_2000_10.match color=grey

# visualize and compare the results
```

### Original data

![i.histo.match original](i_histo_match_original.png)  

### Matched data

![i.histo.match matched](i_histo_match_matched.png)  

## SEE ALSO

*[i.ortho.photo](https://grass.osgeo.org/grass-stable/manuals/i.ortho.photo.html),
[i.rectify](https://grass.osgeo.org/grass-stable/manuals/i.rectify.html)*

## AUTHORS

Laura Zampa 2004, student of Dipartimento di Informatica e
Telecomunicazioni, Facolta' di Ingegneria, University of Trento and
ITC-irst, Trento (Italy); original PERL code

Luca Delucchi, Fondazione E. Mach (Italy); implementation with Python /
SQLite

Stefan Blumentrath (Norway); current, parallelized implementation with
Numpy

## SOURCE CODE

Available at: [i.histo.match source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.histo.match)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.histo.match))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
