---
name: i.in.spotvgt.py
description: Imports SPOT VGT NDVI data into a raster map.
keywords: [ imagery, import, NDVI, SPOT ]
---

# i.in.spotvgt.py

Imports SPOT VGT NDVI data into a raster map.

=== "Command line"

    **i.in.spotvgt.py**
    [**-a**]
    **input**=*name*
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.in.spotvgt.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.in.spotvgt.py***",
        **input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.in.spotvgt.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_in_spotvgt_py*(**input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_in_spotvgt_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input SPOT VGT NDVI HDF file  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Also import quality map (SM status map layer) and filter NDVI map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input SPOT VGT NDVI HDF file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also import quality map (SM status map layer) and filter NDVI map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input SPOT VGT NDVI HDF file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also import quality map (SM status map layer) and filter NDVI map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.in.spotvgt* imports SPOT Vegetation (1km, global) NDVI data sets.
After import the digital numbers (DN) are remapped to VEGETATION NDVI
values and the NDVI color table is applied. The imported DN map is
removed after remapping.

Apparently missing raster cells due to bad pixel quality are
reconstructed by the SPOT operating team in the NDVI file. The
differences between the filtered (-a flag) and raw NDVI map should be
compared.

## NOTES

The SPOT VGT files are delivered in HDF4 (Hierarchical Data Format
Release 4) format. It is required to have the GDAL libraries installed
with HDF4 support.

## EXAMPLE

### Export of entire world SPOT VGT maps

When working with SPOT VGT with entire world extent, it is recommended
to zoom to *w=180W* and *e=180E* instead of using the map extent for map
export. These entire world SPOT VGT data are exceeding -180.0 degree
which can lead to unhelpful large East-West coordinates in the exported
file. It is also recommended to then use an export command which
respects the user settings. Example:

```sh
# import:
i.in.spotvgt 0001_NDV.HDF

# export:
g.region w=180W e=180E n=75:00:16.071429N s=56:00:16.069919S res=0:00:32.142857 -p
r.out.gdal 0001_NDV format=GTiff out=spotndvi.tif
```

## SEE ALSO

*[r.in.gdal](r.in.gdal.md), [r.out.gdal](r.out.gdal.md)*

## REFERENCES

[SPOT Vegetation (1km, global) NDVI data set
server](http://free.vgt.vito.be/)  
[SPOT Vegetation FAQ](http://www.vgt.vito.be/faqnew/index.html)  
[1.13 How must I read the 8 bits of the status
map?](http://www.vgt.vito.be/faqnew/) - Quality map

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [i.in.spotvgt source code](https://github.com/OSGeo/grass/tree/main/scripts/i.in.spotvgt)
([history](https://github.com/OSGeo/grass/commits/main/scripts/i.in.spotvgt))  
Latest change: Thursday Aug 21 17:49:43 2025 in commit [f81f4c8](https://github.com/OSGeo/grass/commit/f81f4c83c0abe31a2d8ecea1b15975c51551c86f)
