---
name: i.landsat.import.py
description: Imports Landsat satellite data downloaded using i.landsat.download.
keywords: [ imagery, satellite, Landsat, import ]
---

# i.landsat.import.py

Imports Landsat satellite data downloaded using i.landsat.download.

=== "Command line"

    **i.landsat.import.py**
    [**-rlop**]
    **input**=*name*
    [**unzip_dir**=*name*]
    [**pattern**=*string*]
    [**pattern_file**=*string*]
    [**extent**=*string*]
    [**resample**=*string*]
    [**memory**=*integer*]
    [**register_output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.landsat.import.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.landsat.import.py***",
        **input**,
        **unzip_dir**=*None*,
        **pattern**=*None*,
        **pattern_file**=*None*,
        **extent**=*"input"*,
        **resample**=*"nearest"*,
        **memory**=*300*,
        **register_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.landsat.import.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_landsat_import_py*(**input**,
        **unzip_dir**=*None*,
        **pattern**=*None*,
        **pattern_file**=*None*,
        **extent**=*"input"*,
        **resample**=*"nearest"*,
        **memory**=*300*,
        **register_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_landsat_import_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory with downloaded Landsat data  
    **unzip_dir**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of directory into which Landsat zip-files are extracted (default=input)  
    **pattern**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Band name pattern to import  
    **pattern_file**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name pattern to import  
    **extent**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    **resample**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **register_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file to use with t.register  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reproject raster data using r.import if needed  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Link raster data instead of importing  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current location's projection)  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print raster data to be imported and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory with downloaded Landsat data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **unzip_dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of directory into which Landsat zip-files are extracted (default=input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **pattern** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Band name pattern to import  
    **pattern_file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name pattern to import  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **resample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **register_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file to use with t.register  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*, *o*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reproject raster data using r.import if needed  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link raster data instead of importing  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current location's projection)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster data to be imported and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input directory with downloaded Landsat data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **unzip_dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of directory into which Landsat zip-files are extracted (default=input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **pattern** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Band name pattern to import  
    **pattern_file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name pattern to import  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **resample** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resampling method to use for reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic, lanczos, bilinear_f, bicubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear_f**: bilinear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic_f**: bicubic interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **register_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file to use with t.register  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*, *o*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reproject raster data using r.import if needed  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link raster data instead of importing  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current location's projection)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster data to be imported and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *i.landsat.import* module allows importing Landsat 5, 7 and 8
products downloaded by the *[i.landsat.download](i.landsat.download.md)*
module.

By default *i.landsat.import* imports all Landsat bands within the scene
files found in the **input** directory. The number of scene files can be
optionally reduced with the **pattern\_file** option. In this option, a
regular expression for filtering the file names can be given, e.g.
'229083' for importing only scenes from path 229 and row 083.

By default *i.landsat.import* imports the full scene. Optionally, the
import can be reduced to the computational region extent with
**extent=region**.

Note that in case that the spatial reference system of the input data
differs from that of the GRASS GIS target location, the input data will
be reprojected internally by means of
*[r.import](https://grass.osgeo.org/grass-stable/manuals/r.import.html)*.
To speed up this process, a higher than default value can be specified
for the **memory** option.

If the user wants to ignore an insignificant mismatch in the spatial
reference system, the projection check can be suppressed with the **-o**
flag and data will be imported directly.

Alternatively, input data can be linked by means of
*[r.external](https://grass.osgeo.org/grass-stable/manuals/r.external.html)*
using **-l** flag. Note that linking data requires that Landsat input
data and GRASS location have the same spatial reference system (e.g.,
the same UTM zone). Take into account that USGS provides all Landsat
products in UTM north zones whether they belong to North or South
Hemisphere.

The number of Landsat bands to be imported can be optionally reduced by
the **pattern** option. Below an overview of Landsat 5 TM, 7 ETM and 8
OLI band's spatial resolution:

| Spatial resolution \[m\] | L5 Bands               | L7 Bands               | L8 Bands                       |
| ------------------------ | ---------------------- | ---------------------- | ------------------------------ |
| 15                       | \--                    | B8                     | B8                             |
| 30                       | B1, B2, B3, B4, B5, B7 | B1, B2, B3, B4, B5, B7 | B1, B2, B3, B4, B5, B6, B7, B9 |
| 60                       | \--                    | B6                     | \--                            |
| 100                      | \--                    | \--                    | B10, B11                       |
| 120                      | B6                     | \--                    | \--                            |

Note that while the original resolution of band 6 in Landsat 5 TM and
Landsat 7 ETM is 120 and 60 m respectively, they are provided with a
resampled resolution of 30 m. For further details about bands wavelength
and scene size, visit the [band
designations](https://www.usgs.gov/faqs/what-are-band-designations-landsat-satellites?qt-news_science_products=0#qt-news_science_products)
page at USGS website.

The file naming convention for Landsat scenes is explained in detail on
the [USGS Landsat Collections Level-1 Scene Naming Convention FAQ](https://www.usgs.gov/faqs/what-naming-convention-landsat-collections-level-1-scenes).

With the **register\_output** option *i.landsat.import* allows to create
a text file that can be used to register imported imagery data into a
space-time raster dateset (STRDS) by means of
*[t.register](https://grass.osgeo.org/grass-stable/manuals/t.register.html)*.
A register file typically contains 2 or 3 columns with the map name and
start time or the map name plus start and end time in the case of
interval time type. Landsat data is considered to be of *instance* time
type, i.e., we only have one point in time. Hence, the output register
file will contain the map name and start time separated by `|` when
using GRASS GIS stable version. In the case of GRASS GIS development
version which supports the band reference concept (see
*[i.band.library](https://grass.osgeo.org/grass-devel/manuals/i.band.library.html)*
module for details), the output register file is extended by a third
column containing the band reference information, see the examples
below.

## EXAMPLES

### List Landsat bands to import

At first, print the list of raster files to be imported by **-p**. For
each file also projection match with current location is printed
including detected input data EPSG code:

```sh
i.landsat.import -p input=data
```

### Import Landsat data

Limit import to only 4th and 5th bands:

```sh
i.landsat.import input=data pattern='B(4|5)'
```

Limit import to all bands with 30m resolution:

```sh
i.landsat.import input=data pattern='B(1|2|3|4|5|6|7|9)'
```

Link Landsat data:

```sh
i.landsat.import -l input=data
```

Link data from specific path and row while ignoring projection check

```sh
i.landsat.import -l -o input=data pattern_file='229083'
```

Limit import to bands 4 and 5 for path 229 and row 083 in 2019

```sh
i.landsat.import input=data pattern_file='229083_2019' pattern='B(4|5)'
```

Limit import to optical, NIR, thermal and QA\_PIXEL using a regular
expression (Landsat-8):

```sh
i.landsat.import input=data pattern='(B(2|3|4|5|6|7|8|10|11)|QA_PIXEL)'
```

Limit import to bands 4 and 5 for path 229 and row 083 in 2019 and get a
txt file to use in *t.register*

```sh
i.landsat.import input=data pattern_file='229083_2019' pattern='B(4|5)' \
    register_output=t_register.txt

# create a STRDS and register imported data
t.create output=landsat_ts title="Landsat 8 time series" \
    description="Landsat 8 data, path-row 229-83, year 2020"
t.register input=landsat_ts file=t_register.txt
```

## SEE ALSO

*[Overview of i.landsat tools](i.landsat.md)*

*[i.landsat.download](i.landsat.download.md),
[i.landsat.qa](i.landsat.qa.md),
[i.landsat.toar](https://grass.osgeo.org/grass-stable/manuals/i.landsat.toar.html),
[i.landsat8.swlst](https://grass.osgeo.org/grass-stable/manuals/addons/i.landsat8.swlst.html),
[r.import](https://grass.osgeo.org/grass-stable/manuals/r.import.html),
[r.external](https://grass.osgeo.org/grass-stable/manuals/r.external.html)*

## AUTHOR

[Veronica Andreo](https://veroandreo.gitlab.io/), CONICET, Argentina.

## SOURCE CODE

Available at: [i.landsat.import source code](https://github.com/OSGeo/grass-addons/tree/grass8/imagery/i.landsat/i.landsat.import)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/imagery/i.landsat/i.landsat.import))  
Latest change: Tuesday Jan 06 21:39:11 2026 in commit [22f101f](https://github.com/OSGeo/grass-addons/commit/22f101f1686a37f902e9631c79a905d905c66bf2)
