---
name: i.rh
description: Water in atmosphere: relative humidity, water vapour (saturated, actual)
keywords: [ imagery, atmosphere, humidity, water vapour, precipitable water ]
---

# i.rh

Water in atmosphere: relative humidity, water vapour (saturated, actual)

=== "Command line"

    **i.rh**
    [**-sae**]
    **pw**=*name*
    **pa**=*name*
    **ta**=*name*
    **dem**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.rh pw=name pa=name ta=name dem=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.rh***",
        **pw**,
        **pa**,
        **ta**,
        **dem**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.rh", pw="name", pa="name", ta="name", dem="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_rh*(**pw**,
        **pa**,
        **ta**,
        **dem**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_rh(pw="name", pa="name", ta="name", dem="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **pw**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Precipitable Water layer  
    **pa**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Atmospheric Pressure layer  
    **ta**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the mean daily air temperature layer  
    **dem**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation layer  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output layer  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output the saturated water vapour (esat)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output the actual water vapour (eact)  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output the atmospheric emissivity (eatm)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **pw** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Precipitable Water layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **pa** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Atmospheric Pressure layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ta** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the mean daily air temperature layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dem** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output the saturated water vapour (esat)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output the actual water vapour (eact)  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output the atmospheric emissivity (eatm)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **pw** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Precipitable Water layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **pa** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Atmospheric Pressure layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ta** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the mean daily air temperature layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dem** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the elevation layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output the saturated water vapour (esat)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output the actual water vapour (eact)  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output the atmospheric emissivity (eatm)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.rh* calculates the relative humidity -s will return saturated water
vapour instead. -a will return actual water vapour instead.

## NOTES

## REFERENCES

<https://www.researchgate.net/publication/227247013\_High-resolution\_Surface\_Relative\_Humidity\_Computation\_Using\_MODIS\_Image\_in\_Peninsular\_Malaysia/>

## SEE ALSO

*[i.vi](https://grass.osgeo.org/grass-stable/manuals/i.vi.html),
[i.albedo](https://grass.osgeo.org/grass-stable/manuals/i.albedo.html),
[i.wi](i.wi.md)*

## AUTHOR

Yann Chemin, Plumergat, France

## SOURCE CODE

Available at: [i.rh source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.rh)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.rh))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
