---
name: i.segment.hierarchical.py
description: Hierarchical segmentation
keywords: [ imagery, segment, parallel ]
---

# i.segment.hierarchical.py

Hierarchical segmentation

=== "Command line"

    **i.segment.hierarchical.py**
    **group**=*name*
    **thresholds**=*float* [,*float*,...]
    **output**=*name*
    [**outputs_prefix**=*string*]
    [**method**=*string*]
    [**similarity**=*string*]
    [**minsizes**=*integer* [,*integer*,...]]
    [**memory**=*integer*]
    [**iterations**=*integer*]
    [**seeds**=*name*]
    [**bounds**=*name*]
    [**width**=*integer*]
    [**height**=*integer*]
    [**overlap**=*integer*]
    [**processes**=*integer*]
    [**move**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.segment.hierarchical.py group=name thresholds=0.02,0.05 output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.segment.hierarchical.py***",
        **group**,
        **thresholds**=*0.02,0.05*,
        **output**,
        **outputs_prefix**=*"seg__%.2f"*,
        **method**=*"region_growing"*,
        **similarity**=*"euclidean"*,
        **minsizes**=*None*,
        **memory**=*300*,
        **iterations**=*20*,
        **seeds**=*None*,
        **bounds**=*None*,
        **width**=*None*,
        **height**=*None*,
        **overlap**=*0*,
        **processes**=*None*,
        **move**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.segment.hierarchical.py", group="name", thresholds=0.02,0.05, output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_segment_hierarchical_py*(**group**,
        **thresholds**=*0.02,0.05*,
        **output**,
        **outputs_prefix**=*"seg__%.2f"*,
        **method**=*"region_growing"*,
        **similarity**=*"euclidean"*,
        **minsizes**=*None*,
        **memory**=*300*,
        **iterations**=*20*,
        **seeds**=*None*,
        **bounds**=*None*,
        **width**=*None*,
        **height**=*None*,
        **overlap**=*0*,
        **processes**=*None*,
        **move**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_segment_hierarchical_py(group="name", thresholds=0.02,0.05, output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **thresholds**=*float* [,*float*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Segment thresholds  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.02,0.05*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output segment raster map  
    **outputs_prefix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster maps from segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *seg__%.2f*  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segmentation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *region_growing*  
    **similarity**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Similarity calculation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *euclidean*  
    **minsizes**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in a segment  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **iterations**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **seeds**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with starting seeds  
    **bounds**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input bounding/constraining raster map  
    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile width in pixels  
    **height**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile height in pixels  
    **overlap**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile overlap in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **processes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of concurrent processes  
    **move**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path where move and copy the mapset  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **thresholds** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segment thresholds  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.02,0.05*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output segment raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **outputs_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster maps from segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *seg__%.2f*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segmentation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *region_growing*  
    **similarity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Similarity calculation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *euclidean*  
    **minsizes** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in a segment  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **iterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **seeds** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with starting seeds  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **bounds** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input bounding/constraining raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile width in pixels  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile height in pixels  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile overlap in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of concurrent processes  
    **move** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path where move and copy the mapset  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **thresholds** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segment thresholds  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.02,0.05*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output segment raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **outputs_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster maps from segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *seg__%.2f*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segmentation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *region_growing*  
    **similarity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Similarity calculation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *euclidean*  
    **minsizes** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in a segment  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **iterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **seeds** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with starting seeds  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **bounds** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input bounding/constraining raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile width in pixels  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile height in pixels  
    **overlap** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tile overlap in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of concurrent processes  
    **move** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path where move and copy the mapset  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.segment.hierarchical* performs a hierarchical segmentation on a image
(group). The module uses *i.segment*.

## EXAMPLE

TODO

## SEE ALSO

*[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html)*

## AUTHOR

Pietro Zambelli (University of Trento)

## SOURCE CODE

Available at: [i.segment.hierarchical source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.segment.hierarchical)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.segment.hierarchical))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
