---
name: i.segment.stats.py
description: Calculates statistics describing raster areas.
keywords: [ imagery, segmentation, statistics, parallel ]
---

# i.segment.stats.py

Calculates statistics describing raster areas.

=== "Command line"

    **i.segment.stats.py**
    [**-rnsc**]
    **map**=*name*
    [**rasters**=*name* [,*name*,...]]
    [**raster_statistics**=*string* [,*string*,...]]
    [**area_measures**=*string* [,*string*,...]]
    [**csvfile**=*name*]
    [**separator**=*character*]
    [**vectormap**=*name*]
    [**processes**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.segment.stats.py map=name csvfile=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.segment.stats.py***",
        **map**,
        **rasters**=*None*,
        **raster_statistics**=*"mean,stddev,sum"*,
        **area_measures**=*"area,perimeter,compact_circle,fd"*,
        **csvfile**=*None*,
        **separator**=*"pipe"*,
        **vectormap**=*None*,
        **processes**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.segment.stats.py", map="name", csvfile="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_segment_stats_py*(**map**,
        **rasters**=*None*,
        **raster_statistics**=*"mean,stddev,sum"*,
        **area_measures**=*"area,perimeter,compact_circle,fd"*,
        **csvfile**=*None*,
        **separator**=*"pipe"*,
        **vectormap**=*None*,
        **processes**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_segment_stats_py(map="name", csvfile="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with areas (all pixels of an area have same id), such as the output of i.segment  
    **rasters**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster maps for statistics  
    **raster_statistics**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistics to calculate for each input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, range, mean, mean_of_abs, stddev, variance, coeff_var, sum, sum_abs, first_quart, median, third_quart, perc_90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean,stddev,sum*  
    **area_measures**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Area measurements to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, perimeter, compact_circle, compact_square, fd, xcoords, ycoords*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area,perimeter,compact_circle,fd*  
    **csvfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file containing statistics  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vectormap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional vector output map with statistics as attributes  
    **processes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel (for multiple rasters)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Adjust region to input map  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate neighborhood statistics  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not calculate any shape statistics  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not check rasters for null cells  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with areas (all pixels of an area have same id), such as the output of i.segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rasters** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster maps for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_statistics** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistics to calculate for each input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, range, mean, mean_of_abs, stddev, variance, coeff_var, sum, sum_abs, first_quart, median, third_quart, perc_90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean,stddev,sum*  
    **area_measures** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area measurements to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, perimeter, compact_circle, compact_square, fd, xcoords, ycoords*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area,perimeter,compact_circle,fd*  
    **csvfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file containing statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vectormap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional vector output map with statistics as attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel (for multiple rasters)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *n*, *s*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Adjust region to input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate neighborhood statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not calculate any shape statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not check rasters for null cells  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for input raster map with areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with areas (all pixels of an area have same id), such as the output of i.segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rasters** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster maps for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_statistics** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistics to calculate for each input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, range, mean, mean_of_abs, stddev, variance, coeff_var, sum, sum_abs, first_quart, median, third_quart, perc_90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean,stddev,sum*  
    **area_measures** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area measurements to include in the output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, perimeter, compact_circle, compact_square, fd, xcoords, ycoords*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area,perimeter,compact_circle,fd*  
    **csvfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file containing statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vectormap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for optional vector output map with statistics as attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel (for multiple rasters)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *n*, *s*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Adjust region to input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate neighborhood statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not calculate any shape statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not check rasters for null cells  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.segment.stats* calculates statistics for areas in a raster map. Areas
are defined by adjacent pixels with the same value. Such areas can be
the output of
*[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html)*
or
*[r.clump](https://grass.osgeo.org/grass-stable/manuals/r.clump.html)*.

Available statistics are those related to the shape, size and position
of the areas (see the
*[r.object.geometry](https://grass.osgeo.org/grass-stable/manuals/r.object.geometry.html)*
man page for more information on the statistics) and aggregated
statistics of pixel values of other raster maps (see
*[r.univar](https://grass.osgeo.org/grass-stable/manuals/r.univar.html)*
for details).

In addition, for each of the above statistics, the **-n** flag allows
the user to request the output of the mean and the standard deviation of
the values of the neighboring objects (all direct neighbors, diagonal
neighbors included), which allows gathering some context information for
each object. For this feature, the
*[r.neighborhoodmatrix](r.neighborhoodmatrix.md)* addon has to be
installed. Currently, the module calculates these context statistics for
all available shape and spectral statistics.

The user can chose between output in the form of a vector map of the
areas with the statistics in the attribute table (**vectormap**) and/or
in the form of a CSV text file (**csvfile**).

Because of the way
*[r.univar](https://grass.osgeo.org/grass-stable/manuals/r.univar.html)*
functions, it is difficult to handle cases where in some raster maps
values are all null in some of the areas. Because of this,
*i.segment.stats* checks the raster maps for existing null values and
excludes them if it find any, emitting a warning to inform the user. The
user can decide to ignore this check using the **c** flag, for example
when there are only a few null cells and no complete areas with only
null cells (i.e. the module can calculate statistics for areas with some
null cells in them).

## NOTES

The module respects the current region settings. The **-r** flag allows
to force the module to adjust the region to the input raster map before
calculating the statistics.

This module is a simple front-end to
*[r.univar](https://grass.osgeo.org/grass-stable/manuals/r.univar.html)*
and
*[r.object.geometry](https://grass.osgeo.org/grass-stable/manuals/r.object.geometry.html)*.
If other statistics are desired, these should probably be implemented in
those (or other) modules which can then be called from this module.

Problems can arise in the calculation of some form statistics for
certain segment forms. If errors arise, the user might want to try to
run
*[r.clump](https://grass.osgeo.org/grass-stable/manuals/r.clump.html)*
on the input raster file before running *i.segment.stats*.

When treating files with a large number objects, creating the vector map
can be very time-consuming. In that case, it might be easier to only
work with the **csvfile** output.

The processing of several raster input files for which to calculate
per-segment statistics can be parallelized by setting the **processes**
parameter to the number of desired parallel processes, with at most one
process per raster to be treated.

## EXAMPLE

```sh
i.group group=landsat_pan input=lsat7_2002_80
g.region rast=lsat7_2002_80 -p
i.segment group=landsat_pan output=ls_pan_seg01 threshold=0.1 memory=4000 minsize=50
i.segment.stats map=ls_pan_seg01 csvfile=segstats.csv vectormap=ls_pan_seg01 \
  rasters=lsat7_2002_10,lsat7_2002_20,lsat7_2002_30,lsat7_2002_40,lsat7_2002_50,lsat7_2002_70 \
  processes=4
```

## SEE ALSO

*[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html),
[r.univar](https://grass.osgeo.org/grass-stable/manuals/r.univar.html),
[v.rast.stats](https://grass.osgeo.org/grass-stable/manuals/v.rast.stats.html),
[r.object.geometry](https://grass.osgeo.org/grass-stable/manuals/r.object.geometry.html)*

*[v.class.mlR (Addon)](v.class.mlR.md)*

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [i.segment.stats source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.segment.stats)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.segment.stats))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
