---
name: m.csv.clean.py
description: Creates a cleaned-up copy a CSV files Creates CSV files which are ready to used in GRASS GIS
keywords: [ miscellaneous, CSV, ASCII ]
---

# m.csv.clean.py

Creates a cleaned-up copy a CSV files

Creates CSV files which are ready to used in GRASS GIS

=== "Command line"

    **m.csv.clean.py**
    **input**=*name*
    **separator**=*character*
    **output**=*name*
    **prefix**=*string*
    [**recognized_date**=*string* [,*string*,...]]
    [**clean_date**=*string*]
    **missing_names**=*string*
    [**cell_clean**=*string* [,*string*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.csv.clean.py input=name separator=comma output=name prefix=col_ missing_names=column
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***m.csv.clean.py***",
        **input**,
        **separator**=*"comma"*,
        **output**,
        **prefix**=*"col_"*,
        **recognized_date**=*None*,
        **clean_date**=*"date_%Y-%m-%d"*,
        **missing_names**=*"column"*,
        **cell_clean**=*"strip_whitespace,collapse_whitespace"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("m.csv.clean.py", input="name", separator="comma", output="name", prefix="col_", missing_names="column")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_csv_clean_py*(**input**,
        **separator**=*"comma"*,
        **output**,
        **prefix**=*"col_"*,
        **recognized_date**=*None*,
        **clean_date**=*"date_%Y-%m-%d"*,
        **missing_names**=*"column"*,
        **cell_clean**=*"strip_whitespace,collapse_whitespace"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_csv_clean_py(input="name", separator="comma", output="name", prefix="col_", missing_names="column")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input CSV file to clean up  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **separator**=*character* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Clean CSV output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **prefix**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for columns which don't start with a letter  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix itself must start with a letter of English alphabeth  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *col_*  
    **recognized_date**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Recognized date formats (e.g., %m/%d/%y)  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, %m/%d/%Y,%m/%d/%y matches 7/30/2021 and 7/30/21  
    **clean_date**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format for new clean-up date  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, %Y-%m-%d for 2021-07-30  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *date_%Y-%m-%d*  
    **missing_names**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names for the columns without a name in the header  
    &nbsp;&nbsp;&nbsp;&nbsp;If only one is provided, but more than one is need, underscore and column number is added  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *column*  
    **cell_clean**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Operations to apply to non-header cells in the body of the document  
    &nbsp;&nbsp;&nbsp;&nbsp;If only one is provided, but more than one is need, underscore and column number is added  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strip_whitespace, collapse_whitespace, date_format, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strip_whitespace,collapse_whitespace*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input CSV file to clean up  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Clean CSV output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for columns which don't start with a letter  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix itself must start with a letter of English alphabeth  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *col_*  
    **recognized_date** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Recognized date formats (e.g., %m/%d/%y)  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, %m/%d/%Y,%m/%d/%y matches 7/30/2021 and 7/30/21  
    **clean_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format for new clean-up date  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, %Y-%m-%d for 2021-07-30  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *date_%Y-%m-%d*  
    **missing_names** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names for the columns without a name in the header  
    &nbsp;&nbsp;&nbsp;&nbsp;If only one is provided, but more than one is need, underscore and column number is added  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *column*  
    **cell_clean** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operations to apply to non-header cells in the body of the document  
    &nbsp;&nbsp;&nbsp;&nbsp;If only one is provided, but more than one is need, underscore and column number is added  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strip_whitespace, collapse_whitespace, date_format, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strip_whitespace,collapse_whitespace*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input CSV file to clean up  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Clean CSV output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for columns which don't start with a letter  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix itself must start with a letter of English alphabeth  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *col_*  
    **recognized_date** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Recognized date formats (e.g., %m/%d/%y)  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, %m/%d/%Y,%m/%d/%y matches 7/30/2021 and 7/30/21  
    **clean_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format for new clean-up date  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, %Y-%m-%d for 2021-07-30  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *date_%Y-%m-%d*  
    **missing_names** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names for the columns without a name in the header  
    &nbsp;&nbsp;&nbsp;&nbsp;If only one is provided, but more than one is need, underscore and column number is added  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *column*  
    **cell_clean** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operations to apply to non-header cells in the body of the document  
    &nbsp;&nbsp;&nbsp;&nbsp;If only one is provided, but more than one is need, underscore and column number is added  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strip_whitespace, collapse_whitespace, date_format, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strip_whitespace,collapse_whitespace*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*m.csv.clean* reads a CSV (Comma Separated Value) file, cleans it, and
writes a new CSV file. The separator for CSV is comma (`,`) by default,
but it can be set to any single character such as semicolon (`;`), pipe
(`|`), or tabulator.

## NOTES

Originally, the name for this module was supposed to be *m.csv.polish*
and the module was to be accompanied with module named *m.csv.czech* for
checking the state of the CSV.

## EXAMPLES

### In GRASS GIS shell

The following would apply all the default fixes to the the file
`sampling_sites_raw.csv` and output a cleaned file `sampling_sites.csv`:

```sh
m.csv.clean input=sampling_sites_raw.csv output=sampling_sites.csv
```

### In any shell

The module is not using any information from the current location and
mapset, so it is very easy to run it with an adhoc temporary location by
executing a `grass --exec` command:

```sh
grass --tmp-project XY --exec m.csv.clean input=sampling_sites_raw.csv output=sampling_sites.csv
```

## SEE ALSO

- *[v.in.csv](v.in.csv.md)* for an addon module for importing CSV as
    vector points with coordinate transformation,
- *[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html)*
    for importing CSV as vector points with different approach,
- *[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html)*
    for an alternative CSV import using GDAL/OGR.

## AUTHOR

Vaclav Petras, [NCSU Center for Geospatial
Analytics](https://cnr.ncsu.edu/geospatial)

## SOURCE CODE

Available at: [m.csv.clean source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/misc/m.csv.clean)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/misc/m.csv.clean))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
