---
name: m.csw.update.py
description: Update catalogue service for the web connections resources candidates.
keywords: [ connections resources, csw, metadata ]
---

# m.csw.update.py

Update catalogue service for the web connections resources candidates.

=== "Command line"

    **m.csw.update.py**
    [**-aivnpswlxck**]
    [**spreadsheet**=*name*]
    [**url**=*string*]
    **xml**=*name*
    **xsd**=*name*
    **timeout**=*timeout*
    [**separator**=*separator*]
    [**proxy**=*proxy* [,*proxy*,...]]
    [**header**=*header* [,*header*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.csw.update.py xml=connections_resources.xml xsd=connections_resources.xsd timeout=10
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***m.csw.update.py***",
        **spreadsheet**=*"API-cases.ods"*,
        **url**=*None*,
        **xml**=*"connections_resources.xml"*,
        **xsd**=*"connections_resources.xsd"*,
        **timeout**=*10*,
        **separator**=*"': '"*,
        **proxy**=*None*,
        **header**=*"User-Agent=Mozilla/5.0"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("m.csw.update.py", xml="connections_resources.xml", xsd="connections_resources.xsd", timeout=10)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_csw_update_py*(**spreadsheet**=*"API-cases.ods"*,
        **url**=*None*,
        **xml**=*"connections_resources.xml"*,
        **xsd**=*"connections_resources.xsd"*,
        **timeout**=*10*,
        **separator**=*"': '"*,
        **proxy**=*None*,
        **header**=*"User-Agent=Mozilla/5.0"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_csw_update_py(xml="connections_resources.xml", xsd="connections_resources.xsd", timeout=10)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **spreadsheet**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to spreadsheet file (ODS format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *API-cases.ods*  
    **url**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spreadsheet file URL  
    **xml**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to CSW connections resources XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *connections_resources.xml*  
    **xsd**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to CSW connections resources validation schema XSD file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *connections_resources.xsd*  
    **timeout**=*timeout* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Timeout for checking if CSW connections resources URL is active  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **separator**=*separator*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator inside connections resources item string '{Name}{Separator}{URL}' (print only), use "separator"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *': '*  
    **proxy**=*proxy* [,*proxy*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the proxy with: "http=&lt;value&gt;,ftp=&lt;value&gt;"  
    **header**=*header* [,*header*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the header with: "User-Agent=&lt;value&gt;,Accept=&lt;value&gt;"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *User-Agent=Mozilla/5.0*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print all active (valid and active) CSW connections resources only  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print not active CSW connections resources only  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print valid CSW connections resources URLs  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print not valid CSW connections resources URLs  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print all new CSW connections (valid/not valid, active/not active) resources with following format '{Country}, {Governmental level}, {API provider}: {URL}'  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print new CSW connections resources summary info  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print default spreadsheet file URL  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print default local spreadsheet file URL  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Validate CSW connections resources XML file against XSD schema  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove and print not active CSW connection resources from XML file  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove and print not valid CSW connections resources from XML file  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **spreadsheet** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to spreadsheet file (ODS format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *API-cases.ods*  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spreadsheet file URL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **xml** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to CSW connections resources XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *connections_resources.xml*  
    **xsd** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to CSW connections resources validation schema XSD file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *connections_resources.xsd*  
    **timeout** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Timeout for checking if CSW connections resources URL is active  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *timeout*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator inside connections resources item string '{Name}{Separator}{URL}' (print only), use "separator"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *separator*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *': '*  
    **proxy** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the proxy with: "http=&lt;value&gt;,ftp=&lt;value&gt;"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *proxy*  
    **header** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the header with: "User-Agent=&lt;value&gt;,Accept=&lt;value&gt;"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *header*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *User-Agent=Mozilla/5.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *i*, *v*, *n*, *p*, *s*, *w*, *l*, *x*, *c*, *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all active (valid and active) CSW connections resources only  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print not active CSW connections resources only  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print valid CSW connections resources URLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print not valid CSW connections resources URLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all new CSW connections (valid/not valid, active/not active) resources with following format '{Country}, {Governmental level}, {API provider}: {URL}'  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print new CSW connections resources summary info  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print default spreadsheet file URL  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print default local spreadsheet file URL  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Validate CSW connections resources XML file against XSD schema  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove and print not active CSW connection resources from XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove and print not valid CSW connections resources from XML file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **spreadsheet** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to spreadsheet file (ODS format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *API-cases.ods*  
    **url** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spreadsheet file URL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **xml** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to CSW connections resources XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *connections_resources.xml*  
    **xsd** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to CSW connections resources validation schema XSD file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *connections_resources.xsd*  
    **timeout** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Timeout for checking if CSW connections resources URL is active  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *timeout*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator inside connections resources item string '{Name}{Separator}{URL}' (print only), use "separator"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *separator*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *': '*  
    **proxy** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the proxy with: "http=&lt;value&gt;,ftp=&lt;value&gt;"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *proxy*  
    **header** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the header with: "User-Agent=&lt;value&gt;,Accept=&lt;value&gt;"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *header*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *User-Agent=Mozilla/5.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *i*, *v*, *n*, *p*, *s*, *w*, *l*, *x*, *c*, *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all active (valid and active) CSW connections resources only  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print not active CSW connections resources only  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print valid CSW connections resources URLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print not valid CSW connections resources URLs  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print all new CSW connections (valid/not valid, active/not active) resources with following format '{Country}, {Governmental level}, {API provider}: {URL}'  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print new CSW connections resources summary info  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print default spreadsheet file URL  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print default local spreadsheet file URL  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Validate CSW connections resources XML file against XSD schema  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove and print not active CSW connection resources from XML file  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove and print not valid CSW connections resources from XML file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*m.csw.update* updates the CSW connections resource XML file (required
by the *g.gui.cswbrowser* and *g.gui.metadata* modules). If the **-p**
flag is used only printing instead of writing is done.

The module also allows validate the connections resources XML file
against XSD schema, remove invalid and not active CSW connections
resources candidates.

## NOTES

For dependencies and installation instructions see the [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

Stored new connections resources candidates are only those being active
and valid.

### Writing new connections resources candidates

Default source of the new candidates is a spreadsheet file (\*.ods),
which is to be stored in the module's *config/* directory. It is
possible to use the updated document directly from the web address, see
**-w** flag.

## EXAMPLES

Import and store new resources connections candidates (default):

```sh
m.csw.update url=API-cases.ods
```

Store new resources connections candidates along with printing a summary
info:

```sh
m.csw.update -s
```

Print only all new connections resources candidates (with following
format *'{Country}, {Governmental level}, {API provider}: {URL}'*) with
summary info:

```sh
m.csw.update -ps
```

Print only active new connections resources candidates with summary
info:

```sh
m.csw.update -pas
```

Validate the default connections resources XML file against XSD schema
plus validate individual CSW connection resources (remove and print non
active CSWs):

```sh
m.csw.update -xc
```

## SEE ALSO

*[g.gui.cswbrowser](g.gui.cswbrowser.md),
[g.gui.metadata](g.gui.metadata.md)*

See also related [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

## AUTHOR

Tomas Zigo

## SOURCE CODE

Available at: [m.csw.update source code](https://github.com/OSGeo/grass-addons/tree/grass8/wxpython/wx.metadata/m.csw.update)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/wxpython/wx.metadata/m.csw.update))  
Latest change: Tuesday Jan 06 21:39:11 2026 in commit [22f101f](https://github.com/OSGeo/grass-addons/commit/22f101f1686a37f902e9631c79a905d905c66bf2)
