---
name: m.gcp.filter
description: Filter Ground Control Points (GCPs).
keywords: [ miscellaneous, transformation, GCP ]
---

# m.gcp.filter

Filter Ground Control Points (GCPs).

=== "Command line"

    **m.gcp.filter**
    [**-bdu**]
    **group**=*name*
    **order**=*integer*
    **threshold**=*float*
    [**iterations**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.gcp.filter group=name order=0 threshold=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***m.gcp.filter***",
        **group**,
        **order**,
        **threshold**,
        **iterations**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("m.gcp.filter", group="name", order=0, threshold=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_gcp_filter*(**group**,
        **order**,
        **threshold**,
        **iterations**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_gcp_filter(group="name", order=0, threshold=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **order**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Rectification polynomial order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3*  
    **threshold**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Filtering threshold in CRS units  
    **iterations**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use backward transformations (default: forward transformations)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use GCP deviation (default: RMS)  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update GCPs  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **order** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rectification polynomial order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3*  
    **threshold** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filtering threshold in CRS units  
    **iterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *d*, *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use backward transformations (default: forward transformations)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use GCP deviation (default: RMS)  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update GCPs  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **order** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rectification polynomial order  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3*  
    **threshold** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filtering threshold in CRS units  
    **iterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *d*, *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use backward transformations (default: forward transformations)  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use GCP deviation (default: RMS)  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update GCPs  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*m.gcp.filter* filters GCPs using the distance between the computed
coordinates and the actual coordinates of each GCP. The result of the
filtering (number of points to use after filtering, number of points
filtered out, final RMS error) is printed out.

The transformation equations are computed anew for each iteration. The
GCP with the largest distance between the computed coordinates and the
actual coordinates is deactivated and the next iteration is started.
Filtering stops when the overall RMS error is below the given
**threshold** or when the number of active GCPs is equal to the required
minimum number of points or when the optional maximum number of
iterations (option **iterations**) has been reached. With the **-d**
flag, the largest GCP error is used instead of the overall RMS error.

*m.gcp.filter* uses by default the results of forward transformations
(source to target) for filtering. With the **-b** flag, the results of
backward transformations (target to source) are used.

The status of GCPs (active / inactive) is only updated with the **-u**
flag. GCPs that have been filtered out will be deactivated, not deleted.

## NOTES

The transformations are:

order=1:

```text
    e = [E0 E1][1].[1]
        [E2  0][e] [n]

    n = [N0 N1][1].[1]
        [N2  0][e] [n]
```

order=2:

```text
    e = [E0 E1 E3][1 ] [1 ]
        [E2 E4  0][e ].[n ]
        [E5  0  0][e²] [n²]

    n = [N0 N1 N3][1 ] [1 ]
        [N2 N4  0][e ].[n ]
        [N5  0  0][e²] [n²]
```

order=3:

```text
    e = [E0 E1 E3 E6][1 ] [1 ]
        [E2 E4 E7  0][e ].[n ]
        [E5 E8  0  0][e²] [n²]
        [E9  0  0  0][e³] [n³]

    n = [N0 N1 N3 N6][1 ] [1 ]
        [N2 N4 N7  0][e ].[n ]
        [N5 N8  0  0][e²] [n²]
        [N9  0  0  0][e³] [n³]
```

\["." = dot-product, (AE).N = N'EA.\]

In other words, order=1 and order=2 are equivalent to order=3 with the
higher coefficients equal to zero.

## SEE ALSO

*[m.transform](https://grass.osgeo.org/grass-stable/manuals/m.transform.html),
[i.rectify](https://grass.osgeo.org/grass-stable/manuals/i.rectify.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [m.gcp.filter source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/misc/m.gcp.filter)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/misc/m.gcp.filter))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
