---
name: r.agent.aco.py
description: Agents wander around on the terrain, marking paths to new locations.
keywords: [  ]
---

# r.agent.aco.py

Agents wander around on the terrain, marking paths to new locations.

=== "Command line"

    **r.agent.aco.py**
    [**-pscal**]
    **outputmap**=*string*
    [**inputmap**=*string*]
    **costmap**=*string*
    **sitesmap**=*string*
    **rounds**=*integer*
    [**outrounds**=*integer*]
    [**targetvisibility**=*integer*]
    [**highcostlimit**=*integer*]
    [**lowcostlimit**=*integer*]
    [**maxpheromone**=*integer*]
    [**minpheromone**=*integer*]
    [**volatilizationtime**=*integer*]
    [**stepintensity**=*integer*]
    [**pathintensity**=*integer*]
    [**maxants**=*integer*]
    [**antslife**=*integer*]
    **decisionalgorithm**=*string*
    **evaluateposition**=*string*
    [**agentfreedom**=*integer*]
    **pheromoneweight**=*integer*
    **randomnessweight**=*integer*
    **costweight**=*integer*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.agent.aco.py outputmap=string costmap=string sitesmap=string rounds=999 decisionalgorithm=standard evaluateposition=avoidorforgetloop pheromoneweight=1 randomnessweight=1 costweight=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.agent.aco.py***",
        **outputmap**,
        **inputmap**=*None*,
        **costmap**,
        **sitesmap**,
        **rounds**=*999*,
        **outrounds**=*None*,
        **targetvisibility**=*None*,
        **highcostlimit**=*None*,
        **lowcostlimit**=*None*,
        **maxpheromone**=*None*,
        **minpheromone**=*None*,
        **volatilizationtime**=*None*,
        **stepintensity**=*None*,
        **pathintensity**=*None*,
        **maxants**=*None*,
        **antslife**=*None*,
        **decisionalgorithm**=*"standard"*,
        **evaluateposition**=*"avoidorforgetloop"*,
        **agentfreedom**=*None*,
        **pheromoneweight**=*1*,
        **randomnessweight**=*1*,
        **costweight**=*0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.agent.aco.py", outputmap="string", costmap="string", sitesmap="string", rounds=999, decisionalgorithm="standard", evaluateposition="avoidorforgetloop", pheromoneweight=1, randomnessweight=1, costweight=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_agent_aco_py*(**outputmap**,
        **inputmap**=*None*,
        **costmap**,
        **sitesmap**,
        **rounds**=*999*,
        **outrounds**=*None*,
        **targetvisibility**=*None*,
        **highcostlimit**=*None*,
        **lowcostlimit**=*None*,
        **maxpheromone**=*None*,
        **minpheromone**=*None*,
        **volatilizationtime**=*None*,
        **stepintensity**=*None*,
        **pathintensity**=*None*,
        **maxants**=*None*,
        **antslife**=*None*,
        **decisionalgorithm**=*"standard"*,
        **evaluateposition**=*"avoidorforgetloop"*,
        **agentfreedom**=*None*,
        **pheromoneweight**=*1*,
        **randomnessweight**=*1*,
        **costweight**=*0*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_agent_aco_py(outputmap="string", costmap="string", sitesmap="string", rounds=999, decisionalgorithm="standard", evaluateposition="avoidorforgetloop", pheromoneweight=1, randomnessweight=1, costweight=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **outputmap**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of pheromone output map  
    **inputmap**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input pheromone raster map (e.g. from prior run)  
    **costmap**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of penalty resp. cost raster map (note conversion checkbox)  
    **sitesmap**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sites map, vector data with possible points of origin  
    **rounds**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of iterations/rounds to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *999*  
    **outrounds**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Produce output after running this number of iterations/rounds  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    **targetvisibility**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance to target from where it might be 'sensed'  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    **highcostlimit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Penalty values above this point an ant considers as illegal/bogus when in 'costlymarked' modus  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **lowcostlimit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Penalty values below this point an ant considers as illegal/bogus when in 'costlymarked' modus  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99999-99999*  
    **maxpheromone**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Absolute maximum of pheromone intensity a position may have  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *<minpheromone>-<max integer on system would make sense>*  
    **minpheromone**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Absolute minimum of pheromone intensity to leave on playground  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<maxpheromone>*  
    **volatilizationtime**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Half-life for pheromone to volatize (e.g. =rounds)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **stepintensity**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pheromone intensity to leave on each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **pathintensity**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pheromone intensity to leave on found paths  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **maxants**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum amount of ants that may live concurrently (x\*y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<the bigger the playground,  the more space they have>*  
    **antslife**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time to live for an ant (e.g. four times points distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **decisionalgorithm**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm used for walking step  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *standard, marked, costlymarked, random, test*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **evaluateposition**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm used for finding and remembering paths  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *standard, avoidloop, forgetloop, avoidorforgetloop*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *avoidorforgetloop*  
    **agentfreedom**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of possible directions the ant can take (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **pheromoneweight**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the pheromone value (P) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **randomnessweight**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the random value (R) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **costweight**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the penalty value (C) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow overwriting existing pheromone maps  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Produce a sequence of pheromone maps (by appending a number)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Overwrite existing cost map (only used with penalty conversion)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Auto-convert cost (slope..) to penalty map (using "tobler", see docu)  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Avoid loops on the way back  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **outputmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of pheromone output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **inputmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input pheromone raster map (e.g. from prior run)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **costmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of penalty resp. cost raster map (note conversion checkbox)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **sitesmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sites map, vector data with possible points of origin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector  
    **rounds** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of iterations/rounds to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Pݠ  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *999*  
    **outrounds** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Produce output after running this number of iterations/rounds  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Pݠ  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    **targetvisibility** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance to target from where it might be 'sensed'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Pݠ  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    **highcostlimit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Penalty values above this point an ant considers as illegal/bogus when in 'costlymarked' modus  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: X  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **lowcostlimit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Penalty values below this point an ant considers as illegal/bogus when in 'costlymarked' modus  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: H  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99999-99999*  
    **maxpheromone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Absolute maximum of pheromone intensity a position may have  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: @  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *<minpheromone>-<max integer on system would make sense>*  
    **minpheromone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Absolute minimum of pheromone intensity to leave on playground  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: D  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<maxpheromone>*  
    **volatilizationtime** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Half-life for pheromone to volatize (e.g. =rounds)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: \  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **stepintensity** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pheromone intensity to leave on each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: U  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **pathintensity** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pheromone intensity to leave on found paths  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: E  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **maxants** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum amount of ants that may live concurrently (x\*y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: T  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<the bigger the playground,  the more space they have>*  
    **antslife** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time to live for an ant (e.g. four times points distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: B  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **decisionalgorithm** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm used for walking step  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *standard, marked, costlymarked, random, test*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **evaluateposition** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm used for finding and remembering paths  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *standard, avoidloop, forgetloop, avoidorforgetloop*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *avoidorforgetloop*  
    **agentfreedom** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of possible directions the ant can take (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: C  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **pheromoneweight** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the pheromone value (P) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: A  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **randomnessweight** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the random value (R) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: ^  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **costweight** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the penalty value (C) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: ]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *s*, *c*, *a*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow overwriting existing pheromone maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Produce a sequence of pheromone maps (by appending a number)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrite existing cost map (only used with penalty conversion)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Auto-convert cost (slope..) to penalty map (using "tobler", see docu)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Avoid loops on the way back  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **outputmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of pheromone output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **inputmap** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input pheromone raster map (e.g. from prior run)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **costmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of penalty resp. cost raster map (note conversion checkbox)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **sitesmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sites map, vector data with possible points of origin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector  
    **rounds** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of iterations/rounds to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Pݠ  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *999*  
    **outrounds** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Produce output after running this number of iterations/rounds  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Pݠ  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    **targetvisibility** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance to target from where it might be 'sensed'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Pݠ  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    **highcostlimit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Penalty values above this point an ant considers as illegal/bogus when in 'costlymarked' modus  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: X  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **lowcostlimit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Penalty values below this point an ant considers as illegal/bogus when in 'costlymarked' modus  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: H  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99999-99999*  
    **maxpheromone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Absolute maximum of pheromone intensity a position may have  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: @  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *<minpheromone>-<max integer on system would make sense>*  
    **minpheromone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Absolute minimum of pheromone intensity to leave on playground  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: D  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<maxpheromone>*  
    **volatilizationtime** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Half-life for pheromone to volatize (e.g. =rounds)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: \  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **stepintensity** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pheromone intensity to leave on each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: U  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **pathintensity** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pheromone intensity to leave on found paths  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: E  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **maxants** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum amount of ants that may live concurrently (x\*y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: T  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<the bigger the playground,  the more space they have>*  
    **antslife** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time to live for an ant (e.g. four times points distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: B  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **decisionalgorithm** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm used for walking step  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *standard, marked, costlymarked, random, test*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *standard*  
    **evaluateposition** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm used for finding and remembering paths  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as:   
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *standard, avoidloop, forgetloop, avoidorforgetloop*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *avoidorforgetloop*  
    **agentfreedom** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of possible directions the ant can take (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: C  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **pheromoneweight** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the pheromone value (P) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: A  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **randomnessweight** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the random value (R) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: ^  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **costweight** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;How is the penalty value (C) weighted when walking (p\*P:r\*R:c\*C)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: ]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-99999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *s*, *c*, *a*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow overwriting existing pheromone maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Produce a sequence of pheromone maps (by appending a number)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrite existing cost map (only used with penalty conversion)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Auto-convert cost (slope..) to penalty map (using "tobler", see docu)  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Avoid loops on the way back  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

As a first real example of a world there is an ACO-based environment
(see [Ant Colony
Optimization](https://en.wikipedia.org/wiki/Ant_colony_optimization_algorithms))
available.

The basic concept of such an ACO world, is to take some cost surface and
transform it to a penalty layer. Even if the algorithm comes from the
realm of insects, it might be adapted to different animal kingdoms.
Depending on the type of agent this penalty layer must be reinterpreted:
if for example, we want to talk about human agents the penalty layer may
be expressed by the walking velocity, e.g. calculated with the algorithm
proposed by
[Tobler1993](https://web.archive.org/web/20220523095740/http://www.geodyssey.com/papers/tobler93.html).
The actors on the playground will wander around on the playground using
the time for their paths that correspond with the values in the penalty
grid. If they find some attractor, they walk home to the position they
originated, marking their way with pheromones. While this pheromone
vanishes over time, the following agents are more likely to choose their
next steps to a position that smells most.

This first toolset was mainly developed for [Topoi Project
A-III-4](https://www.topoi.org/group/a-iii-4-topoi-1/), with some
inspirations from previous work conducted at the [Uni
Bern](https://www.unibe.ch/) in 2008.

## NOTES

The state of this software is: "first do it".

ACO works best on dynamic maps -- it constantly tries to improve
paths...

## EXAMPLE

A fictive use case could look something like this (note: at the moment
the in- and output variables with *libold*, are still ascii-files):

```sh
r.agent.aco outputmap=out.map penaltymap=testpenalty.grid \
  sitesmap=sites.vect rounds=100 outrounds=100 volatilizationtime=5000 \
  antslife=2000 maxants=400 pathintensity=1000000
```

For running the total test suite on the libraries, i.e. to run all the
tests that are at the end of each python file, use this test collection
(for certain tests, the following files must exist though: "elev.grid",
and "arch.vect"):

```sh
user@host:~$ cd /<pathtoaddons>/r.agent/libagent

user@host:libold$ ./alltests.py
```

## TODO

Integrate it directly within grass.

Improve encapsulation of classes.

Find good parameters, or parameter finding strategies for the ACO part.
Try to avoid high penalty fields. Think about heuristics too.

Implement other ABM scenarios.

## SEE ALSO

## AUTHOR

Michael Lustenberger inofix.ch

## SOURCE CODE

Available at: [r.agent.aco source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.agent/r.agent.aco)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.agent/r.agent.aco))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
