---
name: r.bearing.distance
description: Find the bearing and/or straight-line distance from all non-null cells to the specified point.
keywords: [ raster, azimuth, direction, bearing ]
---

# r.bearing.distance

Find the bearing and/or straight-line distance from all non-null cells to the specified point.

=== "Command line"

    **r.bearing.distance**
    [**-rabse**]
    **input**=*name*
    **coordinate**=*x,y*
    [**reference_bearing**=*double*]
    [**bearing**=*string*]
    [**distance**=*string*]
    [**segment**=*string*]
    [**csv_seg**=*string*]
    [**csv_ax**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.bearing.distance input=name coordinate=x,y
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.bearing.distance***",
        **input**,
        **coordinate**,
        **reference_bearing**=*None*,
        **bearing**=*None*,
        **distance**=*None*,
        **segment**=*None*,
        **csv_seg**=*None*,
        **csv_ax**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.bearing.distance", input="name", coordinate="x,y")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_bearing_distance*(**input**,
        **coordinate**,
        **reference_bearing**=*None*,
        **bearing**=*None*,
        **distance**=*None*,
        **segment**=*None*,
        **csv_seg**=*None*,
        **csv_ax**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_bearing_distance(input="name", coordinate="x,y")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing non-null cells for which bearing is to be computed  
    **coordinate**=*x,y* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate identifying the point location  
    **reference_bearing**=*double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bearing in degrees from N (for calculation of bearing difference map)  
    **bearing**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the bearing  
    **distance**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the distance  
    **segment**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the segment  
    **csv_seg**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output plain text  CSV file for segment counts  
    **csv_ax**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output plain text CSV file for axial difference counts  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse bearing (i.e. bearing towards point location)   
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bearing difference is axial (0 - 90 degrees) rather than clockwise)   
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bearing difference is axial and signed (0 - +/-90 degrees) rather than clockwise)   
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Segments are clockwise from zero rather than centred on zero   
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Compute eight segments rather than four   
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing non-null cells for which bearing is to be computed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinate** : tuple[str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate identifying the point location  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **reference_bearing** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bearing in degrees from N (for calculation of bearing difference map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    **bearing** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the bearing  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **distance** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **segment** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **csv_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output plain text  CSV file for segment counts  
    **csv_ax** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output plain text CSV file for axial difference counts  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *a*, *b*, *s*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse bearing (i.e. bearing towards point location)   
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bearing difference is axial (0 - 90 degrees) rather than clockwise)   
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bearing difference is axial and signed (0 - +/-90 degrees) rather than clockwise)   
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Segments are clockwise from zero rather than centred on zero   
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute eight segments rather than four   
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing non-null cells for which bearing is to be computed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinate** : tuple[str, str] | list[str] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate identifying the point location  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **reference_bearing** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bearing in degrees from N (for calculation of bearing difference map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *double*  
    **bearing** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the bearing  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **distance** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **segment** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map name for storing the segment  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **csv_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output plain text  CSV file for segment counts  
    **csv_ax** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output plain text CSV file for axial difference counts  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *a*, *b*, *s*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse bearing (i.e. bearing towards point location)   
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bearing difference is axial (0 - 90 degrees) rather than clockwise)   
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bearing difference is axial and signed (0 - +/-90 degrees) rather than clockwise)   
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Segments are clockwise from zero rather than centred on zero   
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute eight segments rather than four   
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.bearing.distance* computes the bearing and/or straight-line distance
from a point location to all non-NULL cells in a raster map. Optionally,
the bearing returned in each non-NULL cell may be:

- the actual bearing measured from the point location;
- the difference between that bearing and a reference bearing;
- one of two measures of the extent to which the bearing is or is not
    orthogonal to the reference bearing.

By default, the **bearing** map records the bearing of a straight line
projected from the point location to each non-NULL cell in the input
map. If the **-r** flag is set then this map records the reverse
bearing, i.e. that of a straight line projected from each non-NULL cell
towards the point location. The point location itself is coded NULL,
irrespective of whether it was NULL or non-NULL in the input map.

If a **reference\_bearing** is specified without the **-a** or **-b**
flags then the bearing map will by default record the bearing relative
to the reference bearing. This relative bearing is the clockwise
difference between the reference bearing and the bearing that would
otherwise have been recorded. For example: if the bearing is 315 degrees
and the reference bearing 270 degrees, the relative bearing would be +45
degrees; if the bearing is 45 degrees and the reference bearing 270
degrees, the relative bearing would be +135 degrees.

If a **reference\_bearing** is specified along with the **-a** flag then
the bearing map will record the bearing relative to an axis defined by
the reference bearing, such that if the bearing is aligned (or 180
degrees opposite) the reference bearing the difference will be zero
degrees, and if it is orthogonal the difference will be +90 degrees.

If a **reference\_bearing** is specified along with the **-b** flag then
the bearing map will record the signed bearing relative to an axis
defined by the reference bearing, such that if the bearing is aligned
(or 180 degrees opposite) the reference bearing the difference will be
zero degrees, if it is orthogonal in a clockwise direction the
difference will be +90 degrees, and if it is orthogonal in an
anticlockwise direction the difference will be -90 degrees.

The **distance** map records the straight-line distance from the point
location to each non-NULL cell in the input map. The distance is
computed using the geographic coordinates of the point location and the
geographic coordinates of the centre of each non-NULL map cell.

The **segment** map records which azimuthal segment the bearing (or
relative bearing) falls in. The **-e** flag determines whether 4 or 8
segments are returned. The **-s** flag determines whether segments are
centred on a bearing (or relative bearing) of zero degrees, or start
clockwise from zero degrees.

The **csv\_seg** file is a plain text CSV file which records the count
and percentage of cells falling in each of the segments.

The **csv\_ax** file is only available if an axial relative bearing has
been requested by setting the **-a** or **-b** flags. In the case of an
axial relative bearing (**-a**) this plain text CSV file records the
count of cells whose relative bearing (θ) falls in each of 5 ranges: θ =
0; 0 \< θ ≤ 22.5; 22.5 \< θ ≤ 45; 45 \< θ ≤ 67.5; 67.5 \< θ ≤ 90. It
also records the mean value of θ. In the case of a signed axial relative
bearing (**-b**) this file distinguishes positive and negative values of
θ. It also records separate means and standard deviations of the
positive and negative values of θ in addition to an overall mean and
standard deviation.

## NOTES

This module was originally written for an archaeological investigation
of the orientation of viewsheds from prehistoric burial mounds, but it
will be useful for visibility analysis in a range of academic
disciplines, as well as planning and environmental management. Indeed,
it potentially has applications for any kind of analysis which involves
a set of non-NULL cells that are somehow related to a point location.

In the case of visibility analysis, the **-r** flag will be particularly
useful when a viewshed has been produced with observer and target
offsets set so as to compute the visibility from each cell back towards
the point location set as the 'viewpoint'. With the **-r** flag the
bearing returned will similarly be that from each cell in the viewshed
back towards the point location of interest.

The code does not currently deal with Lat/Long databases.

The module only runs when the current region has integer resolution
(since the algorithm is not robust in cases where resolution is
non-integer). The code might work satisfactorily when the map resolution
in non-integer, but this has not been rigorously checked.

## REFERENCES

- Harris, B. and Lake, M. (in prep.) The influence of visibility on
    the territorial packing of Neolithic long barrows in central
    southern England. For submission to *Journal of Archaeological
    Method and Theory*.

## SEE ALSO

*[r.viewshed](https://grass.osgeo.org/grass-stable/manuals/r.viewshed.html)*

## AUTHOR

Mark Lake, UCL Institute of Archaeology, University College London, UK.
(the author).

## ACKNOWLEDGEMENTS

Functionality developed in consultation with Barney Harris, UCL
Institute of Archaeology, University College London, UK.

## SOURCE CODE

Available at: [r.bearing.distance source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.bearing.distance)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.bearing.distance))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
