---
name: r.category
description: Manages category values and labels associated with user-specified raster map layers.
keywords: [ raster, category ]
---

# r.category

Manages category values and labels associated with user-specified raster map layers.

=== "Command line"

    **r.category**
    **map**=*name*
    [**cats**=*range* [,*range*,...]]
    [**values**=*float* [,*float*,...]]
    [**separator**=*character*]
    [**raster**=*name*]
    [**rules**=*name*]
    [**format**=*string*]
    [**label_format**=*string*]
    [**coefficients**=*mult1,offset1,mult2,offset2*]
    [**color_format**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.category map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.category***",
        **map**,
        **cats**=*None*,
        **values**=*None*,
        **separator**=*"tab"*,
        **raster**=*None*,
        **rules**=*None*,
        **format**=*None*,
        **label_format**=*None*,
        **coefficients**=*None*,
        **color_format**=*"none"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.category", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_category*(**map**,
        **cats**=*None*,
        **values**=*None*,
        **separator**=*"tab"*,
        **raster**=*None*,
        **rules**=*None*,
        **format**=*None*,
        **label_format**=*None*,
        **coefficients**=*None*,
        **color_format**=*"none"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_category(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **cats**=*range* [,*range*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **values**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated value list  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1.4,3.8,13  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tab*  
    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing category label rules (or "-" to read from stdin)  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format ('plain', 'json')  
    &nbsp;&nbsp;&nbsp;&nbsp;When the value is not 'plain' or 'json', the value is used as a default label or format string for dynamic labeling. This usage is deprecated and will be removed in a future release. Use parameter 'label_format' instead.  
    **label_format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default label or format string for dynamic labeling  
    &nbsp;&nbsp;&nbsp;&nbsp;Used when no explicit label exists for the category  
    **coefficients**=*mult1,offset1,mult2,offset2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dynamic label coefficients  
    &nbsp;&nbsp;&nbsp;&nbsp;Two pairs of category multiplier and offsets, for $1 and $2  
    **color_format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values or none.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, rgb, hex, triplet, hsv*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cats** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **values** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated value list  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1.4,3.8,13  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tab*  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing category label rules (or "-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format ('plain', 'json')  
    &nbsp;&nbsp;&nbsp;&nbsp;When the value is not 'plain' or 'json', the value is used as a default label or format string for dynamic labeling. This usage is deprecated and will be removed in a future release. Use parameter 'label_format' instead.  
    **label_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default label or format string for dynamic labeling  
    &nbsp;&nbsp;&nbsp;&nbsp;Used when no explicit label exists for the category  
    **coefficients** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dynamic label coefficients  
    &nbsp;&nbsp;&nbsp;&nbsp;Two pairs of category multiplier and offsets, for $1 and $2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *mult1,offset1,mult2,offset2*  
    **color_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values or none.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, rgb, hex, triplet, hsv*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cats** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **values** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated value list  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1.4,3.8,13  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tab*  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing category label rules (or "-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format ('plain', 'json')  
    &nbsp;&nbsp;&nbsp;&nbsp;When the value is not 'plain' or 'json', the value is used as a default label or format string for dynamic labeling. This usage is deprecated and will be removed in a future release. Use parameter 'label_format' instead.  
    **label_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default label or format string for dynamic labeling  
    &nbsp;&nbsp;&nbsp;&nbsp;Used when no explicit label exists for the category  
    **coefficients** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dynamic label coefficients  
    &nbsp;&nbsp;&nbsp;&nbsp;Two pairs of category multiplier and offsets, for $1 and $2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *mult1,offset1,mult2,offset2*  
    **color_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values or none.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, rgb, hex, triplet, hsv*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.category* prints the category values and labels for the raster map
layer specified by **map**=*name* to standard output. You can also use
it to set category labels for a raster map.

The user can specify all needed parameters on the command line, and run
the program non-interactively. If the user does not specify any
categories (e.g., using the optional **cats**=*range*\[,*range*,...\]
argument), then all the category values and labels for the named raster
map layer that occur in the map are printed. The entire *map* is read
using *[r.describe](r.describe.md)*, to determine which categories occur
in the *map*. If a listing of categories is specified, then the labels
for those categories only are printed. The *cats* may be specified as
single category values, or as ranges of values. The user may also
(optionally) specify that a field separator other than a space or tab be
used to separate the category value from its corresponding category
label in the output, by using the
**separator**=*character*\|*space*\|*tab* option (see example below). If
no field separator is specified by the user, a tab is used to separate
these fields in the output, by default.

The output is sent to standard output in the form of one category per
line, with the category value first on the line, then an ASCII TAB
character (or whatever single character or space is specified using the
**separator** parameter), then the label for the category.

## NOTES

Any ASCII TAB characters which may be in the label are replaced by
spaces.

The output from *r.category* can be redirected into a file, or piped
into another program.

### Input from a file

The **rules** option allows the user to assign category labels from
values found in a file (without header). The label can refer to a single
category, range of categories, floating point value, or a range of
floating point values. The format is given as follows (when separator is
set to colon; no white space must be used after the separator):

```sh
cat:Label
val1:val2:Label
```

If the filename is given as "-", the category labels are read from
`stdin`

### Default and dynamic category labels

Default and dynamic category labels can be created for categories that
are not explicitly labeled. The coefficient line can be followed by
explicit category labels which override the format label generation.

```sh
   0:no data
   2:   .
   5:   .             ## explicit category labels
   7:   .
```

explicit labels can be also of the form:

```sh
   5.5:5:9 label description
   or
   15:30  label description
```

In the format line

- `$1` refers to the value `num*5.0+1000` (ie, using the first 2
  coefficients)
- `$2` refers to the value `num*5.0+1005` (ie, using the last 2
  coefficients)

`$1.2` will print `$1` with 2 decimal places.

Also, the form `$?xxx$yyy$` translates into `yyy` if the category is 1,
xxx otherwise. The `$yyy$` is optional. Thus

`$1 meter$?s`

will become:  
`1 meter` (for category 1)  
`2 meters` (for category 2), etc.

`label_format='Elevation: $1.2 to $2.2 feet' ## Format Statement`  
`coefficients="5.0,1000,5.0,1005" ## Coefficients`

The format and coefficients above would be used to generate the
following statement in creation of the format appropriate category
string for category "num":

`sprintf(buff,"Elevation: %.2f to %.2f feet", num*5.0+1000, num*5.0*1005)`

Note: while both the format and coefficient lines must be present a
blank line for the format string will effectively suppress automatic
label generation.

To use a "`$`" in the label without triggering the plural test, put
"`$$`" in the format string.

Use 'single quotes' when using a "`$`" on the command line to avoid
unwanted shell substitution.

## EXAMPLES

North Carolina sample dataset:

### Printing categories

```sh
r.category map=landclass96
1   developed
2   agriculture
3   herbaceous
4   shrubland
5   forest
6   water
7   sediment
```

prints the values and labels associated with all of the categories in
the *landclass96* raster map layer.

```sh
r.category map=landclass96 cats=2,5-7
2   agriculture
5   forest
6   water
7   sediment
```

prints only the category values and labels for *landclass96* map layer
categories `2` and `5` through `7`.

```sh
r.category map=landclass96 cats=3,4 separator=comma
3,herbaceous
4,shrubland
```

prints the values and labels for *landclass96* map layer categories `3`
and `4`, but uses "`,`" (instead of a tab) as the character separating
the category values from the category values in the output.

```sh
r.category map=landclass96 cats=3,4 format=json
```

generates the following JSON output:

```json
[
    {
        "category": 3,
        "label": "herbaceous"
    },
    {
        "category": 4,
        "label": "shrubland"
    }
]
```

### Adding categories

Example for defining new category labels, using a colon as separator:

```sh
r.category diseasemap separator=":" rules=- << EOF
1:potential absence
2:potential presence
EOF
```

This sets the category values 1 and 2 to respective text labels.
Alternatively, the rules can be stored in an ASCII text file and loaded
via the *rules* parameter.

## SEE ALSO

UNIX Manual entries for *awk* and *sort*

*[d.what.rast](d.what.rast.md), [r.coin](r.coin.md),
[r.describe](r.describe.md), [r.support](r.support.md)*

## AUTHORS

Michael Shapiro, U.S. Army Construction Engineering Research
Laboratory  
Hamish Bowman, University of Otago, New Zealand (label creation options)

## SOURCE CODE

Available at: [r.category source code](https://github.com/OSGeo/grass/tree/main/raster/r.category)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.category))  
Latest change: Saturday Oct 11 04:38:40 2025 in commit [3dd71f5](https://github.com/OSGeo/grass/commit/3dd71f5fab83b72a2db2da959fe075c5b3b52200)
