---
name: r.cell.area.py
description: Calculate cell sizes within the computational region
keywords: [ raster, statistics ]
---

# r.cell.area.py

Calculate cell sizes within the computational region

=== "Command line"

    **r.cell.area.py**
    **output**=*name*
    **units**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.cell.area.py output=name units=m2
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.cell.area.py***",
        **output**,
        **units**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.cell.area.py", output="name", units="m2")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_cell_area_py*(**output**,
        **units**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_cell_area_py(output="name", units="m2")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output grid of cell sizes  
    **units**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for output areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m2,  km2*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output grid of cell sizes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **units** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for output areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m2,  km2*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output grid of cell sizes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **units** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for output areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m2,  km2*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.cell.area* uses the current computational region to compute the area
of each raster cell. It can do so on a projected coordinate system or on
a geographic coordinate system; the latter is accomplished via the
latitude of the cell's midpoint. This approximation can generate \~1%
error with coarse lat/lon cells near the poles.

## NOTES

Output units can be either square meters or square kilometers. This
module is useful for determining the flow accumulation area to weight
flow accumulation algorithms by rainfall and/or on lat/lon grids.

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html)*

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [r.cell.area source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.cell.area)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.cell.area))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
