---
name: r.crater
description: Creates meteorites from craters (-c) or craters from meteorites (default).
keywords: [ raster, planetary, impact, meteorite, crater ]
---

# r.crater

Creates meteorites from craters (-c) or craters from meteorites (default).

=== "Command line"

    **r.crater**
    [**-ctgy**]
    **impactor_velocity**=*name*
    **impactor_angle**=*name*
    **target_density**=*name*
    **gravity_acceleration**=*name*
    **target_type**=*name*
    **impactor_density**=*name*
    [**projectile_diameter**=*name*]
    [**transient_crater_diameter**=*name*]
    [**final_crater_diameter**=*name*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.crater impactor_velocity=name impactor_angle=name target_density=name gravity_acceleration=name target_type=name impactor_density=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.crater***",
        **impactor_velocity**,
        **impactor_angle**,
        **target_density**,
        **gravity_acceleration**,
        **target_type**,
        **impactor_density**,
        **projectile_diameter**=*None*,
        **transient_crater_diameter**=*None*,
        **final_crater_diameter**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.crater", impactor_velocity="name", impactor_angle="name", target_density="name", gravity_acceleration="name", target_type="name", impactor_density="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_crater*(**impactor_velocity**,
        **impactor_angle**,
        **target_density**,
        **gravity_acceleration**,
        **target_type**,
        **impactor_density**,
        **projectile_diameter**=*None*,
        **transient_crater_diameter**=*None*,
        **final_crater_diameter**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_crater(impactor_velocity="name", impactor_angle="name", target_density="name", gravity_acceleration="name", target_type="name", impactor_density="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **impactor_velocity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor velocity raster map [km/s]  
    **impactor_angle**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor angle raster map [dd.ddd]  
    **target_density**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target density raster map [kg/m^3]  
    **gravity_acceleration**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of gravity acceleration raster map [m/s^-2]  
    **target_type**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target type raster map [1=liq.H2O, 2=Loose Sand, 3=Competent Rock/Saturated Soil]  
    **impactor_density**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor density raster map [kg/m^3]  
    **projectile_diameter**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flag -c: Name of projectile diameter raster map [m]  
    **transient_crater_diameter**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default mode: Name of transient crater diameter raster map [m]  
    **final_crater_diameter**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default mode: Name of final crater diameter raster map [m]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for projectile size (default) or crater size (-c) or crater creation time (-t) raster map [m] or [s]  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Estimate crater diameter from projectile size [m]  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;output the time of crater formation for Pi scaling [s]  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;use the Gault instead of default Pi scaling  
    **-y**  
    &nbsp;&nbsp;&nbsp;&nbsp;use the Yield instead of default Pi scaling  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **impactor_velocity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor velocity raster map [km/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **impactor_angle** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor angle raster map [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **target_density** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target density raster map [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **gravity_acceleration** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of gravity acceleration raster map [m/s^-2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **target_type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target type raster map [1=liq.H2O, 2=Loose Sand, 3=Competent Rock/Saturated Soil]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **impactor_density** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor density raster map [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **projectile_diameter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flag -c: Name of projectile diameter raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transient_crater_diameter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default mode: Name of transient crater diameter raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **final_crater_diameter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default mode: Name of final crater diameter raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for projectile size (default) or crater size (-c) or crater creation time (-t) raster map [m] or [s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *t*, *g*, *y*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate crater diameter from projectile size [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output the time of crater formation for Pi scaling [s]  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;use the Gault instead of default Pi scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;use the Yield instead of default Pi scaling  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **impactor_velocity** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor velocity raster map [km/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **impactor_angle** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor angle raster map [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **target_density** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target density raster map [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **gravity_acceleration** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of gravity acceleration raster map [m/s^-2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **target_type** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target type raster map [1=liq.H2O, 2=Loose Sand, 3=Competent Rock/Saturated Soil]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **impactor_density** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of impactor density raster map [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **projectile_diameter** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flag -c: Name of projectile diameter raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transient_crater_diameter** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default mode: Name of transient crater diameter raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **final_crater_diameter** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default mode: Name of final crater diameter raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for projectile size (default) or crater size (-c) or crater creation time (-t) raster map [m] or [s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *t*, *g*, *y*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate crater diameter from projectile size [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output the time of crater formation for Pi scaling [s]  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;use the Gault instead of default Pi scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;use the Yield instead of default Pi scaling  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.crater* This program estimates the size of a gravity dominated impact
crater or the projectile that made it.

*Forward mode* This mode needs to know the projectile details  
L: projectile diameter (m)  
r\_proj: projectile density (kg/m^3)  
Vi: Projectile velocity (km/s)  
theta: projectile impact angle (degrees) for Gault scaling law (flag2)  
Solid\_rock or not (1 or 0) for Gault scaling law (flag2)  

*Backward mode* This mode needs to know the crater details  

## NOTES

Gault scaling law saturates at craters 1000 Diameter Apparent Transient,
and was essentially designed for regolith (Moon surface).

Below is explanation from the Meloch Fortran code (not included because
of copyright)

Three different estimates are presented, but the pi-scaling method is
currently considered the best\!

Impact conditions: argv\[1\]: enter the impact velocity in km/sec
argv\[2\]: enter the impact angle in degrees

Target descriptors: argv\[3\]: enter the target density in kg/m^3
argv\[4\]: enter the acceleration of gravity in m/sec^2

argv\[5\]: enter the target type, (1-3): type 1 = liquid water type 2 =
loose sand type 3 = competent rock or saturated soil argv\[6\]: enter
the projectile density in kg/m^3

argv\[7\]: enter the type of computation desired (1 or 2): Mode 1,
crater size Mode 2, projectile size

Mode 1: Estimate crater diameter from projectile size Mode 1 case:
Projectile descriptors: argv\[8\]: enter the projectile diameter in m

Mode 2: Estimate crater size from crater diameter\*/ Mode 2 case: Crater
descriptor: argv\[8\]: enter the transient crater diameter in m (if the
final, not the transient crater diameter is known, enter zero (0.0)
here) argv\[9\]: \[optional\] enter the final crater diameter in m

## SEE ALSO

*[r.drain](https://grass.osgeo.org/grass-stable/manuals/r.drain.html),
[r.out.ascii](https://grass.osgeo.org/grass-stable/manuals/r.out.ascii.html)*

## AUTHOR

Yann Chemin

## SOURCE CODE

Available at: [r.crater source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.crater)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.crater))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
