---
name: r.curvenumber
description: Generates curve number raster from landcover and hydrologic soil group Implements scs curve number lookup based on landcover, hydrologic soil group, hydrologic condition, and antecedent runoff
keywords: [ raster, hydrology, curve number ]
---

# r.curvenumber

Generates curve number raster from landcover and hydrologic soil group

Implements scs curve number lookup based on landcover, hydrologic soil group, hydrologic condition, and antecedent runoff

=== "Command line"

    **r.curvenumber**
    **landcover**=*name*
    **soil**=*name*
    **landcover_source**=*string*
    [**lookup**=*string*]
    [**hydrologic_condition**=*string*]
    [**antecedent_runoff_condition**=*string*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.curvenumber landcover=name soil=name landcover_source=nlcd output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.curvenumber***",
        **landcover**,
        **soil**,
        **landcover_source**,
        **lookup**=*None*,
        **hydrologic_condition**=*"fair"*,
        **antecedent_runoff_condition**=*"ii"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.curvenumber", landcover="name", soil="name", landcover_source="nlcd", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_curvenumber*(**landcover**,
        **soil**,
        **landcover_source**,
        **lookup**=*None*,
        **hydrologic_condition**=*"fair"*,
        **antecedent_runoff_condition**=*"ii"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_curvenumber(landcover="name", soil="name", landcover_source="nlcd", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **landcover**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input landcover raster  
    **soil**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input hydrologic soil group raster  
    **landcover_source**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Lookup table source  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nlcd, esa, custom*  
    **lookup**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to custom lookup csv (used when landcover_source=custom)  
    **hydrologic_condition**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hydrologic Condition (groundcover density affecting runoff potential)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *poor, fair, good*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fair*  
    **antecedent_runoff_condition**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Antecedent Runoff Condition (the degree of wetness of a watershed before a rainfall event)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i, ii, iii*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ii*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output curve number raster  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **landcover** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input landcover raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soil** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input hydrologic soil group raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **landcover_source** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lookup table source  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nlcd, esa, custom*  
    **lookup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to custom lookup csv (used when landcover_source=custom)  
    **hydrologic_condition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hydrologic Condition (groundcover density affecting runoff potential)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *poor, fair, good*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fair*  
    **antecedent_runoff_condition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Antecedent Runoff Condition (the degree of wetness of a watershed before a rainfall event)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i, ii, iii*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ii*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output curve number raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **landcover** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input landcover raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soil** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input hydrologic soil group raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **landcover_source** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lookup table source  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nlcd, esa, custom*  
    **lookup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to custom lookup csv (used when landcover_source=custom)  
    **hydrologic_condition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hydrologic Condition (groundcover density affecting runoff potential)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *poor, fair, good*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fair*  
    **antecedent_runoff_condition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Antecedent Runoff Condition (the degree of wetness of a watershed before a rainfall event)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i, ii, iii*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ii*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output curve number raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Generates a Curve Number (CN) raster using
landcover and hydrologic soil group (HSG) rasters,
along with user-specified hydrologic condition
and antecedent runoff condition.

### Landcover Source

Select the source of the landcover
classification and corresponding lookup table:

- nlcd: Built-in NLCD lookup
- esa: Built-in ESA WorldCover 2021 lookup
- custom: Custom lookup table provided as a CSV file

For custom, the CSV must include the following columns:  
`lc,hsg,hc,cn`

### Hydrologic Soil Groups (HSG)

The HSG raster must contain only:

- 1 – Group A: High infiltration, low runoff
- 2 – Group B: Moderate infiltration
- 3 – Group C: Low infiltration
- 4 – Group D: Very low infiltration, high runoff
- 11–14 – Dual groups: A/D, B/D, C/D, D/D (for drained/undrained soils)

Curve Number increases from HSG A to D
due to reduced infiltration associated
with increasing clay content and compaction.

If you are using SSURGO soil data,
Hydrologic Soil Group (HSG) values are
typically provided directly. For other
soil datasets that do not include HSG
classifications, see Reference 1 (Chapter 7)
for guidance on assigning HSGs based on soil texture,
hydraulic conductivity, and water table depth.
This information can be used to develop a custom HSG raster.

### Hydrologic Condition (HC)

Hydrologic condition reflects the percentage of
surface groundcover and affects runoff potential.
Generally:

- poor: Less than 30% cover — compacted or bare
- fair: 30–70% cover — partial vegetation (default)
- good: More than 70% cover — dense and healthy vegetation

Curve Number decreases from poor to good due to
improved infiltration with more vegetation.  
See Reference 2 for further discussion.

Note: Curve Number for Cropland for fair condition
is provided as the average of Curve Number of poor
and good hydrologic conditions.

### Antecedent Runoff Condition (ARC)

The variability in Curve Number (CN) arises
from factors such as rainfall intensity and duration,
total precipitation, soil moisture conditions,
vegetative cover density, growth stage, and
temperature. These factors collectively define
the Antecedent Runoff Condition (ARC),
which is classified into three categories:

- ARC I – Dry conditions (low antecedent moisture)
- ARC II – Average conditions (typical or normal moisture, default)
- ARC III – Wet conditions (high antecedent moisture)

Curve Number increases from ARC I to ARC III as runoff potential rises.

A standard conversion table is used
within the script to adjust CN values
from ARC II to ARC I or ARC III, based on
empirical relationships. This corresponds to
Table 10-1 in Reference 3.

### Sensitivity and CN Hierarchy

The CN is more sensitive to ARC than to HC.  
Typical curve number values for a soil-cover complex follow this order:

`p_iii > f_iii > g_iii > p_ii > f_ii > g_ii > p_i > f_i > g_i`

Where:

- `p`, `f`, `g` denote **poor**, **fair**, and **good** hydrologic conditions
- `i`, `ii`, `iii` denote **dry**, **average**, and **wet** antecedent runoff conditions

## EXAMPLES

```sh
# Example 1: NLCD lookup (built-in)
r.curvenumber \
  landcover=nlcd \
  hsg=soil_hsg \
  landcover_source=nlcd \
  h_c=poor \
  arc=iii \
  output=cn_nlcd

# Example 2: ESA WorldCover lookup (built-in)
r.curvenumber \
  landcover=esa \
  hsg=soil_hsg \
  landcover_source=esa \
  h_c=fair \
  arc=ii \
  output=cn_esa

# Example 3: Custom CSV lookup
r.curvenumber \
  landcover=custom_lc_map \
  soil=custom_hsg_map \
  landcover_source=custom \
  lookup=cn_table.csv \
  output=cn_custom
```

![r.curvenumber example](r_curvenumber_output.png)
*Figure: Example output from r.curvenumber*

## REFERENCES

1. United States Department of Agriculture,
   Natural Resources Conservation Service. (2009).
   *National Engineering Handbook, Part 630 Hydrology:
   Chapter 7 – Hydrologic Soil Groups* (210-VI-NEH)

2. United States Department of Agriculture,
   Natural Resources Conservation Service. (2004).
   *National Engineering Handbook, Part 630 Hydrology:
   Chapter 9 – Hydrologic Soil-Cover Complexes* (210-VI-NEH)

3. United States Department of Agriculture,
   Natural Resources Conservation Service. (2004).
   *National Engineering Handbook, Part 630 Hydrology:
   Chapter 10 – Estimation of Direct Runoff from Storm Rainfall* (210-VI-NEH)

## SEE ALSO

[r.timeofconcentration](https://grass.osgeo.org/grass-stable/manuals/addons/r.timeofconcentration.html),
[r.runoff](https://grass.osgeo.org/grass-stable/manuals/addons/r.runoff.html)

## AUTHORS

[Abdullah Azzam](mailto:mabdazzam@outlook.com)
([CLAWRIM](https://clawrim.isnew.info/), Department of Civil and Environmental
Engineering, New Mexico State University)

## SOURCE CODE

Available at: [r.curvenumber source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.curvenumber)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.curvenumber))  
Latest change: Thursday Dec 04 07:45:25 2025 in commit [439c57c](https://github.com/OSGeo/grass-addons/commit/439c57c55b8d693bb1588ab5c1158ce5e50ecc8c)
