---
name: r.flexure.py
description: Computes lithospheric flexural isostasy
keywords: [ raster, geophysics ]
---

# r.flexure.py

Computes lithospheric flexural isostasy

=== "Command line"

    **r.flexure.py**
    [**-l**]
    **method**=*string*
    **input**=*name*
    **te**=*name*
    **te_units**=*string*
    **output**=*name*
    [**solver**=*string*]
    [**tolerance**=*float*]
    [**northbc**=*string*]
    [**southbc**=*string*]
    [**westbc**=*string*]
    [**eastbc**=*string*]
    [**g**=*float*]
    [**ym**=*float*]
    [**nu**=*float*]
    [**rho_fill**=*float*]
    [**rho_m**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.flexure.py method=FD input=name te=name te_units=m output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.flexure.py***",
        **method**,
        **input**,
        **te**,
        **te_units**,
        **output**,
        **solver**=*"direct"*,
        **tolerance**=*1E-3*,
        **northbc**=*"NoOutsideLoads"*,
        **southbc**=*"NoOutsideLoads"*,
        **westbc**=*"NoOutsideLoads"*,
        **eastbc**=*"NoOutsideLoads"*,
        **g**=*9.8*,
        **ym**=*65E9*,
        **nu**=*0.25*,
        **rho_fill**=*0*,
        **rho_m**=*3300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.flexure.py", method="FD", input="name", te="name", te_units="m", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_flexure_py*(**method**,
        **input**,
        **te**,
        **te_units**,
        **output**,
        **solver**=*"direct"*,
        **tolerance**=*1E-3*,
        **northbc**=*"NoOutsideLoads"*,
        **southbc**=*"NoOutsideLoads"*,
        **westbc**=*"NoOutsideLoads"*,
        **eastbc**=*"NoOutsideLoads"*,
        **g**=*9.8*,
        **ym**=*65E9*,
        **nu**=*0.25*,
        **rho_fill**=*0*,
        **rho_m**=*3300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_flexure_py(method="FD", input="name", te="name", te_units="m", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Solution method: Finite Diff. or Superpos. of analytical sol'ns  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FD,  SAS*  
    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of loads (thickness \* density \* g) [Pa]  
    **te**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Elastic thickness: scalar or raster; unis chosen in "te_units"  
    **te_units**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for elastic thickness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m,  km*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map of vertical deflections [m]  
    **solver**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solver type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *direct,  iterative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *direct*  
    **tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence tolerance (between iterations) for iterative solver  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1E-3*  
    **northbc**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **southbc**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Southern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **westbc**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Western boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **eastbc**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Eastern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **g**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;gravitational acceleration at surface [m/s^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9.8*  
    **ym**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Young's Modulus [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *65E9*  
    **nu**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Poisson's ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **rho_fill**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of material that fills flexural depressions [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **rho_m**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mantle density [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3300*  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allows running in lat/lon: dx is f(lat) at grid N-S midpoint  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solution method: Finite Diff. or Superpos. of analytical sol'ns  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FD,  SAS*  
    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of loads (thickness \* density \* g) [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **te** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elastic thickness: scalar or raster; unis chosen in "te_units"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **te_units** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for elastic thickness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m,  km*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map of vertical deflections [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **solver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solver type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *direct,  iterative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *direct*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence tolerance (between iterations) for iterative solver  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1E-3*  
    **northbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **southbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Southern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **westbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Western boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **eastbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Eastern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **g** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;gravitational acceleration at surface [m/s^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9.8*  
    **ym** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Young's Modulus [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *65E9*  
    **nu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Poisson's ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **rho_fill** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of material that fills flexural depressions [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **rho_m** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mantle density [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allows running in lat/lon: dx is f(lat) at grid N-S midpoint  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solution method: Finite Diff. or Superpos. of analytical sol'ns  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *FD,  SAS*  
    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of loads (thickness \* density \* g) [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **te** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elastic thickness: scalar or raster; unis chosen in "te_units"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **te_units** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units for elastic thickness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m,  km*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map of vertical deflections [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **solver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solver type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *direct,  iterative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *direct*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence tolerance (between iterations) for iterative solver  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1E-3*  
    **northbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **southbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Southern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **westbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Western boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **eastbc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Eastern boundary condition  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0Displacement0Slope,  0Moment0Shear,  0Slope0Shear,  Mirror,  Periodic,  NoOutsideLoads*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *NoOutsideLoads*  
    **g** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;gravitational acceleration at surface [m/s^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9.8*  
    **ym** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Young's Modulus [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *65E9*  
    **nu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Poisson's ratio  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **rho_fill** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Density of material that fills flexural depressions [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **rho_m** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mantle density [kg/m^3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allows running in lat/lon: dx is f(lat) at grid N-S midpoint  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.flexure* computes how the rigid outer shell of a planet deforms
elastically in response to surface-normal loads by solving equations for
plate bending. This phenomenon is known as "flexural isostasy" and can
be useful in cases of glacier/ice-cap/ice-sheet loading, sedimentary
basin filling, mountain belt growth, volcano emplacement, sea-level
change, and other geologic processes. *r.flexure* and
[v.flexure](v.flexure.md) are the GRASS GIS interfaces to the model
[**gFlex**](https://csdms.colorado.edu/wiki/Model:GFlex). As both
*r.flexure* and [v.flexure](v.flexure.md) are interfaces to gFlex, this
must be downloaded and installed. The most recent versions of **gFlex**
are available from <https://github.com/awickert/gFlex>, and installation
instructions are available on that page via the *README.md* file.

## NOTES

The parameter **method** sets whether the solution is Finite Difference
("FD") or Superposition of Analytical Solutions ("SAS"). The Finite
difference method is typically faster for large arrays, and allows
lithospheric elastic thickness to be varied laterally, following the
solution of van Wees and Cloetingh (1994). However, it is quite
memory-intensive, so unless the user has a computer with a very large
amount of memory and quite a lot of time to wait, they should ensure
that they use a grid spacing that is appropriate to solve the problem at
hand. Flexural isostatic solutions act to smooth inputs over a given
flexural wavelength (see , so if an appropriate solution resolution is
chosen, the calculated flexural response can be interpolated to a higher
resolution without fear of aliasing.

The flexural solution is generated for the current computational region,
so be sure to check *g.region* before running the model\!

**input** is a 2-D array of loads in a GRASS raster. These are in units
of stress, and equal the density of the material times the acceleration
due to gravity times the thickness of the column. This is not affected
by what you choose for **g**, later: it is pre-calculated by the user.

**te**, written in standard text as T<sub>e</sub>, is the lithospheric
elastic thickness.

Several boundary conditions are available, and these depend on if the
solution method is finite difference (FD) or superposition of analytical
solutions (SAS). In the latter, it is assumed that there are no loads
outside of those that are explicitly listed, so the boundary conditions
are "NoOutsideLoads". As this is the implicit case, the boundary
conditions all default to this.

The finite difference boundary conditions are a bit more complicated,
but are largely self-explanatory:

- **0Displacement0Slope**  
    0-displacement-0-slope boundary condition
- **0Moment0Shear**  
    "Broken plate" boundary condition: second and third derivatives of
    vertical displacement are 0. This is like the end of a diving board.
- **0Slope0Shear**  
    First and third derivatives of vertical displacement are zero. While
    this does not lend itself so easily to physical meaning, it is
    helpful to aid in efforts to make boundary condition effects
    disappear (i.e. to emulate the NoOutsideLoads cases)
- **Mirror**  
    Load and elastic thickness structures reflected at boundary.
- **Periodic**  
    "Wrap-around" boundary condition: must be applied to both North and
    South and/or both East and West. This causes, for example, the edge
    of the eastern and western limits of the domain to act like they are
    next to each other in an infinite loop.

All of these boundary conditions may be combined in any way, with the
exception of the note for periodic boundary conditions. If one does not
want the boundary conditions to affect the solutions, it is recommended
that one places the boundaries at least one flexural wavelength away
from the load.

*r.flexure* may be run in latitude/longitude coordinates (with the
"**-l**" flag), but its grid constraint is that it can have only one
*dx* and one *dy* for the entire domain. Thus, it chooses the average
*dx* at the midpoint between the northernmost and southernmost latitudes
for which the calculations are made. This assumption can break down at
the poles, where the East–West dimension rapidly diminishes.

The [Community Surface Dynamics Modeling
System](https://csdms.colorado.edu), into which **gFlex** is integrated,
is a community-driven effort to build an open-source modeling
infrastructure for Earth-surface processes.

## SEE ALSO

*[v.flexure](v.flexure.md)*

## REFERENCES

Wickert, A. D. (2015), Open-source modular solutions for flexural
isostasy: gFlex v1.0, *Geoscientific Model Development Discussions*,
*8*(6), 4245–4292, doi:10.5194/gmdd-8-4245-2015.

Wickert, A. D., G. E. Tucker, E. W. H. Hutton, B. Yan, and S. D. Peckham
(2011), [Feedbacks between surface processes and flexural isostasy: a
motivation for coupling
models](https://csdms.colorado.edu/csdms_wiki/images/Andrew_Wickert_CSDMS_2011_annual_meeting.pdf),
in *CSDMS 2011 Meeting: Impact of time and process scales*, Student
Keynote, Boulder, CO.

van Wees, J. D., and S. Cloetingh (1994), A Finite-Difference Technique
to Incorporate Spatial Variations In Rigidity and Planar Faults Into 3-D
Models For Lithospheric Flexure, *Geophysical Journal International*,
*117*(1), 179–195,
[doi:10.1111/j.1365-246X.1994.tb03311.x](https://doi.org/10.1111/j.1365-246X.1994.tb03311.x).

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [r.flexure source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.flexure)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.flexure))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
