---
name: r.futures.calib.py
description: Module for calibrating patch characteristics used as input to r.futures.pga
keywords: [ raster, patch ]
---

# r.futures.calib.py

Module for calibrating patch characteristics used as input to r.futures.pga

=== "Command line"

    **r.futures.calib.py**
    [**-sl**]
    **development_start**=*name*
    **development_end**=*name*
    [**repeat**=*integer*]
    [**compactness_mean**=*float* [,*float*,...]]
    [**compactness_range**=*float* [,*float*,...]]
    [**discount_factor**=*float* [,*float*,...]]
    **patch_threshold**=*float*
    **patch_sizes**=*name*
    [**calibration_results**=*name*]
    **nprocs**=*integer*
    [**random_seed**=*integer*]
    [**development_pressure**=*name*]
    [**incentive_power**=*float*]
    [**potential_weight**=*name*]
    [**predictors**=*name* [,*name*,...]]
    [**n_dev_neighbourhood**=*integer*]
    [**devpot_params**=*name* [,*name*,...]]
    [**num_neighbors**=*integer*]
    [**seed_search**=*string*]
    [**development_pressure_approach**=*string*]
    [**gamma**=*float*]
    [**scaling_factor**=*float*]
    [**num_steps**=*integer*]
    **subregions**=*name*
    [**subregions_potential**=*name*]
    [**demand**=*name*]
    [**memory**=*float*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.calib.py development_start=name development_end=name patch_threshold=0 patch_sizes=name nprocs=1 subregions=name demand=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.futures.calib.py***",
        **development_start**,
        **development_end**,
        **repeat**=*None*,
        **compactness_mean**=*None*,
        **compactness_range**=*None*,
        **discount_factor**=*None*,
        **patch_threshold**=*0*,
        **patch_sizes**,
        **calibration_results**=*None*,
        **nprocs**=*1*,
        **random_seed**=*1*,
        **development_pressure**=*None*,
        **incentive_power**=*None*,
        **potential_weight**=*None*,
        **predictors**=*None*,
        **n_dev_neighbourhood**=*None*,
        **devpot_params**=*None*,
        **num_neighbors**=*None*,
        **seed_search**=*None*,
        **development_pressure_approach**=*None*,
        **gamma**=*None*,
        **scaling_factor**=*None*,
        **num_steps**=*None*,
        **subregions**,
        **subregions_potential**=*None*,
        **demand**=*None*,
        **memory**=*None*,
        **separator**=*"comma"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.futures.calib.py", development_start="name", development_end="name", patch_threshold=0, patch_sizes="name", nprocs=1, subregions="name", demand="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_calib_py*(**development_start**,
        **development_end**,
        **repeat**=*None*,
        **compactness_mean**=*None*,
        **compactness_range**=*None*,
        **discount_factor**=*None*,
        **patch_threshold**=*0*,
        **patch_sizes**,
        **calibration_results**=*None*,
        **nprocs**=*1*,
        **random_seed**=*1*,
        **development_pressure**=*None*,
        **incentive_power**=*None*,
        **potential_weight**=*None*,
        **predictors**=*None*,
        **n_dev_neighbourhood**=*None*,
        **devpot_params**=*None*,
        **num_neighbors**=*None*,
        **seed_search**=*None*,
        **development_pressure_approach**=*None*,
        **gamma**=*None*,
        **scaling_factor**=*None*,
        **num_steps**=*None*,
        **subregions**,
        **subregions_potential**=*None*,
        **demand**=*None*,
        **memory**=*None*,
        **separator**=*"comma"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_calib_py(development_start="name", development_end="name", patch_threshold=0, patch_sizes="name", nprocs=1, subregions="name", demand="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **development_start**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development in the beginning  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    **development_end**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development in the end  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    **repeat**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many times is the simulation repeated  
    **compactness_mean**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch compactness mean to be tested  
    **compactness_range**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch compactness range to be tested  
    **discount_factor**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch size discount factor  
    **patch_threshold**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of a patch in meters squared  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **patch_sizes**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with patch sizes  
    **calibration_results**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with calibration results  
    **nprocs**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **random_seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **development_pressure**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    **incentive_power**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    **potential_weight**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reduces probability and positive increases probability.  
    **predictors**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    **n_dev_neighbourhood**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **devpot_params**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters. Values are separated by whitespace (spaces or tabs). First line is ignored, so it can be used for header  
    **num_neighbors**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **seed_search**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;**random**:  uniform distribution  
    &nbsp;&nbsp;&nbsp;&nbsp;**probability**:  development potential  
    **development_pressure_approach**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    **gamma**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **num_steps**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **subregions**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions with categories starting with 1  
    **subregions_potential**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    **demand**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Control file with number of cells to convert  
    **memory**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory for single run in GB  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in output patch file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Derive patch sizes per subregions  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only create patch size distribution file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **development_start** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development in the beginning  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **development_end** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development in the end  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **repeat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many times is the simulation repeated  
    **compactness_mean** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch compactness mean to be tested  
    **compactness_range** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch compactness range to be tested  
    **discount_factor** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch size discount factor  
    **patch_threshold** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of a patch in meters squared  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **patch_sizes** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with patch sizes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **calibration_results** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with calibration results  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **development_pressure** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **incentive_power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    **potential_weight** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reduces probability and positive increases probability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **predictors** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **n_dev_neighbourhood** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **devpot_params** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters. Values are separated by whitespace (spaces or tabs). First line is ignored, so it can be used for header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **num_neighbors** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **seed_search** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;**random**:  uniform distribution  
    &nbsp;&nbsp;&nbsp;&nbsp;**probability**:  development potential  
    **development_pressure_approach** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    **gamma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **num_steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **subregions** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions with categories starting with 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions_potential** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **demand** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Control file with number of cells to convert  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory for single run in GB  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in output patch file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Derive patch sizes per subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only create patch size distribution file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **development_start** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development in the beginning  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **development_end** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development in the end  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **repeat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;How many times is the simulation repeated  
    **compactness_mean** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch compactness mean to be tested  
    **compactness_range** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch compactness range to be tested  
    **discount_factor** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch size discount factor  
    **patch_threshold** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum size of a patch in meters squared  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **patch_sizes** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with patch sizes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **calibration_results** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with calibration results  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **development_pressure** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **incentive_power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    **potential_weight** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reduces probability and positive increases probability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **predictors** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **n_dev_neighbourhood** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **devpot_params** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters. Values are separated by whitespace (spaces or tabs). First line is ignored, so it can be used for header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **num_neighbors** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **seed_search** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;**random**:  uniform distribution  
    &nbsp;&nbsp;&nbsp;&nbsp;**probability**:  development potential  
    **development_pressure_approach** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    **gamma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **num_steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **subregions** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions with categories starting with 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions_potential** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **demand** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Control file with number of cells to convert  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory for single run in GB  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in output patch file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Derive patch sizes per subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only create patch size distribution file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.futures.calibration* is part of [FUTURES](r.futures.md), land
change model. It is used for calibrating certain input variables for
patch growing algorithm *r.futures.pga*, specifically patch size and
compactness parameters. The calibration process is conducted to match
observed urban growth patterns to those simulated by the model,
including the sizes and shapes of new development. The calibration is
achieved by varying the values of the patch parameters, comparing the
distribution of simulated patch sizes to those observed for the
reference period, and choosing the values that provide the closest
match. For the details about calibration see below.

This module depends on addon [r.object.geometry](r.object.geometry.md).

### Patch size

As part of the calibration process, module *r.futures.calibration*
produces patch size distribution file specified in **patch\_sizes**
parameter, which contains sizes (in cells) of all new patches observed
in the reference period. The format of this file is one patch size per
line. If flag **-s** is used, patch sizes will be analyzed per each
subregion, and written as a CSV file with columns representing patch
library for each subregion and header containing the categories of
subregions. FUTURES uses this file to determine the size of the
simulated patches. Often the length of the reference time period does
not match the time period which we are trying to simulate. We use the
**discount factor** to alter the size of simulated patches so that after
the reference period they closely match the observed patterns. During
the simulation, this factor is multiplied by the patch sizes listed in
the patch size file. The values of **discount factor** can vary between
0 and 1, for example value 0.6 was used by Meentemeyer et al. 2013.

### Patch compactness

The shapes of patches simulated by FUTURES are governed by the patch
compactness parameter (Meentemeyer et al. 2013, Eq. 1). This variable
doesn't represent actual patch compactness, it is rather an adjustable
scaling factor that controls patch compactness through a distance decay
effect. By specifying the mean and range of this parameter in module
*r.futures.pga*, we allow for variation in patch shape. As the value of
the parameter increases, patches become more compact. Calibration is
achieved by varying the values specified in **compactness\_mean** and
**compactness\_range** and comparing the distribution of the simulated
patch compactness (computed as *patch perimeter / (2 \* sqrt(pi \*
area))*) to those observed for the reference period. Meentemeyer et al.
2013 used mean 0.4 and range 0.08.

### Calibration input and output

Calibration requires the development binary raster in the beginning and
end of the reference period (**development\_start** and
**development\_end**) to derive the patch sizes and compactness. It is
possible to set the minimum number of cells of a patch in
**patch\_threshold** to ignore too small patches. For each combination
of values provided in **compactness\_mean**, **compactness\_range** and
**discount\_factor**, it runs module *r.futures.pga* which creates new
development pattern. From this new simulated development, patch
characteristics are derived and compared with the observed
characteristics by histogram comparison and an error (histogram
distance) is computed. Since *r.futures.pga* is a stochastic module,
multiple runs (specified in **repeat**) are recommended, the error is
then averaged. Calibration results are saved in a CSV file specified in
**calibration\_results**:

```csv
discount_factor,compactness_mean,compactness_range,area_error,compactness_error,combined_error
0.10,0.60,0.10,0.92,0.70,0.81
0.10,0.80,0.10,0.92,0.76,0.84
0.10,0.20,0.10,0.93,0.78,0.85
0.10,0.50,0.10,0.89,0.82,0.86
0.10,1.00,0.10,0.94,0.84,0.89
0.10,0.90,0.10,0.92,0.86,0.89
0.10,0.70,0.10,0.96,0.83,0.90
0.10,0.10,0.10,1.00,1.00,1.00

```

The first three columns represent the combination of calibrated
parameters. The last column is the average of the normalized area and
compactness errors for each combination. The first line shows the
combination with lowest error.

Providing too many values in **compactness\_mean**,
**compactness\_range** and **discount\_factor** results in very long
computation. Therefore it is recommended to run *r.futures.calibration*
on high-end computers, with more processes running in parallel using
**nprocs** parameter. Also, it can be run on smaller regions, under the
assumption that patch sizes and shapes are close to being consistent
across the entire study area.

For all other parameters not mentioned above, please refer to
*r.futures.pga* documentation.

## NOTES

This module depends on addon [r.object.geometry](r.object.geometry.md).
Please install it with g.extension:

```sh
g.extension r.object.geometry
```

## EXAMPLES

## SEE ALSO

*[FUTURES overview](r.futures.md), [r.futures.pga](r.futures.pga.md),
[r.futures.devpressure](r.futures.devpressure.md),
[r.futures.demand](r.futures.demand.md),
[r.futures.potential](r.futures.potential.md),
[r.sample.category](r.sample.category.md),
[r.object.geometry](r.object.geometry.md)*

## REFERENCES

- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807. DOI:
    10.1080/00045608.2012.707591
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39. DOI:
    10.1016/j.landurbplan.2014.11.011
- Petrasova, A., Petras, V., Van Berkel, D., Harmon, B. A., Mitasova,
    H., & Meentemeyer, R. K. (2016). [Open Source Approach to Urban
    Growth
    Simulation](https://isprs-archives.copernicus.org/articles/XLI-B7/953/2016/isprs-archives-XLI-B7-953-2016.pdf).
    Int. Arch. Photogramm. Remote Sens. Spatial Inf. Sci., XLI-B7,
    953-959. DOI: 10.5194/isprsarchives-XLI-B7-953-2016

## AUTHOR

Anna Petrasova, [NCSU GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.calib source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.calib)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.calib))  
Latest change: Friday May 30 13:37:35 2025 in commit [d60e371](https://github.com/OSGeo/grass-addons/commit/d60e3717c9f05b222b84af4bc02ccd3f14fdf65a)
