---
name: r.futures.parallelpga.py
description: Simulates landuse change using FUTURES (r.futures.pga) on multiple CPUs in parallel. Module uses Patch-Growing Algorithm (PGA) to simulate urban-rural landscape structure development.
keywords: [ raster, patch growing, urban, landscape, modeling ]
---

# r.futures.parallelpga.py

Simulates landuse change using FUTURES (r.futures.pga) on multiple CPUs in parallel.

Module uses Patch-Growing Algorithm (PGA) to simulate urban-rural landscape structure development.

=== "Command line"

    **r.futures.parallelpga.py**
    [**-d**]
    **nprocs**=*integer*
    **repeat**=*integer*
    **developed**=*name*
    **subregions**=*name*
    [**subregions_potential**=*name*]
    **output**=*name*
    [**output_series**=*basename*]
    [**num_steps**=*integer*]
    **predictors**=*name* [,*name*,...]
    **devpot_params**=*name*
    **development_pressure**=*name*
    **n_dev_neighbourhood**=*integer*
    **development_pressure_approach**=*string*
    **gamma**=*float*
    **scaling_factor**=*float*
    **demand**=*name*
    **discount_factor**=*float*
    **compactness_mean**=*float*
    **compactness_range**=*float*
    **num_neighbors**=*integer*
    **seed_search**=*string*
    **patch_sizes**=*name*
    [**incentive_power**=*float*]
    [**potential_weight**=*name*]
    [**random_seed**=*integer*]
    [**memory**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.parallelpga.py nprocs=1 repeat=10 developed=name subregions=name output=name predictors=name devpot_params=name development_pressure=name n_dev_neighbourhood=0 development_pressure_approach=gravity gamma=0.0 scaling_factor=0.0 demand=name discount_factor=0.0 compactness_mean=0.0 compactness_range=0.0 num_neighbors=4 seed_search=probability patch_sizes=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.futures.parallelpga.py***",
        **nprocs**=*1*,
        **repeat**=*10*,
        **developed**,
        **subregions**,
        **subregions_potential**=*None*,
        **output**,
        **output_series**=*None*,
        **num_steps**=*None*,
        **predictors**,
        **devpot_params**,
        **development_pressure**,
        **n_dev_neighbourhood**,
        **development_pressure_approach**=*"gravity"*,
        **gamma**,
        **scaling_factor**,
        **demand**,
        **discount_factor**,
        **compactness_mean**,
        **compactness_range**,
        **num_neighbors**=*4*,
        **seed_search**=*"probability"*,
        **patch_sizes**,
        **incentive_power**=*1*,
        **potential_weight**=*None*,
        **random_seed**=*None*,
        **memory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.futures.parallelpga.py", nprocs=1, repeat=10, developed="name", subregions="name", output="name", predictors="name", devpot_params="name", development_pressure="name", n_dev_neighbourhood=0, development_pressure_approach="gravity", gamma=0.0, scaling_factor=0.0, demand="name", discount_factor=0.0, compactness_mean=0.0, compactness_range=0.0, num_neighbors=4, seed_search="probability", patch_sizes="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_parallelpga_py*(**nprocs**=*1*,
        **repeat**=*10*,
        **developed**,
        **subregions**,
        **subregions_potential**=*None*,
        **output**,
        **output_series**=*None*,
        **num_steps**=*None*,
        **predictors**,
        **devpot_params**,
        **development_pressure**,
        **n_dev_neighbourhood**,
        **development_pressure_approach**=*"gravity"*,
        **gamma**,
        **scaling_factor**,
        **demand**,
        **discount_factor**,
        **compactness_mean**,
        **compactness_range**,
        **num_neighbors**=*4*,
        **seed_search**=*"probability"*,
        **patch_sizes**,
        **incentive_power**=*1*,
        **potential_weight**=*None*,
        **random_seed**=*None*,
        **memory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_parallelpga_py(nprocs=1, repeat=10, developed="name", subregions="name", output="name", predictors="name", devpot_params="name", development_pressure="name", n_dev_neighbourhood=0, development_pressure_approach="gravity", gamma=0.0, scaling_factor=0.0, demand="name", discount_factor=0.0, compactness_mean=0.0, compactness_range=0.0, num_neighbors=4, seed_search="probability", patch_sizes="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **nprocs**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **repeat**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of times stochastic simulation is repeated  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **developed**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    **subregions**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    **subregions_potential**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;State of the development at the end of simulation  
    **output_series**=*basename*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for raster maps of development generated after each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    **num_steps**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **predictors**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Listed in the same order as in the development potential table  
    **devpot_params**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters (intercepts, development pressure, other predictors). Values are separated by tabs. First line is ignored, so it can be used for header  
    **development_pressure**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    **n_dev_neighbourhood**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **development_pressure_approach**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **gamma**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **demand**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Control file with number of cells to convert  
    **discount_factor**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Discount factor of patch size  
    **compactness_mean**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean value of patch compactness to control patch shapes  
    **compactness_range**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Range of patch compactness to control patch shapes  
    **num_neighbors**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **seed_search**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined (1: uniform distribution 2: development probability)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *probability*  
    **patch_sizes**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing list of patch sizes to use  
    **incentive_power**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **potential_weight**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reduces probability and positive increases probability.  
    **random_seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **memory**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory for single run in GB  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Runs each subregion separately  
    &nbsp;&nbsp;&nbsp;&nbsp;r.futures.pga runs for each subregion and after all subregions are completed, the results are patched together  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **repeat** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of times stochastic simulation is repeated  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **developed** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions_potential** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;State of the development at the end of simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_series** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for raster maps of development generated after each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **num_steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **predictors** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Listed in the same order as in the development potential table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **devpot_params** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters (intercepts, development pressure, other predictors). Values are separated by tabs. First line is ignored, so it can be used for header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **development_pressure** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **n_dev_neighbourhood** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **development_pressure_approach** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **gamma** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **demand** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Control file with number of cells to convert  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **discount_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discount factor of patch size  
    **compactness_mean** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean value of patch compactness to control patch shapes  
    **compactness_range** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range of patch compactness to control patch shapes  
    **num_neighbors** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **seed_search** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined (1: uniform distribution 2: development probability)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *probability*  
    **patch_sizes** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing list of patch sizes to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **incentive_power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **potential_weight** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reduces probability and positive increases probability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory for single run in GB  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Runs each subregion separately  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;r.futures.pga runs for each subregion and after all subregions are completed, the results are patched together  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **repeat** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of times stochastic simulation is repeated  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **developed** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions_potential** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;State of the development at the end of simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_series** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for raster maps of development generated after each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **num_steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **predictors** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Listed in the same order as in the development potential table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **devpot_params** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters (intercepts, development pressure, other predictors). Values are separated by tabs. First line is ignored, so it can be used for header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **development_pressure** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **n_dev_neighbourhood** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **development_pressure_approach** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **gamma** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **demand** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Control file with number of cells to convert  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **discount_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discount factor of patch size  
    **compactness_mean** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean value of patch compactness to control patch shapes  
    **compactness_range** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range of patch compactness to control patch shapes  
    **num_neighbors** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **seed_search** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined (1: uniform distribution 2: development probability)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *probability*  
    **patch_sizes** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing list of patch sizes to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **incentive_power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **potential_weight** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reduces probability and positive increases probability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory for single run in GB  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Runs each subregion separately  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;r.futures.pga runs for each subregion and after all subregions are completed, the results are patched together  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Since FUTURES model is stochastic, multiple runs are recommended. Module
*r.futures.parallelpga* is a script for running
[r.futures.pga](r.futures.pga.md) on multiple CPUs. All options of
[r.futures.pga](r.futures.pga.md) are available (except for random seed
options which are handled by *r.futures.parallelpga*).

Option **repeat** changes the number of times the simulation is repeated
with the same settings but different random seed. Option **nprocs** sets
the number of parallel processes to be used, which depends on number of
available CPUs. Flag **-d** switches on parallelization on subregion
level. Subregions are split and simulation runs on each subregion
individually. This approach is convenient if available memory is not
sufficient for the entire study area. However, as each subregion is
handled separately, development pressure on the edge of a subregion does
not influence its neighbors. This can influence the results in case of
significant development happening on the subregion boundary.

## EXAMPLES

## SEE ALSO

[FUTURES](r.futures.md), *[r.futures.pga](r.futures.pga.md)*,
*[r.futures.devpressure](r.futures.devpressure.md)*,
*[r.futures.potsurface](r.futures.potsurface.md)*,
*[r.futures.demand](r.futures.demand.md)*,
*[r.futures.calib](r.futures.calib.md)*,
*[r.futures.potential](r.futures.potential.md)*,
*[r.sample.category](r.sample.category.md)*

## REFERENCES

- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807. DOI:
    10.1080/00045608.2012.707591
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39. DOI:
    10.1016/j.landurbplan.2014.11.011
- Petrasova, A., Petras, V., Van Berkel, D., Harmon, B. A., Mitasova,
    H., & Meentemeyer, R. K. (2016). [Open Source Approach to Urban
    Growth
    Simulation](https://isprs-archives.copernicus.org/articles/XLI-B7/953/2016/isprs-archives-XLI-B7-953-2016.pdf).
    Int. Arch. Photogramm. Remote Sens. Spatial Inf. Sci., XLI-B7,
    953-959. DOI: 10.5194/isprsarchives-XLI-B7-953-2016

## AUTHOR

Anna Petrasova, [NCSU GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.parallelpga source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.parallelpga)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.parallelpga))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
