---
name: r.gradient.py
description: Create a gradient map
keywords: [ raster, gradient ]
---

# r.gradient.py

Create a gradient map

=== "Command line"

    **r.gradient.py**
    **output**=*name*
    **direction**=*string*
    **range**=*integer* [,*integer*,...]
    [**percentile**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.gradient.py output=name direction=N-S range=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.gradient.py***",
        **output**,
        **direction**,
        **range**,
        **percentile**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.gradient.py", output="name", direction="N-S", range=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_gradient_py*(**output**,
        **direction**,
        **range**,
        **percentile**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_gradient_py(output="name", direction="N-S", range=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **direction**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The direction of gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *N-S,  S-N,  W-E,  E-W,  NW-SE,  NE-SW*  
    **range**=*integer* [,*integer*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum and maximum values of gradient  
    **percentile**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (only for oblique gradient)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **direction** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The direction of gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *N-S,  S-N,  W-E,  E-W,  NW-SE,  NE-SW*  
    **range** : int | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum and maximum values of gradient  
    **percentile** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (only for oblique gradient)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **direction** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The direction of gradient  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *N-S,  S-N,  W-E,  E-W,  NW-SE,  NE-SW*  
    **range** : int | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum and maximum values of gradient  
    **percentile** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (only for oblique gradient)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.gradient* create a gradient map. It is able to create horizontal,
vertical and oblique gradient.

## EXAMPLES

To calculate vertical gradient from North to South

```sh
  r.gradient output=gradient_ns range=0,50 direction=N-S
  
```

To calculate horizontal gradient from East to West

```sh
  r.gradient output=gradient_ea range=10,20 direction=E-W
  
```

To calculate oblique gradient from North-East to South-West you have to
set also the *percentile* option to set the slope of the gradient.

```sh
  r.gradient output=gradient_oblique range=10,20 direction=NE-SW
  
```

## AUTHORS

Luca Delucchi, Fondazione E. Mach (Italy)

Thanks to Johannes Radinger for the code of horizontal and vertical
gradient

## SOURCE CODE

Available at: [r.gradient source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.gradient)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.gradient))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
