---
name: r.green.gshp
description: Toolset for computing the Ground Source Heat Pump
keywords: [raster, geothermal, renewable energy]
---

# Toolset for Computing the Ground Source Heat Pump

## DESCRIPTION

The *r.green.gshp* suite computes the Ground Source Heat Pump
potential.  
It is composed of several programs considering different limits (e.g.
theoretical, planning, technical, economic/financial constraints).

The development of this tool was funded by the Alpine Space
[GRETA](http://www.alpine-space.eu/projects/greta/en/home) project.  
[![image-alt](https://greta.eurac.edu/static/geonode/img/greta_logo.png)](https://www.alpine-space.eu/projects/greta/en/home)  
GRETA is co-financed by the European Regional Development Fund through
the [Interreg Alpine Space](https://www.alpine-space.eu/) programme.  
  
The *r.green.gshp* suite consists of the following different parts:  
  
- [r.green.gshp.theoretical](r.green.gshp.theoretical.md) - Calculates
    for each single Borehole Heat Exchanger (BHE) the maximum
    power/energy potential, assessed through the G.POT method.

## SEE ALSO

*[r.green](r.green.md) - overview page  
[A. Casasso, R. Sethi, 2016, *G.POT: A quantitative method for the
assessment and mapping of the shallow geothermal potential*, **Energy**,
Volume 106, pp. 765-773](https://doi.org/10.1016/j.energy.2016.03.091)*

## AUTHOR

For authors and references, please refer to the respective module of
*r.green*.

## SOURCE CODE

Available at: [r.green.gshp source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.green/r.green.gshp)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.green/r.green.gshp))  
Latest change: Saturday Oct 18 14:02:41 2025 in commit [5cb968f](https://github.com/OSGeo/grass-addons/commit/5cb968f55a99751846ac9af8070831e07b9710e5)
