---
name: r.green.hydro.structure.py
description: Compute channels and penstocks
keywords: [  ]
---

# r.green.hydro.structure.py

Compute channels and penstocks

=== "Command line"

    **r.green.hydro.structure.py**
    [**-d**]
    **elevation**=*name*
    **plant**=*name*
    [**plant_layer**=*string*]
    [**plant_column_plant_id**=*string*]
    [**plant_column_point_id**=*string*]
    [**plant_column_stream_id**=*string*]
    [**plant_column_elevup**=*string*]
    [**plant_column_elevdown**=*string*]
    [**plant_column_discharge**=*string*]
    [**plant_column_power**=*string*]
    [**ndigits**=*integer*]
    [**resolution**=*float*]
    [**contour**=*name*]
    [**output_point**=*name*]
    **output_struct**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.hydro.structure.py elevation=name plant=name output_struct=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.hydro.structure.py***",
        **elevation**,
        **plant**,
        **plant_layer**=*"1"*,
        **plant_column_plant_id**=*"plant_id"*,
        **plant_column_point_id**=*"cat"*,
        **plant_column_stream_id**=*"stream_id"*,
        **plant_column_elevup**=*"elev_up"*,
        **plant_column_elevdown**=*"elev_down"*,
        **plant_column_discharge**=*"discharge"*,
        **plant_column_power**=*"pot_power"*,
        **ndigits**=*0*,
        **resolution**=*None*,
        **contour**=*None*,
        **output_point**=*None*,
        **output_struct**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.hydro.structure.py", elevation="name", plant="name", output_struct="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_hydro_structure_py*(**elevation**,
        **plant**,
        **plant_layer**=*"1"*,
        **plant_column_plant_id**=*"plant_id"*,
        **plant_column_point_id**=*"cat"*,
        **plant_column_stream_id**=*"stream_id"*,
        **plant_column_elevup**=*"elev_up"*,
        **plant_column_elevdown**=*"elev_down"*,
        **plant_column_discharge**=*"discharge"*,
        **plant_column_power**=*"pot_power"*,
        **ndigits**=*0*,
        **resolution**=*None*,
        **contour**=*None*,
        **output_point**=*None*,
        **output_struct**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_hydro_structure_py(elevation="name", plant="name", output_struct="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **plant**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map with segments of potential plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **plant_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **plant_column_plant_id**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the plant id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plant_id*  
    **plant_column_point_id**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the point id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **plant_column_stream_id**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the stream id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *stream_id*  
    **plant_column_elevup**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the elevation value at the intake (upstream) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev_up*  
    **plant_column_elevdown**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the elevation value at the restitution (downstream) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev_down*  
    **plant_column_discharge**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the discharge values [m3/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *discharge*  
    **plant_column_power**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the potential power [kW]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pot_power*  
    **ndigits**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits to use for the elevation in the contour line vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **resolution**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution use for the contour line vector map, if 0.25 approximate 703.31 tp 703.25  
    **contour**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the contour line vector map  
    **output_point**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with potential intakes and restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **output_struct**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with the structure of the plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plant** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map with segments of potential plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **plant_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **plant_column_plant_id** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the plant id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plant_id*  
    **plant_column_point_id** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the point id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **plant_column_stream_id** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the stream id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *stream_id*  
    **plant_column_elevup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the elevation value at the intake (upstream) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev_up*  
    **plant_column_elevdown** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the elevation value at the restitution (downstream) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev_down*  
    **plant_column_discharge** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the discharge values [m3/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *discharge*  
    **plant_column_power** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the potential power [kW]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pot_power*  
    **ndigits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits to use for the elevation in the contour line vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution use for the contour line vector map, if 0.25 approximate 703.31 tp 703.25  
    **contour** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the contour line vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_point** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with potential intakes and restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_struct** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with the structure of the plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plant** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map with segments of potential plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **plant_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector map layer of plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **plant_column_plant_id** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the plant id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plant_id*  
    **plant_column_point_id** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the point id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cat*  
    **plant_column_stream_id** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the stream id  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *stream_id*  
    **plant_column_elevup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the elevation value at the intake (upstream) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev_up*  
    **plant_column_elevdown** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the elevation value at the restitution (downstream) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev_down*  
    **plant_column_discharge** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the discharge values [m3/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *discharge*  
    **plant_column_power** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name with the potential power [kW]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pot_power*  
    **ndigits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of digits to use for the elevation in the contour line vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution use for the contour line vector map, if 0.25 approximate 703.31 tp 703.25  
    **contour** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the contour line vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_point** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with potential intakes and restitution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **output_struct** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output vector map with the structure of the plants  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Debug with intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.green.hydro.structure* computes the derivation channel and the
penstock for each potential plant and for both sides of the river.

## NOTES

The input maps are the elevation raster map and the one with the
segments of potential plants (vector map which can be computed by
r.green.hydro.optimal or r.green.hydro.recommended).  
In the section "Input column", the column names in the table of the map
with potential plants have to be reported in order to read correctly the
corresponding values.  
The module returns a vector map with the structure for each plant on
both sides of the river. The derivation channel and the penstock are
distinguished and reported in the table.  
In option, the module can also compute the vector map with the intake
and restitution of each potential plant.  
  
As the current potential concerns especially small hydropower (inferior
to 20 MW), the structure suggested is the one for small hydropower
detailed in the picture below. It is composed of an intake (A) which
diverts water from the river. This water is conveyed into a derivation
channel (B) with a very low slope and arrives in a forebay tank (C)
which regulates the fluctuation of discharge. Finally, the penstock (D)
conveys the water with the highest possible head to the
turbine-alternator group (E) which produces electricity. The water is
then released in the river (restitution F). We use the following
vocabulary: the structure of the plant corresponds to the part with the
derivation channel, the forebay tank and the penstock, whereas the
segment of the plant corresponds to the part of the river (water not
diverted) between the intake (A) and the restitution (F).  
  
![image-alt](r_green_hydro_technical_picstruct.png)  
Structure of the plants considered in the module

The power is maximized for the highest head in the penstock so the
derivation channel is computed along the same quote (the low slope is
neglected here) until the point which maximizes the head along the
penstock. The structure is computed for both sides of the river in order
to determine which one produces the most power.

## EXAMPLE

This example is based on the case-study of Gesso and Vermenagna valleys
in the Natural Park of the Maritime Alps, Piedmont, Italy.  
  
Here is the input vector map potentialplants with the segments of
potential plants (in blue). The vector map with the intakes and
restitution of potential plants is also visibile in red on this
picture.  
  
![image-alt](r_green_hydro_structure_input.png)  
Input vector map potentialplants

The following command computes the derivation channel and the penstock
for each potential plant and for each side of the river :  

```sh
r.green.hydro.structure elevation=elevation plant=potentialplants output_struct=structplants
```

The result is shown in black in the following picture which gathers the
input and output maps.  
  
![image-alt](r_green_hydro_structure_output.png)  
Output vector map structplants in black

## SEE ALSO

*[r.green.hydro.discharge](r.green.hydro.discharge.md)  
[r.green.hydro.delplants](r.green.hydro.delplants.md)  
[r.green.hydro.theoretical](r.green.hydro.theoretical.md)  
[r.green.hydro.optimal](r.green.hydro.optimal.md)  
[r.green.hydro.recommended](r.green.hydro.recommended.md)  
[r.green.hydro.technical](r.green.hydro.technical.md)  
[r.green.hydro.financial](r.green.hydro.financial.md)  
*

## REFERENCE

Picture of the plant structure taken from Micro-hydropower Systems - A
Buyer's Guide, Natural Resources Canada, 2004

## AUTHORS

Pietro Zambelli (Eurac Research, Bolzano, Italy), Manual written by
Julie Gros.

## SOURCE CODE

Available at: [r.green.hydro.structure source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.hydro/r.green.hydro.structure)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.hydro/r.green.hydro.structure))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
