---
name: r.gsflow.hydrodem.py
description: Creates hydrologically correct MODFLOW DEM from higher-res DEM
keywords: [ vector, stream network, hydrology, GSFLOW, GSFLOW ]
---

# r.gsflow.hydrodem.py

Creates hydrologically correct MODFLOW DEM from higher-res DEM

=== "Command line"

    **r.gsflow.hydrodem.py**
    **dem**=*name*
    **grid**=*name*
    **streams**=*name*
    **streams_modflow**=*name*
    [**dem_modflow**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.gsflow.hydrodem.py dem=name grid=name streams=name streams_modflow=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.gsflow.hydrodem.py***",
        **dem**,
        **grid**,
        **streams**,
        **streams_modflow**,
        **dem_modflow**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.gsflow.hydrodem.py", dem="name", grid="name", streams="name", streams_modflow="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_gsflow_hydrodem_py*(**dem**,
        **grid**,
        **streams**,
        **streams_modflow**,
        **dem_modflow**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_gsflow_hydrodem_py(dem="name", grid="name", streams="name", streams_modflow="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **dem**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input higher-resolution elevation data  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **grid**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **streams**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of stream network (lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **streams_modflow**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream network at MODFLOW grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **dem_modflow**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hydrologically corrected DEM at MODFLOW grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **dem** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input higher-resolution elevation data  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **grid** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of stream network (lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **streams_modflow** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream network at MODFLOW grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **dem_modflow** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hydrologically corrected DEM at MODFLOW grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **dem** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input higher-resolution elevation data  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **grid** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of stream network (lines)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **streams_modflow** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream network at MODFLOW grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **dem_modflow** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hydrologically corrected DEM at MODFLOW grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.gsflow.hydrodem* generates a hydrologically-correct MODFLOW DEM for
GSFLOW based on higher-resolution flow routing. It does so by taking
minimum grid cell elevations where streams are present, and mean grid
cell elevations elsewhere, while coarsening the resolution to that of
the specified MODFLOW grid resolution.

## REFERENCES

Ng, G.-H. C., A. D. Wickert, R. L. McLaughlin, J. La Frenierre, S.
Liess, and L. Sabeeri (2016), Modeling the role of groundwater and
vegetation in the hydrological response of tropical glaciated watersheds
to climate change, in AGU Fall Meeting Abstracts, H13L–1590, San
Francisco, CA.

## SEE ALSO

[v.gsflow.export](v.gsflow.export),
[v.gsflow.gravres](v.gsflow.gravres), [v.gsflow.grid](v.gsflow.grid),
[v.gsflow.hruparams](v.gsflow.hruparams),
[v.gsflow.reaches](v.gsflow.reaches),
[v.gsflow.segments](v.gsflow.segments),
[v.gsflow.mapdata](v.gsflow.mapdata),
[v.stream.inbasin](v.stream.inbasin),
[v.stream.network](v.stream.network)

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [r.gsflow.hydrodem source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.gsflow.hydrodem)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.gsflow.hydrodem))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
