---
name: r.mapcalc.tiled.py
description: Runs r.mapcalc in parallel over tiles.
keywords: [ raster, algebra, tiling ]
---

# r.mapcalc.tiled.py

Runs r.mapcalc in parallel over tiles.

=== "Command line"

    **r.mapcalc.tiled.py**
    **expression**=*string*
    [**output**=*name*]
    [**width**=*integer*]
    [**height**=*integer*]
    **overlap**=*integer*
    [**nprocs**=*integer*]
    [**processes**=*integer*]
    [**mapset_prefix**=*string*]
    [**patch_backend**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mapcalc.tiled.py expression=string overlap=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mapcalc.tiled.py***",
        **expression**,
        **output**=*None*,
        **width**=*None*,
        **height**=*None*,
        **overlap**=*0*,
        **nprocs**=*None*,
        **processes**=*None*,
        **mapset_prefix**=*None*,
        **patch_backend**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mapcalc.tiled.py", expression="string", overlap=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mapcalc_tiled_py*(**expression**,
        **output**=*None*,
        **width**=*None*,
        **height**=*None*,
        **overlap**=*0*,
        **nprocs**=*None*,
        **processes**=*None*,
        **mapset_prefix**=*None*,
        **patch_backend**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mapcalc_tiled_py(expression="string", overlap=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **expression**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Expression to send to r.mapcalc  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster output map resulting from expression  
    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns)  
    **height**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (rows)  
    **overlap**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **processes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;This option is obsolete and replaced by nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel, use nprocs option instead  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **mapset_prefix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset prefix  
    **patch_backend**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Backend for patching computed tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;If backend is not specified, original serial implementation with RasterRow is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *RasterRow, r.patch*  
    &nbsp;&nbsp;&nbsp;&nbsp;**RasterRow**:  serial patching with PyGRASS RasterRow  
    &nbsp;&nbsp;&nbsp;&nbsp;**r.patch**:  parallelized r.patch (with zero overlap only)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **expression** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Expression to send to r.mapcalc  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster output map resulting from expression  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns)  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (rows)  
    **overlap** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;This option is obsolete and replaced by nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel, use nprocs option instead  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **mapset_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset prefix  
    **patch_backend** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Backend for patching computed tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;If backend is not specified, original serial implementation with RasterRow is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *RasterRow, r.patch*  
    &nbsp;&nbsp;&nbsp;&nbsp;**RasterRow**:  serial patching with PyGRASS RasterRow  
    &nbsp;&nbsp;&nbsp;&nbsp;**r.patch**:  parallelized r.patch (with zero overlap only)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **expression** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Expression to send to r.mapcalc  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster output map resulting from expression  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of tiles (columns)  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of tiles (rows)  
    **overlap** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap of tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;This option is obsolete and replaced by nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.mapcalc processes to run in parallel, use nprocs option instead  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **mapset_prefix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset prefix  
    **patch_backend** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Backend for patching computed tiles  
    &nbsp;&nbsp;&nbsp;&nbsp;If backend is not specified, original serial implementation with RasterRow is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *RasterRow, r.patch*  
    &nbsp;&nbsp;&nbsp;&nbsp;**RasterRow**:  serial patching with PyGRASS RasterRow  
    &nbsp;&nbsp;&nbsp;&nbsp;**r.patch**:  parallelized r.patch (with zero overlap only)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.mapcalc.tiled* cuts a raster input map into tiles and runs
[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html)
over these tiles before patching the result together into a single
output raster map.

The user provides the map calculation **expression**. The output map
name is automatically extracted from that expression by extracting the
string before the '='. If the **expression** is more complex, the user
can also provide the the output map name with the parameter **output**

Tiles can be defined with the **width**, **height** and **overlap**
parameters. If no **width** and **height** is specified, they are
automatically computed from the number of processes and current
computational region (with GRASS GIS v8.2 and above). For example, 8
processes result in 8 tiles where the tile width is equal to the number
of columns. If **nprocs** is higher than one, these tiles will be
processed in parallel.

The **mapset\_prefix** parameter ensures that the temporary mapsets
created during the tiled processing have unique names. This is useful if
the user runs *r.mapcalc.tiled* several times in parallel (e.g. in an
HPC environment).

Option **patch\_backend** can switch how the resulting tiles are merged.
With **patch\_backend=RasterRow** (default) the original
[GridModule](https://grass.osgeo.org/grass-stable/manuals/libpython/pygrass.modules.grid.html)
implementation is used. With **patch\_backend=r.patch** module
[r.patch](https://grass.osgeo.org/grass-stable/manuals/r.patch.html) is
used with the number of cores specified with **nprocs**. This backend
can only be used with 0 overlap.

## EXAMPLE

Run **r.mapcalc** over tiles with size 1000x1000 using 4 parallel
processes (North Carolina sample dataset):

```sh
g.region raster=ortho_2001_t792_1m
r.mapcalc.tiled expression="bright_pixels = if(ortho_2001_t792_1m > 200, 1, 0)" \
   width=1000 height=1000 nprocs=4
```

## SEE ALSO

[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html)

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [r.mapcalc.tiled source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mapcalc.tiled)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mapcalc.tiled))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
