---
name: r.maxent.train.py
description: Create and train a Maxent model
keywords: [ modeling, Maxent ]
---

# r.maxent.train.py

Create and train a Maxent model

=== "Command line"

    **r.maxent.train.py**
    [**-ybgwecflqpthanjdsxv**]
    **samplesfile**=*name*
    **environmentallayersfile**=*name*
    [**togglelayertype**=*string*]
    [**projectionlayers**=*name*]
    [**suffix**=*string*]
    [**nodata**=*integer*]
    **outputdirectory**=*name*
    [**samplepredictions**=*name*]
    [**backgroundpredictions**=*name*]
    [**predictionlayer**=*name*]
    [**outputformat**=*string*]
    [**betamultiplier**=*float*]
    [**randomtestpoints**=*integer*]
    [**testsamplesfile**=*name*]
    [**replicatetype**=*string*]
    [**replicates**=*integer*]
    [**maximumiterations**=*integer*]
    [**convergencethreshold**=*float*]
    [**lq2lqptthreshold**=*integer*]
    [**l2lqthreshold**=*integer*]
    [**hingethreshold**=*integer*]
    [**beta_threshold**=*float*]
    [**beta_categorical**=*float*]
    [**beta_lqp**=*float*]
    [**beta_hinge**=*float*]
    [**defaultprevalence**=*float*]
    [**maxent**=*name*]
    [**java**=*name*]
    [**threads**=*integer*]
    [**memory**=*memory in MB*]
    [**precision**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.maxent.train.py samplesfile=name environmentallayersfile=name outputdirectory=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.maxent.train.py***",
        **samplesfile**,
        **environmentallayersfile**,
        **togglelayertype**=*None*,
        **projectionlayers**=*None*,
        **suffix**=*None*,
        **nodata**=*-9999*,
        **outputdirectory**,
        **samplepredictions**=*None*,
        **backgroundpredictions**=*None*,
        **predictionlayer**=*None*,
        **outputformat**=*"cloglog"*,
        **betamultiplier**=*1.0*,
        **randomtestpoints**=*0*,
        **testsamplesfile**=*None*,
        **replicatetype**=*"crossvalidate"*,
        **replicates**=*1*,
        **maximumiterations**=*500*,
        **convergencethreshold**=*0.00005*,
        **lq2lqptthreshold**=*80*,
        **l2lqthreshold**=*10*,
        **hingethreshold**=*15*,
        **beta_threshold**=*-1.0*,
        **beta_categorical**=*-1.0*,
        **beta_lqp**=*-1.0*,
        **beta_hinge**=*-1.0*,
        **defaultprevalence**=*0.5*,
        **maxent**=*None*,
        **java**=*None*,
        **threads**=*0*,
        **memory**=*300*,
        **precision**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.maxent.train.py", samplesfile="name", environmentallayersfile="name", outputdirectory="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_maxent_train_py*(**samplesfile**,
        **environmentallayersfile**,
        **togglelayertype**=*None*,
        **projectionlayers**=*None*,
        **suffix**=*None*,
        **nodata**=*-9999*,
        **outputdirectory**,
        **samplepredictions**=*None*,
        **backgroundpredictions**=*None*,
        **predictionlayer**=*None*,
        **outputformat**=*"cloglog"*,
        **betamultiplier**=*1.0*,
        **randomtestpoints**=*0*,
        **testsamplesfile**=*None*,
        **replicatetype**=*"crossvalidate"*,
        **replicates**=*1*,
        **maximumiterations**=*500*,
        **convergencethreshold**=*0.00005*,
        **lq2lqptthreshold**=*80*,
        **l2lqthreshold**=*10*,
        **hingethreshold**=*15*,
        **beta_threshold**=*-1.0*,
        **beta_categorical**=*-1.0*,
        **beta_lqp**=*-1.0*,
        **beta_hinge**=*-1.0*,
        **defaultprevalence**=*0.5*,
        **maxent**=*None*,
        **java**=*None*,
        **threads**=*0*,
        **memory**=*300*,
        **precision**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_maxent_train_py(samplesfile="name", environmentallayersfile="name", outputdirectory="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **samplesfile**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample file presence locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Please enter the name of a file containing presence locations for one or more species.  
    **environmentallayersfile**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample file with background locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Please enter the file name of the SWD file with environmental variables (can be created with v.maxent.swd or r.out.maxent_swd).  
    **togglelayertype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix that identifies categorical data  
    &nbsp;&nbsp;&nbsp;&nbsp;Toggle continuous/categorical for environmental variables whose names begin with this prefix (default: all continuous)  
    **projectionlayers**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location of folder with set of environmental variables.  
    &nbsp;&nbsp;&nbsp;&nbsp;Location of an set of rasters representing the same environmental variables as used to create the Maxent model. They will be used to create a prediction layer based on the trained model.  
    **suffix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for name(s) of prediction layer(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Add a suffix to the name(s) of imported prediction layer(s)  
    **nodata**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Nodata values  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to be interpreted as nodata values in SWD sample data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-9999*  
    **outputdirectory**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where outputs will be written.  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where outputs will be written. This should be different from the environmental layers directory.  
    **samplepredictions**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sample prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of sample prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    **backgroundpredictions**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of background prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of background prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    **predictionlayer**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of raster prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    **outputformat**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Representation probability  
    &nbsp;&nbsp;&nbsp;&nbsp;Representation of probabilities used in writing output grids. See Help for details.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cloglog, logistic, cumulative, raw*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cloglog*  
    **betamultiplier**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply all automatic regularization parameters by this number.  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply all automatic regularization parameters by this number. A higher number gives a more spread-out distribution.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **randomtestpoints**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of random test points  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of presence localities to be randomly set aside as test points, used to compute the AUC, omission, etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **testsamplesfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Test presence locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the presence localities in this csv file to compute statistics (AUC, omission, etc.).  
    **replicatetype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of replicates in cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;If replicates &gt; 1, do multiple runs using crossvalidate,bootstrap or subsample. See the Maxent help file for the difference.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *crossvalidate, bootstrap, subsample*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *crossvalidate*  
    **replicates**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of replicates in cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;If replicates &gt; 1, do multiple runs of this type: Crossvalidate: samples divided into replicates folds; each fold in turn used for test data. Bootstrap: replicate sample sets chosen by sampling with replacement. Subsample: replicate sample sets chosen by removing random test percentage without replacement to be used for evaluation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **maximumiterations**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum iterations optimization  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop training after this many iterations of the optimization algorithm.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *500*  
    **convergencethreshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop training when the drop in log loss per iteration drops below this number.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.00005*  
    **lq2lqptthreshold**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for product and threshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which product and threshold features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *80*  
    **l2lqthreshold**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for quadratic feature  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which quadratic features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **hingethreshold**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for hinge feature  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which hinge features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15*  
    **beta_threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for treshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all threshold features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_categorical**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for categorical features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all categorical features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_lqp**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for lin, quad and prod features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all linear, quadratic and product features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_hinge**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for hinge features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all linear, quadratic and product features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **defaultprevalence**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default prevalence of the species  
    &nbsp;&nbsp;&nbsp;&nbsp;Default prevalence of the species: probability of presence at ordinary occurrence points. See Elith et al., Diversity and Distributions, 2011 for details.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **maxent**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Maxent jar file  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Maxent executable file (maxent.jar)  
    **java**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location java executable  
    &nbsp;&nbsp;&nbsp;&nbsp;If Java is installed, but cannot be found, the user can provide the path to the java executable file. Note, an alternative is to use the r.maxent.setup addon.  
    **threads**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processor threads to use.  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used by Maxent (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **precision**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision suitability map  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the required precision (in the form of number of decimal digits) of the species suitability raster layer (leave empty for default).  
    **-y**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer from the sample predictions  
    &nbsp;&nbsp;&nbsp;&nbsp;Import the file(s) with sample predictions as point feature layer.  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer with predictions at background points  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer with predictions at background points  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create response curves.  
    &nbsp;&nbsp;&nbsp;&nbsp;Create graphs showing how predicted relative probability of occurrence depends on the value of each environmental variable.  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Write response curve data to file  
    &nbsp;&nbsp;&nbsp;&nbsp;Write output files containing the data used to make response curves, for import into external plotting software.  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extrapolate  
    &nbsp;&nbsp;&nbsp;&nbsp;Predict to regions of environmental space outside the limits encountered during training.  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not apply clamping  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not apply clamping when projecting.  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Fade effect clamping  
    &nbsp;&nbsp;&nbsp;&nbsp;Reduce prediction at each point in projections by the difference between clamped and non-clamped output at that point.  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use linear features for the model (they are used by default).  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable quadratic features  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use quadratic features for the model (they are used by default).  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable product features  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use product features for the model (they are used by default).  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use threshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, threshold features are not used. Use this flag to enable them.  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable hinge features  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use hinge features for the model (they are used by default).  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use automatic selection of feature classes  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, Maxent automatically selects which feature classes to use, based on number of training samples. Use this flag to disable autoselection of features.  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Don't add sample points to background if conditions differ  
    &nbsp;&nbsp;&nbsp;&nbsp;By default, samples that have a combination of environmental values that isn't already present in the background are added to the background samples. Use this flag to avoid that.  
    **-j**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use jackknife validation  
    &nbsp;&nbsp;&nbsp;&nbsp;Measure importance of each environmental variable by training with each environmental variable first omitted, then used in isolation.  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep duplicate presence records.  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep duplicate presence records. If environmental data are in grids, duplicates are records in the same grid cell. Otherwise, duplicates are records with identical coordinates.  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use a random seed  
    &nbsp;&nbsp;&nbsp;&nbsp;If selected, a different random seed will be used for each run, so a different random test/train partition will be made and a different random subset of the background will be used, if applicable.  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Add all samples to the background  
    &nbsp;&nbsp;&nbsp;&nbsp;Add all samples to the background, even if they have combinations of environmental values that are already present in the background  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Show the Maxent user interface  
    &nbsp;&nbsp;&nbsp;&nbsp;Use this flag to show the Maxent interface. Note that when you select this option, Maxent will not start before you hit the start option.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **samplesfile** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample file presence locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Please enter the name of a file containing presence locations for one or more species.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **environmentallayersfile** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample file with background locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Please enter the file name of the SWD file with environmental variables (can be created with v.maxent.swd or r.out.maxent_swd).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **togglelayertype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix that identifies categorical data  
    &nbsp;&nbsp;&nbsp;&nbsp;Toggle continuous/categorical for environmental variables whose names begin with this prefix (default: all continuous)  
    **projectionlayers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location of folder with set of environmental variables.  
    &nbsp;&nbsp;&nbsp;&nbsp;Location of an set of rasters representing the same environmental variables as used to create the Maxent model. They will be used to create a prediction layer based on the trained model.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for name(s) of prediction layer(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Add a suffix to the name(s) of imported prediction layer(s)  
    **nodata** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Nodata values  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to be interpreted as nodata values in SWD sample data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-9999*  
    **outputdirectory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where outputs will be written.  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where outputs will be written. This should be different from the environmental layers directory.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **samplepredictions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sample prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of sample prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **backgroundpredictions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of background prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of background prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **predictionlayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of raster prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **outputformat** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Representation probability  
    &nbsp;&nbsp;&nbsp;&nbsp;Representation of probabilities used in writing output grids. See Help for details.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cloglog, logistic, cumulative, raw*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cloglog*  
    **betamultiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply all automatic regularization parameters by this number.  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply all automatic regularization parameters by this number. A higher number gives a more spread-out distribution.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **randomtestpoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of random test points  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of presence localities to be randomly set aside as test points, used to compute the AUC, omission, etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **testsamplesfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Test presence locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the presence localities in this csv file to compute statistics (AUC, omission, etc.).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **replicatetype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of replicates in cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;If replicates &gt; 1, do multiple runs using crossvalidate,bootstrap or subsample. See the Maxent help file for the difference.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *crossvalidate, bootstrap, subsample*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *crossvalidate*  
    **replicates** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of replicates in cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;If replicates &gt; 1, do multiple runs of this type: Crossvalidate: samples divided into replicates folds; each fold in turn used for test data. Bootstrap: replicate sample sets chosen by sampling with replacement. Subsample: replicate sample sets chosen by removing random test percentage without replacement to be used for evaluation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **maximumiterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum iterations optimization  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop training after this many iterations of the optimization algorithm.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *500*  
    **convergencethreshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop training when the drop in log loss per iteration drops below this number.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.00005*  
    **lq2lqptthreshold** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for product and threshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which product and threshold features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *80*  
    **l2lqthreshold** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for quadratic feature  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which quadratic features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **hingethreshold** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for hinge feature  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which hinge features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15*  
    **beta_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for treshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all threshold features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_categorical** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for categorical features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all categorical features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_lqp** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for lin, quad and prod features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all linear, quadratic and product features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_hinge** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for hinge features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all linear, quadratic and product features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **defaultprevalence** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default prevalence of the species  
    &nbsp;&nbsp;&nbsp;&nbsp;Default prevalence of the species: probability of presence at ordinary occurrence points. See Elith et al., Diversity and Distributions, 2011 for details.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **maxent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Maxent jar file  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Maxent executable file (maxent.jar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **java** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location java executable  
    &nbsp;&nbsp;&nbsp;&nbsp;If Java is installed, but cannot be found, the user can provide the path to the java executable file. Note, an alternative is to use the r.maxent.setup addon.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **threads** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processor threads to use.  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used by Maxent (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision suitability map  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the required precision (in the form of number of decimal digits) of the species suitability raster layer (leave empty for default).  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *y*, *b*, *g*, *w*, *e*, *c*, *f*, *l*, *q*, *p*, *t*, *h*, *a*, *n*, *j*, *d*, *s*, *x*, *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer from the sample predictions  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import the file(s) with sample predictions as point feature layer.  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer with predictions at background points  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer with predictions at background points  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create response curves.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create graphs showing how predicted relative probability of occurrence depends on the value of each environmental variable.  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write response curve data to file  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write output files containing the data used to make response curves, for import into external plotting software.  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extrapolate  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Predict to regions of environmental space outside the limits encountered during training.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not apply clamping  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not apply clamping when projecting.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fade effect clamping  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reduce prediction at each point in projections by the difference between clamped and non-clamped output at that point.  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use linear features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable quadratic features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use quadratic features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable product features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use product features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use threshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default, threshold features are not used. Use this flag to enable them.  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable hinge features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use hinge features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use automatic selection of feature classes  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default, Maxent automatically selects which feature classes to use, based on number of training samples. Use this flag to disable autoselection of features.  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't add sample points to background if conditions differ  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default, samples that have a combination of environmental values that isn't already present in the background are added to the background samples. Use this flag to avoid that.  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use jackknife validation  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Measure importance of each environmental variable by training with each environmental variable first omitted, then used in isolation.  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep duplicate presence records.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep duplicate presence records. If environmental data are in grids, duplicates are records in the same grid cell. Otherwise, duplicates are records with identical coordinates.  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use a random seed  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If selected, a different random seed will be used for each run, so a different random test/train partition will be made and a different random subset of the background will be used, if applicable.  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add all samples to the background  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add all samples to the background, even if they have combinations of environmental values that are already present in the background  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show the Maxent user interface  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use this flag to show the Maxent interface. Note that when you select this option, Maxent will not start before you hit the start option.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **samplesfile** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample file presence locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Please enter the name of a file containing presence locations for one or more species.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **environmentallayersfile** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sample file with background locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Please enter the file name of the SWD file with environmental variables (can be created with v.maxent.swd or r.out.maxent_swd).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **togglelayertype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix that identifies categorical data  
    &nbsp;&nbsp;&nbsp;&nbsp;Toggle continuous/categorical for environmental variables whose names begin with this prefix (default: all continuous)  
    **projectionlayers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location of folder with set of environmental variables.  
    &nbsp;&nbsp;&nbsp;&nbsp;Location of an set of rasters representing the same environmental variables as used to create the Maxent model. They will be used to create a prediction layer based on the trained model.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix for name(s) of prediction layer(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Add a suffix to the name(s) of imported prediction layer(s)  
    **nodata** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Nodata values  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to be interpreted as nodata values in SWD sample data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-9999*  
    **outputdirectory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where outputs will be written.  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where outputs will be written. This should be different from the environmental layers directory.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **samplepredictions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sample prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of sample prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **backgroundpredictions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of background prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of background prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **predictionlayer** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster prediction layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the name of raster prediction layer. If you leave this empty, the default name given by Maxent will be used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **outputformat** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Representation probability  
    &nbsp;&nbsp;&nbsp;&nbsp;Representation of probabilities used in writing output grids. See Help for details.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cloglog, logistic, cumulative, raw*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cloglog*  
    **betamultiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply all automatic regularization parameters by this number.  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply all automatic regularization parameters by this number. A higher number gives a more spread-out distribution.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **randomtestpoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of random test points  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of presence localities to be randomly set aside as test points, used to compute the AUC, omission, etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **testsamplesfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Test presence locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the presence localities in this csv file to compute statistics (AUC, omission, etc.).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **replicatetype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of replicates in cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;If replicates &gt; 1, do multiple runs using crossvalidate,bootstrap or subsample. See the Maxent help file for the difference.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *crossvalidate, bootstrap, subsample*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *crossvalidate*  
    **replicates** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of replicates in cross-validation  
    &nbsp;&nbsp;&nbsp;&nbsp;If replicates &gt; 1, do multiple runs of this type: Crossvalidate: samples divided into replicates folds; each fold in turn used for test data. Bootstrap: replicate sample sets chosen by sampling with replacement. Subsample: replicate sample sets chosen by removing random test percentage without replacement to be used for evaluation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-20*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **maximumiterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum iterations optimization  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop training after this many iterations of the optimization algorithm.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *500*  
    **convergencethreshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;Stop training when the drop in log loss per iteration drops below this number.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.00005*  
    **lq2lqptthreshold** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for product and threshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which product and threshold features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *80*  
    **l2lqthreshold** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for quadratic feature  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which quadratic features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **hingethreshold** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for hinge feature  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of samples at which hinge features start being used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *15*  
    **beta_threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for treshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all threshold features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_categorical** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for categorical features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all categorical features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_lqp** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for lin, quad and prod features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all linear, quadratic and product features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **beta_hinge** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter for hinge features  
    &nbsp;&nbsp;&nbsp;&nbsp;Regularization parameter to be applied to all linear, quadratic and product features; negative value enables automatic setting.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1.0*  
    **defaultprevalence** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default prevalence of the species  
    &nbsp;&nbsp;&nbsp;&nbsp;Default prevalence of the species: probability of presence at ordinary occurrence points. See Elith et al., Diversity and Distributions, 2011 for details.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **maxent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location Maxent jar file  
    &nbsp;&nbsp;&nbsp;&nbsp;Give the path to the Maxent executable file (maxent.jar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **java** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location java executable  
    &nbsp;&nbsp;&nbsp;&nbsp;If Java is installed, but cannot be found, the user can provide the path to the java executable file. Note, an alternative is to use the r.maxent.setup addon.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **threads** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processor threads to use.  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used by Maxent (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision suitability map  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the required precision (in the form of number of decimal digits) of the species suitability raster layer (leave empty for default).  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *y*, *b*, *g*, *w*, *e*, *c*, *f*, *l*, *q*, *p*, *t*, *h*, *a*, *n*, *j*, *d*, *s*, *x*, *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer from the sample predictions  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import the file(s) with sample predictions as point feature layer.  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer with predictions at background points  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a vector point layer with predictions at background points  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create response curves.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create graphs showing how predicted relative probability of occurrence depends on the value of each environmental variable.  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write response curve data to file  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write output files containing the data used to make response curves, for import into external plotting software.  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extrapolate  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Predict to regions of environmental space outside the limits encountered during training.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not apply clamping  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not apply clamping when projecting.  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Fade effect clamping  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reduce prediction at each point in projections by the difference between clamped and non-clamped output at that point.  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use linear features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable quadratic features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use quadratic features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable product features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use product features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use threshold features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default, threshold features are not used. Use this flag to enable them.  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable hinge features  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use hinge features for the model (they are used by default).  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not use automatic selection of feature classes  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default, Maxent automatically selects which feature classes to use, based on number of training samples. Use this flag to disable autoselection of features.  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't add sample points to background if conditions differ  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default, samples that have a combination of environmental values that isn't already present in the background are added to the background samples. Use this flag to avoid that.  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use jackknife validation  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Measure importance of each environmental variable by training with each environmental variable first omitted, then used in isolation.  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep duplicate presence records.  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep duplicate presence records. If environmental data are in grids, duplicates are records in the same grid cell. Otherwise, duplicates are records with identical coordinates.  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use a random seed  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If selected, a different random seed will be used for each run, so a different random test/train partition will be made and a different random subset of the background will be used, if applicable.  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add all samples to the background  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add all samples to the background, even if they have combinations of environmental values that are already present in the background  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show the Maxent user interface  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use this flag to show the Maxent interface. Note that when you select this option, Maxent will not start before you hit the start option.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.maxent.train* module is a front-end to the Maxent software,
providing a convenient way to run the Maxent software, and create output
layers in GRASS GIS.

[![image-alt](r_maxent_train_workflow.png)](r_maxent_train_workflow.png)  
*A workflow, from data preparation, training a model to model prediction
using three GRASS GIS addons.*

It is part of a set of three addons that can be used to prepare the
input data for the Maxent model (*v.maxent.sdm*), to train a maxent
presence only model (this module), and to use the model to create
prediction layers (*r.maxent.predict*). With *r.maxent.train* a Maxent
presence only model can be created using the *Maxent software*. As
input, the addon requires two comma-separated files, one with the
species locations and another of background points locations. Both need
to include columns with the X, Y and sample values of the environmental
variables that you want to use as predictor variables. You can use the
[r.out.maxent\_swd](r.out.maxent_swd.html) or
[v.maxent.swd](v.maxent.swd.html) addons to create these files. For more
details about the structure of these files, see the [Maxent
website](https://biodiversityinformatics.amnh.org/open_source/maxent/).

The only other requirement is to provide an output folder. With these
inputs, a Maxent model will be created. If you also provide a folder
with environmental raster layers with names corresponding to the names
of the environmental variables in the SWD files, the module will create
a prediction (suitability distribution) raster layer as well.

Note that the Maxent software generates ASCII files without projection
information. That means you need to make sure yourself that the
environmental layers you provide are in the same reference coordinate
system as your current mapset. An easy way to ensure this is by using
the *v.maxent\_swd* from the same mapset to create those input
environmental layers for Maxent. See the workflow in the Examples.

The addon provides access to nearly all parameters available in the
Maxent software. On the above-mentioned website, you can find a tutorial
that explains most of these options. For the other options, see the
Maxent help file.

## NOTES

This addon requires the Maxent software (version ≥ 3.4). You can
download the software from the [Maxent
website](https://biodiversityinformatics.amnh.org/open_source/maxent).
The *r.maxent.setup* module provides an helper function to enable GRASS
GIS to use the Maxent software.

The *r.maxent.train* addon runs Maxent in the background. If you want to
check the Maxent settings first, you can set the *-v* flag to open the
Maxent user interface with all parameters filled in. You will need to
hit the *Run* button to actually run Maxent.

Besides the files directly generated by *Maxent*, the addon creates the
*maxent\_explanatory\_variable\_names.csv* file. This file contains the
names of the model explanatory variables. You can use this when you
quickly want to check the names of the explanatory variables, e.g., when
using *r.maxent.predict*.

## EXAMPLE

The examples below use a dataset that you can download [from
here](https://ecodiv.earth/share/reader_SDM/grassmaxent_sampledata.zip).
It includes a vector point layer with observation locations of the
pale-throated sloth (*Bradypus tridactylus*) from
[GBIF](https://doi.org/10.15468/dl.br8b4a), the [IUCN RedList range
map](https://www.iucnredlist.org/species/3037/210442660) of the species,
a boundary layer of the South American countries from
[NaturalEarth](https://www.naturalearthdata.com/downloads/50m-cultural-vectors/)
and a number of bioclim raster layers from
[WorldClim](https://www.worldclim.org/) version 2.1, representing the
climate conditions representing the period 1970-2000 and the climate
conditions predicted for 2061–2080 based on the GCM BCC-CSM2-MR and SSP
585.

The zip file contains a folder *sampledata*. This is a location with
five subfolders *PERMANENT*, *sloth*, *current*, *future* and *model01*.
Copy this Location to a GRASS Database (use an existing one or create
one first). If you are not familiar with the concept of *Locations* and
*Mapsets*, please first read the
[explanation](https://grass.osgeo.org/grass83/manuals/grass_database.html)
about the GRASS GIS database.

Unzip the file, start up GRASS GIS, open the GRASS GIS database to which
you copied the folder *sampledata*, switch to the Location *sampledata*
and open the mapset *model01*. This mapset should have access to the
other mapsets.

### 1: Data preparation

You can use the *v.maxent.swd* to create the required input layers. The
code below creates the SWD file with the locations where the species has
been recorded (**species\_output**) and a SWD file with randomly created
background point locations (**bgr\_ouput**). The SWD files contain, for
each location, the values of the raster layers selected with the
**evp\_maps** parameter. With the parameter **export\_rasters** you tell
the addon to export the raster layers as well.

```sh
v.maxent.swd -t \
 species=Bradypus_tridactylus \
 evp_maps=bio02,bio03,bio08,bio09,bio13,bio15,bio17 \
 evp_cat=sa_eco_l2@current \
 alias_cat=landuse \
 nbgp=10000 \
 bgr_output=bgrd_swd.csv \
 species_output=spec_swd.csv \
 export_rasters=envlayers
```

The output is a folder with the so-called SWD files with the XY
coordinates for the species presence location (*spec\_swd.csv*) and the
background locations (*bgrd\_swd.csv*. Both also include the values of
the input raster layers for the given point locations. In addition,
there is the subfolder *envlayers* with the environmental raster layers
in *ascii* format.

### 2: Train the model

Use the output of *v.maxent.swd* as input for *r.maxent.train*. First
create a subfolder *output\_model1*, so we can write the output to that
folder.

The **projectionlayers** parameter is optionally. If you set it, a
raster prediction layer will be created that represent the potential
suitability distribution under current conditions (the conditions used
to train the model).

With the **-y** and **-b** flags the point layers with the sample
predictions and the predictions at the background point locations are
created. Their values correspond to the values of the raster prediction
layer.

```sh
r.maxent.train -y -b -g \
  samplesfile=spec_swd.csv \
  environmentallayersfile=bgrd_swd.csv \
  togglelayertype=landuse \
  projectionlayers=envlayers \
  samplepredictions=model_1_samplepred \
  backgroundpredictions=model_1_bgrdpred \
  predictionlayer=model_1_suitability_current \
  outputdirectory=output_model1
```

When *r.maxent.train* is finished, go to the output folder and open the
*Bradypus\_tridactylus.html* file for an explanation of the different
model outputs and model evaluation statistics. For a more detailed
explanation, see the tutorial on the [Maxent
website](https://biodiversityinformatics.amnh.org/open_source/maxent/).

In your current mapset, you'll find the raster prediction layer, and the
sample and background point layers with the predicted values.

[![image-alt](r_maxent_train_01.png)](r_maxent_train_01.png)  
*The example creates the prediction raster layer
'model\_1\_suitability\_current', the sample point layer
'model\_1\_samplepred' and the background point layer 'model\_bgrdpred'
(for the latter, only part of the map is shown here).*

### 3: Create a prediction layer

The third step is to use the model created in the previous step to
predict the species suitability distribution under future climates.
Note, we are going to make the (unrealistic) assumption that the
ecosystems do not change.

```sh
r.maxent.predict
  lambda=output_model1/Bradypus_tridactylus.lambdas \
  rasters=bio02_ssp585,bio03_ssp585,bio08_ssp585,bio09_ssp585,bio13_ssp585,bio15_ssp585,bio17_ssp585,sa_eco_l2 \
  variables=bio02,bio03,bio08,bio09,bio13,bio15,bio17,landuse \
  output=model_1_ssp585
```

The resulting layer is written to the current mapset as
*model\_1\_ssp585* (right map in the figure below). The results suggest
the area with suitable conditions will increase under future climates
compared the that under the current conditions (left map in the figure
below). This result is unexpected, and warrants further investigation.

[![image-alt](r_maxent_train_02.png)](r_maxent_train_02.png)  
*Predicted suitabilty for the period 2061-2080 based on the GCM
BCC-CSM2-MR and SSP 585.*

## REFERENCES

- Steven J. Phillips, Miroslav Dudík, Robert E. Schapire. 2020: Maxent
    software for modeling species niches and distributions (Version
    3.4.1). Available from url:
    <https://biodiversityinformatics.amnh.org/open_source/maxent> and
    <https://github.com/mrmaxent/Maxent>
- Steven J. Phillips, Miroslav Dudík, Robert E. Schapire. 2004: A
    maximum entropy approach to species distribution modeling. In
    Proceedings of the Twenty-First International Conference on Machine
    Learning, pages 655-662, 2004.
- Steven J. Phillips, Robert P. Anderson, Robert E. Schapire. 2006:
    Maximum entropy modeling of species geographic distributions.
    Ecological Modelling, 190:231-259, 2006.
- Jane Elith, Steven J. Phillips, Trevor Hastie, Miroslav Dudík, Yung
    En Chee, Colin J. Yates. 2011: A statistical explanation of MaxEnt
    for ecologists. Diversity and Distributions, 17:43-57, 2011.

## SEE ALSO

- [v.maxent.swd](v.maxent.swd.md), creating species and background swd
    files and prediction rasters that can be used directly by the
    *r.maxent.train* addon (or the Maxent software itself) to create
    species distribution models.
- [r.out.maxent\_swd](r.out.maxent_swd.html), creating species and
    background swd files based on species distribution data in raster
    format.
- [r.maxent.predict](r.maxent.predict.md), creating a suitability
    layer based on a set of environmental layers and a Maxent model,
    e.g., created using the r.maxent.train addon.
- [r.maxent.setup](r.maxent.setup.html), helper function to allow
    GRASS to use Maxent.

## AUTHOR

[Paulo van Breugel](https://ecodiv.earth), [HAS green
academy](https://has.nl), [Innovative Biomonitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/),
[Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)

## SOURCE CODE

Available at: [r.maxent.train source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.maxent.train)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.maxent.train))  
Latest change: Sunday Jan 04 01:18:51 2026 in commit [f3e4ad2](https://github.com/OSGeo/grass-addons/commit/f3e4ad27f339685d6511d4d80f839bbc2c9c4ee0)
