---
name: r.mcda.output.py
description: Exports criteria raster maps and decision raster map in a *.isf file (e.g. 4eMka2, jMAF) for dominance rough set approach analysis.
keywords: [ raster, Dominance Rough Set Approach, Multi Criteria Decision Analysis (MCDA) ]
---

# r.mcda.output.py

Exports criteria raster maps and decision raster map in a *.isf file (e.g. 4eMka2, jMAF) for dominance rough set approach analysis.

=== "Command line"

    **r.mcda.output.py**
    **attributes**=*name* [,*name*,...]
    **preferences**=*character*
    **decision**=*name*
    **output**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mcda.output.py attributes=name preferences=character decision=name output=infosys.isf
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mcda.output.py***",
        **attributes**,
        **preferences**,
        **decision**,
        **output**=*"infosys.isf"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mcda.output.py", attributes="name", preferences="character", decision="name", output="infosys.isf")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mcda_output_py*(**attributes**,
        **preferences**,
        **decision**,
        **output**=*"infosys.isf"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mcda_output_py(attributes="name", preferences="character", decision="name", output="infosys.isf")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **attributes**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    **preferences**=*character* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;gain,cost,none  
    **decision**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of decision raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (\*.isf file, Information System)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *infosys.isf*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **attributes** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **preferences** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;gain,cost,none  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *character*  
    **decision** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of decision raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (\*.isf file, Information System)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *infosys.isf*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **attributes** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of criteria raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **preferences** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;gain,cost,none  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *character*  
    **decision** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of decision raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (\*.isf file, Information System)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *infosys.isf*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.mcda.output* module will export raster maps as a \*isf file
readable in jMAF, JAMM or 4eMka2 sofware [Laboratory of Intelligent
Decision Support Systems - Poznan
University.](http://idss.cs.put.poznan.pl/)

## NOTES

This module, as all GRASS raster modules, will export cells based on the
current region settings. See the *g.region* module for details.

## SEE ALSO

*[r.roughset](r.roughset.md), [r.mcda.regime](r.mcda.regime.md)
[r.mcda.fuzzy](r.mcda.fuzzy.md) [r.mcda.electre](r.mcda.electre.md)
[r.mcda.roughset](r.mcda.roughset.md), [r.mcda.input](r.mcda.input.md)*

## AUTHORS

Antonio Boggia - Gianluca Massei  
Department of Economics and Appraisal - University of Perugia - Italy

## SOURCE CODE

Available at: [r.mcda.output source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mcda.output)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mcda.output))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
