---
name: r.meb.py
description: Compute the multivariate environmental bias (MEB)
keywords: [ similarity, raster, modelling ]
---

# r.meb.py

Compute the multivariate environmental bias (MEB)

=== "Command line"

    **r.meb.py**
    [**-imno**]
    **env**=*names* [,*names*,...]
    **ref**=*names*
    [**output**=*names*]
    [**file**=*name*]
    [**digits**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.meb.py env=names ref=names
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.meb.py***",
        **env**,
        **ref**,
        **output**=*None*,
        **file**=*None*,
        **digits**=*5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.meb.py", env="names", ref="names")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_meb_py*(**env**,
        **ref**,
        **output**=*None*,
        **file**=*None*,
        **digits**=*5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_meb_py(env="names", ref="names")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **env**=*names* [,*names*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Environmental layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) of environmental conditions  
    **ref**=*names* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference area  
    &nbsp;&nbsp;&nbsp;&nbsp;Sub-area (1) within region (1+0) for which to compute the EB  
    **output**=*names*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root of name output layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Output MES layer (and root for IES layers if kept)  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file (csv format)  
    **digits**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision of your input layers values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Compute EB for individual variables  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use mean values of IES layers to compute MES  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use median values of IES layers to compute MES  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use minimum values of IES layers to compute MES  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **env** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Environmental layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) of environmental conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **ref** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference area  
    &nbsp;&nbsp;&nbsp;&nbsp;Sub-area (1) within region (1+0) for which to compute the EB  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root of name output layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Output MES layer (and root for IES layers if kept)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *names*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file (csv format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **digits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision of your input layers values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *m*, *n*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute EB for individual variables  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use mean values of IES layers to compute MES  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use median values of IES layers to compute MES  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use minimum values of IES layers to compute MES  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **env** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Environmental layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) of environmental conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **ref** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference area  
    &nbsp;&nbsp;&nbsp;&nbsp;Sub-area (1) within region (1+0) for which to compute the EB  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root of name output layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Output MES layer (and root for IES layers if kept)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *names*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output text file (csv format)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **digits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision of your input layers values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *m*, *n*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute EB for individual variables  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use mean values of IES layers to compute MES  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use median values of IES layers to compute MES  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use minimum values of IES layers to compute MES  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The Multivariate Environmental Bias (MEB) takes the medium conditions in
an reference area *N* and computes how much conditions in a subset of
*N* (*S*) deviate from these medium conditions (van Breugel et al.
2015). This can for example be used to see how well conditions in the
protected areas of a country represent conditions in the whole country.

The measure is based on the Multivariate Environmental Similarity
(*MES*) surface, which was proposed by Elith et al (2010). The MESS
measures the similarity in a set of variables between any given location
in an area and the locations in a reference area.

The first step to compute the MES for a location *P* is to calculate how
similar conditions in *P* are compared to the conditions in the
reference area *N*, based on variable *V<sub>i</sub>*. The similarity is
expressed as the deviation from *V<sub>i</sub>* in *P* from the median
of *V<sub>i</sub>* in *N*. This is done for all variables of interest
(V<sub>1</sub>, V<sub>2</sub>, ...V<sub>j</sub>).

In the original equation proposed by Elith et al (2010) the final *MES*
in location *P* is computed as the minimum of the similarity values
(*IES<sub>minimum</sub>*) of the individual variables (*V<sub>j</sub>*)
in *P*. However, to compute the *MEB* using the mean or median may be a
better choice as they take into account the similarity along all
environmnetal axes and not only the one that deviates most. The user
therefore has the option to use the mean (*IES<sub>mean</sub>*) or
median (*IES<sub>median</sub>*) of the *IES* instead (there is still the
option to use the minimum as well).

The *MEB* is computed as the absolute difference of the median of the
*MES* in the whole target area (MES<sub>N</sub>) and the median of the
*MES* in the subset (*MES<sub>S</sub>*), divided by the median absolute
deviation
(*[MAD](https://en.wikipedia.org/wiki/Median_absolute_deviation)*) of
the *MES* in *N*. It is also possible to compute the bias based on the
individual variables (IEB) in which case the *IES* instead of the *MES*
is used.

![image-alt](r_meb_concept.png)

The addon creates a MES layer and a table (saved to csv file) with the
median value of each variable in the region and in the reference area,
the median absolute deviation (mad) and the environmental bias (eb).
Optionally, this can be computed for the individual variables as well.
The user has the option to have the addon compute the *MEB* based on the
*MES* computed using the minimum, average and/or median of the IES
layers (see above)

## NOTE

Input variables are expected to be or to represent continuous variables.

## Example

In the example below the *MEB* is computed for a map 'forestmap' which
gives the distribution of forest (1) and other land cover types (0). As
environmental variables, the bio1, bio3 and bio9 are used.

```sh
r.meb -m -n -o env=bio_1,bio_3,bio_9 ref=forestmap
output=Test file=Test
Median Test_MES_mean (all region) = 47.338
Median Test_MES_mean (ref. area) = 69.798
MAD Test_MES_mean (all region) = 14.594
EB = 1.539

Median Test_MES_median (all region) = 45.712
Median Test_MES_median (ref. area) = 69.897
MAD Test_MES_median (all region) = 18.786
EB = 1.287

Median Test_MES_minimum (all region) = 20.364
Median Test_MES_minimum (ref. area) = 55.807
MAD Test_MES_minimum (all region) = 15.096
EB = 2.348

The results are written to Test.csv
```

## CITATION

van Breugel P, Kindt R, Lillesø J-PB, van Breugel M (2015) Environmental
Gap Analysis to Prioritize Conservation Efforts in Eastern Africa. PLoS
ONE 10(4): e0121444. doi: 10.1371/journal.pone.0121444

## REFERENCES

- Elith, J, Kearney, M, and Phillips, S. 2010. The art of modelling
    range-shifting species. Methods in Ecology and Evolution 1:330-342.
- van Breugel P, Kindt R, Lillesø J-PB, van Breugel M. 2015.
    Environmental Gap Analysis to Prioritize Conservation Efforts in
    Eastern Africa. PLoS ONE 10(4): e0121444. doi:
    10.1371/journal.pone.0121444.

## SEE ALSO

*[r.mess](r.mess.md)*

## AUTHOR

Paulo van Breugel, paulo at ecodiv.earth

## SOURCE CODE

Available at: [r.meb source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.meb)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.meb))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
