---
name: r.mess.py
description: Computes multivariate environmental similarity surface (MES)
keywords: [ similarity, raster, modelling ]
---

# r.mess.py

Computes multivariate environmental similarity surface (MES)

=== "Command line"

    **r.mess.py**
    [**-mnkci**]
    **ref_env**=*names* [,*names*,...]
    [**ref_rast**=*name*]
    [**ref_vect**=*name*]
    [**ref_region**=*name*]
    [**proj_env**=*names* [,*names*,...]]
    [**proj_region**=*name*]
    **output**=*name*
    [**digits**=*string*]
    [**nprocs**=*integer*]
    [**memory**=*memory in MB*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mess.py ref_env=names output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mess.py***",
        **ref_env**,
        **ref_rast**=*None*,
        **ref_vect**=*None*,
        **ref_region**=*None*,
        **proj_env**=*None*,
        **proj_region**=*None*,
        **output**,
        **digits**=*3*,
        **nprocs**=*0*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mess.py", ref_env="names", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mess_py*(**ref_env**,
        **ref_rast**=*None*,
        **ref_vect**=*None*,
        **ref_region**=*None*,
        **proj_env**=*None*,
        **proj_region**=*None*,
        **output**,
        **digits**=*3*,
        **nprocs**=*0*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mess_py(ref_env="names", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ref_env**=*names* [,*names*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference conditions  
    **ref_rast**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference area (raster)  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference areas (1 = presence, 0 or null = absence)  
    **ref_vect**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference points (vector)  
    &nbsp;&nbsp;&nbsp;&nbsp;Point vector layer with reference locations  
    **ref_region**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference region  
    &nbsp;&nbsp;&nbsp;&nbsp;Region with reference conditions  
    **proj_env**=*names* [,*names*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Projected conditions  
    **proj_region**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projection region  
    &nbsp;&nbsp;&nbsp;&nbsp;Region with projected conditions  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Root name of the output MESS data layers  
    **digits**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision of your input layers values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-6*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate Most dissimilar variable (MoD)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Area with negative MESS  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;sum(IES), where IES &lt; 0  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of IES layers with values &lt; 0  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove individual environmental similarity layers (IES)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ref_env** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **ref_rast** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference area (raster)  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference areas (1 = presence, 0 or null = absence)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ref_vect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference points (vector)  
    &nbsp;&nbsp;&nbsp;&nbsp;Point vector layer with reference locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **ref_region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference region  
    &nbsp;&nbsp;&nbsp;&nbsp;Region with reference conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **proj_env** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projected conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **proj_region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projection region  
    &nbsp;&nbsp;&nbsp;&nbsp;Region with projected conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root name of the output MESS data layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **digits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision of your input layers values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-6*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *n*, *k*, *c*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate Most dissimilar variable (MoD)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Area with negative MESS  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;sum(IES), where IES &lt; 0  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Number of IES layers with values &lt; 0  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove individual environmental similarity layers (IES)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ref_env** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **ref_rast** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference area (raster)  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference areas (1 = presence, 0 or null = absence)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ref_vect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference points (vector)  
    &nbsp;&nbsp;&nbsp;&nbsp;Point vector layer with reference locations  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **ref_region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference region  
    &nbsp;&nbsp;&nbsp;&nbsp;Region with reference conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **proj_env** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projected conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *names*  
    **proj_region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projection region  
    &nbsp;&nbsp;&nbsp;&nbsp;Region with projected conditions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Root name of the output MESS data layers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **digits** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Precision of your input layers values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-6*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *n*, *k*, *c*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate Most dissimilar variable (MoD)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Area with negative MESS  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;sum(IES), where IES &lt; 0  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Number of IES layers with values &lt; 0  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove individual environmental similarity layers (IES)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.mess* computes the multivariate environmental similarity (MES) \[1\],
which measures how similar environmental conditions in one area are to
those in a reference area. This can also be used to compare
environmental conditions between current and future scenarios. See the
supplementary materials of Elith et al. (2010) \[1\] for more details.

Besides the MES, *r.mess* computes the individual similarity layers (IES

- the user can select to delete these layers) and, optionally, several
other layers that help to further interpret the MES values:

  - The area where for at least one of the variables has a value that
    falls outside the range of values found in the reference set.
  - The most dissimilar variable (MoD).
  - The sum of the IES layers where IES \< 0. This is similar to the NT1
    measure as proposed by Mesgaran et al. 2014 \[2\].
  - The number of layers with negative values.

The user can compare a set of reference (baseline) conditions to
projected (test) conditions. The reference conditions are defined by a
set of environmental raster layers (**ref\_env**). To specify the
reference area, one of the following can be used:

- **ref\_rast** = reference raster layer: A raster with values of 1
    and 0 (or nodata). Reference conditions are derived from the
    locations where the raster value is 1.
- **ref\_vect** = reference vector point layer: Reference conditions
    are taken for the point locations in the vector layer.
- **ref\_region** = reference region: Only areas within the specified
    region's boundaries are considered as the reference area.

If no reference raster map, vector map, or region is provided, the
entire area covered by the input environmental raster layers is used as
the reference area.

The projected (test) conditions are defined by a second set of
environmental variables (**proj\_env**). They can represent future
conditions in the same area (similarity across time), or conditions in
another area (similarity between two different areas). If a projection
region (**proj\_region**) is provided, the MESS (and other layers) will
be limited to that region.

If **proj\_env** is not provided, the MESS value of a raster cell
represents how similar the conditions in that cell are compared to the
medium conditions across the whole area.

## EXAMPLE

The examples below use the bioclimatic variables bio1 (mean annual
temperature), bio12 (annual precipitation), and bio15 (precipitation
seasonality) in Kenya and Uganda. All climate layers (current and
future) are from [Worldclim.org](http://www.worldclim.org). The
protected areas layer includes all nationally designated protected areas
with a IUCN category of II or higher from
[protectedplanet.net](http://www.protectedplanet.net/).

### Example 1

The simplest case is when only a set of reference data layers
(**ref\_env** ) is provided. The multi-variate similarity values of the
resulting map are a measure of how similar conditions in a location are
to the median conditions in the whole region.

```sh
g.region raster=bio1
r.mess ref_env=bio1,bio12,bio15 output=Ex_01
```

Thus, in the following maps, the value in each pixel represents how
similar conditions are in that pixel to the median conditions in the
entire region, in terms of mean annual temperature (bio1), mean annual
precipitation (bio12), precipitation seasonality (bio15) and the three
combined (MES).

![image-alt](r_mess_Ex_01.png)

### Example 2

In the second example, conditions in the whole region are compared to
those in the region's protected areas (ppa), which thus serves as the
reference/sample area. See [van Breugel et
al.(2015)](https://doi.org/10.1371/journal.pone.0121444) \[3\] for an
example of how this can be useful.

```sh
g.region raster=bio1
r.mess -m -n -i ref_env=bio1,bio12,bio15 ref_rast=ppa output=Ex_02
```

In the figure below the map with the protected areas, the MES, the most
dissimilar variables, and the areas with novel conditions are given.
They show that the protected areas cover most of the region's annual
precipitation, mean annual temperature, and precipitation seasonality
gradients. Areas with novel conditions can be found in northern Kenya.

![image-alt](r_mess_Ex_02.png)

### Example 3

Similarity between long-term average conditions based on the period
1950-2000 (**ref\_env**) and projections for climate conditions in 2070
under RCP85 based on the IPSL General Circulation Models (
**proj\_env**). No reference points or areas are defined in this
example, so the whole region is used as a reference.

```sh
g.region raster=bio1
r.mess ref_env=bio1,bio12,bio15 proj_env=IPSL_bio1,IPSL_bio12,IPSL_bio15
output=Ex_03
```

Results (below) shows that there is a fairly large area with novel
conditions. Note that in the *MES* map, the values are based on the
highest negative value across the input variables (here bio1, bio12,
bio15). In the *SumNeg* map, values of all input variables are summed
when negative. The *Count* map shows for each raster cell how many
variables have negative similarity scores. Thus, the values in the *MES*
and *SumNeg* maps only differ where the MES of more than one variable is
negative (dark gray areas in the *Count* map).

![image-alt](r_mess_Ex_03.png)

## REFERENCES

\[1\] Elith, J., Kearney, M., & Phillips, S. 2010. The art of modelling
range-shifting species. Methods in Ecology and Evolution 1:330-342.

\[2\] Mesgaran, M.B., Cousens, R.D. & Webber, B.L. (2014) Here be
dragons: a tool for quantifying novelty due to covariate range and
correlation change when projecting species distribution models.
Diversity & Distributions, 20: 1147-1159, DOI: 10.1111/ddi.12209.

\[3\] van Breugel, P., Kindt, R., Lillesø, J.-P.B., & van Breugel, M.
2015. Environmental Gap Analysis to Prioritize Conservation Efforts in
Eastern Africa. PLoS ONE 10: e0121444.

## SEE ALSO

For an example of using the *r.mess* addon as part of a modeling
workflow, see the tutorial [Species distribution modeling using Maxent
in GRASS GIS](https://ecodiv.earth/TutorialsNotes/sdmingrassgis/).

## AUTHOR

Paulo van Breugel, <https://ecodiv.earth> | HAS green academy University
of Applied Sciences | [Innovative Biomonitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/)
| [Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)

## SOURCE CODE

Available at: [r.mess source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.mess)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.mess))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
